/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.rollup.action.index;

import io.lucenia.indexmanagement.IndexManagementIndices;
import io.lucenia.indexmanagement.rollup.action.index.IndexRollupRequest;
import io.lucenia.indexmanagement.rollup.action.index.IndexRollupResponse;
import io.lucenia.indexmanagement.rollup.model.Rollup;
import io.lucenia.indexmanagement.rollup.util.RollupFieldValueExpressionResolver;
import io.lucenia.indexmanagement.rollup.util.RollupUtils;
import io.lucenia.indexmanagement.settings.IndexManagementSettings;
import io.lucenia.indexmanagement.util.IndexUtils;
import io.lucenia.indexmanagement.util.SecurityUtils;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.common.xcontent.XContentFactory;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.DocWriteRequest;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.action.get.GetRequest;
import io.skylite.core.action.get.GetResponse;
import io.skylite.core.action.index.IndexRequest;
import io.skylite.core.action.index.IndexResponse;
import io.skylite.core.action.replication.ReplicationResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.security.auth.User;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.ToXContent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportIndexRollupAction
extends HandledTransportAction<IndexRollupRequest, IndexRollupResponse> {
    private final Client client;
    private final IndexManagementIndices indexManagementIndices;
    private final ClusterService clusterService;
    private final Settings settings;
    private final NamedXContentRegistry xContentRegistry;
    private final Logger log = LogManager.getLogger(TransportIndexRollupAction.class);
    private volatile boolean filterByEnabled;

    @Inject
    public TransportIndexRollupAction(TransportService transportService, Client client, ActionFilters actionFilters, IndexManagementIndices indexManagementIndices, ClusterService clusterService, Settings settings, NamedXContentRegistry xContentRegistry) {
        super("cluster:admin/lucenia/rollup/index", transportService, actionFilters, IndexRollupRequest::new);
        this.client = client;
        this.indexManagementIndices = indexManagementIndices;
        this.clusterService = clusterService;
        this.settings = settings;
        this.xContentRegistry = xContentRegistry;
        this.filterByEnabled = (Boolean)IndexManagementSettings.FILTER_BY_BACKEND_ROLES.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(IndexManagementSettings.FILTER_BY_BACKEND_ROLES, it -> {
            this.filterByEnabled = it;
        });
    }

    protected void doExecute(Task task, IndexRollupRequest request, ActionListener<IndexRollupResponse> listener) {
        IndexRollupHandler handler = new IndexRollupHandler(this.client, listener, request);
        handler.start();
    }

    class IndexRollupHandler {
        private final Client client;
        private final ActionListener<IndexRollupResponse> actionListener;
        private final IndexRollupRequest request;
        private final User user;

        IndexRollupHandler(Client client, ActionListener<IndexRollupResponse> actionListener, IndexRollupRequest request) {
            this.client = client;
            this.actionListener = actionListener;
            this.request = request;
            this.user = SecurityUtils.buildUser(client.threadPool().getThreadContext(), request.getRollup().getUser());
        }

        void start() {
            TransportIndexRollupAction.this.log.debug("User and roles string from thread context: {}", this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
            try (ThreadContext.StoredContext ignored = this.client.threadPool().getThreadContext().stashContext();){
                if (!SecurityUtils.validateUserConfiguration(this.user, TransportIndexRollupAction.this.filterByEnabled, this.actionListener)) {
                    return;
                }
                TransportIndexRollupAction.this.indexManagementIndices.checkAndUpdateIMConfigIndex((ActionListener<AcknowledgedResponse>)ActionListener.wrap(this::onCreateMappingsResponse, arg_0 -> this.actionListener.onFailure(arg_0)));
            }
        }

        void onCreateMappingsResponse(AcknowledgedResponse response) {
            if (response.isAcknowledged()) {
                TransportIndexRollupAction.this.log.info("Successfully created or updated {} with newest mappings.", (Object)".opendistro-ism-config");
                if (this.request.opType() == DocWriteRequest.OpType.CREATE) {
                    if (!this.validateTargetIndexName()) {
                        this.actionListener.onFailure((Exception)((Object)new SkyliteStatusException("target_index value is invalid: " + this.request.getRollup().getTargetIndex(), RestStatus.BAD_REQUEST, new Object[0])));
                        return;
                    }
                    this.putRollup();
                } else {
                    this.getRollup();
                }
            } else {
                String message = "Unable to create or update .opendistro-ism-config with newest mapping.";
                TransportIndexRollupAction.this.log.error(message);
                this.actionListener.onFailure((Exception)((Object)new SkyliteStatusException(message, RestStatus.INTERNAL_SERVER_ERROR, new Object[0])));
            }
        }

        void getRollup() {
            GetRequest getRequest = new GetRequest(".opendistro-ism-config", this.request.getRollup().getId());
            this.client.get(getRequest, ActionListener.wrap(this::onGetRollup, arg_0 -> this.actionListener.onFailure(arg_0)));
        }

        void onGetRollup(GetResponse response) {
            Rollup rollup;
            if (!response.isExists()) {
                this.actionListener.onFailure((Exception)((Object)new SkyliteStatusException("Rollup not found", RestStatus.NOT_FOUND, new Object[0])));
                return;
            }
            try {
                rollup = RollupUtils.parseRollup(response, TransportIndexRollupAction.this.xContentRegistry);
            }
            catch (IOException | IllegalArgumentException e) {
                this.actionListener.onFailure((Exception)((Object)new SkyliteStatusException("Rollup not found", RestStatus.NOT_FOUND, new Object[0])));
                return;
            }
            if (!SecurityUtils.userHasPermissionForResource(this.user, rollup.getUser(), TransportIndexRollupAction.this.filterByEnabled, "rollup", rollup.getId(), this.actionListener)) {
                return;
            }
            List<String> modified = this.modifiedImmutableProperties(rollup, this.request.getRollup());
            if (!modified.isEmpty()) {
                this.actionListener.onFailure((Exception)((Object)new SkyliteStatusException("Not allowed to modify " + String.valueOf(modified), RestStatus.BAD_REQUEST, new Object[0])));
                return;
            }
            if (!this.validateTargetIndexName()) {
                this.actionListener.onFailure((Exception)((Object)new SkyliteStatusException("target_index value is invalid: " + this.request.getRollup().getTargetIndex(), RestStatus.BAD_REQUEST, new Object[0])));
                return;
            }
            this.putRollup();
        }

        List<String> modifiedImmutableProperties(Rollup rollup, Rollup newRollup) {
            ArrayList<String> modified = new ArrayList<String>();
            if (rollup.getContinuous() != newRollup.getContinuous()) {
                modified.add("continuous");
            }
            if (!rollup.getDimensions().equals(newRollup.getDimensions())) {
                modified.add("dimensions");
            }
            if (!rollup.getMetrics().equals(newRollup.getMetrics())) {
                modified.add("metrics");
            }
            if (!rollup.getSourceIndex().equals(newRollup.getSourceIndex())) {
                modified.add("source_index");
            }
            if (!rollup.getTargetIndex().equals(newRollup.getTargetIndex())) {
                modified.add("target_index");
            }
            return modified;
        }

        void putRollup() {
            final Rollup rollup = new Rollup.Builder(this.request.getRollup()).schemaVersion(IndexUtils.getIndexManagementConfigSchemaVersion()).user(this.user).build();
            try {
                ((IndexRequest)this.request.index(".opendistro-ism-config")).id(this.request.getRollup().getId()).source(rollup.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS)).timeout(IndexRequest.DEFAULT_TIMEOUT);
            }
            catch (IOException e) {
                this.actionListener.onFailure((Exception)e);
                return;
            }
            this.client.index((IndexRequest)this.request, (ActionListener)new ActionListener<IndexResponse>(){

                public void onResponse(IndexResponse response) {
                    if (response.getShardInfo().getFailed() > 0) {
                        StringBuilder failureReasons = new StringBuilder();
                        for (ReplicationResponse.ShardInfo.Failure failure : response.getShardInfo().getFailures()) {
                            failureReasons.append(failure.reason()).append(", ");
                        }
                        IndexRollupHandler.this.actionListener.onFailure((Exception)((Object)new SkyliteStatusException(failureReasons.toString(), response.status(), new Object[0])));
                    } else {
                        RestStatus status = IndexRollupHandler.this.request.opType() == DocWriteRequest.OpType.CREATE ? RestStatus.CREATED : RestStatus.OK;
                        IndexRollupHandler.this.actionListener.onResponse((Object)new IndexRollupResponse(response.getId(), response.getVersion(), response.getSeqNo(), response.getPrimaryTerm(), status, new Rollup.Builder(rollup).seqNo(response.getSeqNo()).primaryTerm(response.getPrimaryTerm()).build()));
                    }
                }

                public void onFailure(Exception e) {
                    IndexRollupHandler.this.actionListener.onFailure(e);
                }
            });
        }

        boolean validateTargetIndexName() {
            String targetIndexResolvedName = RollupFieldValueExpressionResolver.resolve(this.request.getRollup(), this.request.getRollup().getTargetIndex());
            return !targetIndexResolvedName.contains("*") && !targetIndexResolvedName.contains("?");
        }
    }
}

