/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.rollup.action.mapping;

import io.lucenia.indexmanagement.indexstatemanagement.util.RestHandlerUtils;
import io.lucenia.indexmanagement.rollup.action.mapping.UpdateRollupMappingAction;
import io.lucenia.indexmanagement.rollup.action.mapping.UpdateRollupMappingRequest;
import io.lucenia.indexmanagement.rollup.util.RollupFieldValueExpressionResolver;
import io.skylite.common.action.ActionListener;
import io.skylite.common.xcontent.XContentFactory;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.admin.indices.mapping.put.PutMappingRequest;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.action.support.clustermanager.TransportClusterManagerNodeAction;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.block.ClusterBlockException;
import io.skylite.core.cluster.block.ClusterBlockLevel;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.metadata.MappingMetadata;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentHelper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportUpdateRollupMappingAction
extends TransportClusterManagerNodeAction<UpdateRollupMappingRequest, AcknowledgedResponse> {
    private final Client client;
    private final Logger log = LogManager.getLogger(TransportUpdateRollupMappingAction.class);

    @Inject
    public TransportUpdateRollupMappingAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client) {
        super(UpdateRollupMappingAction.INSTANCE.name(), transportService, clusterService, threadPool, actionFilters, UpdateRollupMappingRequest::new, indexNameExpressionResolver);
        this.client = client;
    }

    protected String executor() {
        return "same";
    }

    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    protected ClusterBlockException checkBlock(UpdateRollupMappingRequest request, ClusterState state) {
        String targetIndexResolvedName = RollupFieldValueExpressionResolver.resolve(request.getRollup(), request.getRollup().getTargetIndex());
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, new String[]{targetIndexResolvedName});
    }

    protected void clusterManagerOperation(UpdateRollupMappingRequest request, ClusterState state, final ActionListener<AcknowledgedResponse> listener) throws Exception {
        Map rollup;
        String targetIndexResolvedName = RollupFieldValueExpressionResolver.resolve(request.getRollup(), request.getRollup().getTargetIndex());
        IndexMetadata index = state.metadata().index(targetIndexResolvedName);
        if (index == null) {
            this.log.debug("Could not find index [{}]", (Object)targetIndexResolvedName);
            listener.onFailure((Exception)new IllegalStateException("Could not find index [" + targetIndexResolvedName + "]"));
            return;
        }
        MappingMetadata mappings = index.mapping();
        if (mappings == null) {
            this.log.debug("Could not find mapping for index [{}]", (Object)targetIndexResolvedName);
            listener.onFailure((Exception)new IllegalStateException("Could not find mapping for index [" + targetIndexResolvedName + "]"));
            return;
        }
        Map source = mappings.sourceAsMap();
        if (source == null) {
            this.log.debug("Could not find source for index mapping [{}]", (Object)targetIndexResolvedName);
            listener.onFailure((Exception)new IllegalStateException("Could not find source for index mapping [" + targetIndexResolvedName + "]"));
            return;
        }
        try {
            rollup = (Map)XContentHelper.convertToMap((BytesReference)BytesReference.bytes((XContentBuilder)request.getRollup().toXContent(XContentFactory.jsonBuilder(), (ToXContent.Params)RestHandlerUtils.XCONTENT_WITHOUT_TYPE)), (boolean)false, (MediaType)MediaTypeRegistry.JSON).v2();
        }
        catch (IOException e) {
            listener.onFailure((Exception)e);
            return;
        }
        HashMap metaMappings = new HashMap();
        Object meta = source.get("_meta");
        if (meta == null) {
            this.log.debug("Could not find meta mappings for index [{}], creating meta mappings", (Object)targetIndexResolvedName);
            HashMap<String, Map> rollupJobEntries = new HashMap<String, Map>();
            rollupJobEntries.put(request.getRollup().getId(), rollup);
            HashMap<String, HashMap<String, Map>> rollups = new HashMap<String, HashMap<String, Map>>();
            rollups.put("rollups", rollupJobEntries);
            metaMappings.put("_meta", rollups);
        } else {
            Map metaMap = (Map)meta;
            Object rollupsObj = metaMap.get("rollups");
            if (rollupsObj == null) {
                this.log.debug("Could not find meta rollup mappings for index [{}], creating meta rollup mappings", (Object)targetIndexResolvedName);
                HashMap<String, Map> rollupJobEntries = new HashMap<String, Map>();
                rollupJobEntries.put(request.getRollup().getId(), rollup);
                HashMap<String, HashMap<String, Map>> updatedRollups = new HashMap<String, HashMap<String, Map>>();
                updatedRollups.put("rollups", rollupJobEntries);
                metaMappings.put("_meta", updatedRollups);
            } else {
                Map rollups = (Map)rollupsObj;
                if (rollups.containsKey(request.getRollup().getId())) {
                    this.log.debug("Meta rollup mappings already contain rollup {} for index [{}]", (Object)request.getRollup().getId(), (Object)targetIndexResolvedName);
                    listener.onFailure((Exception)new IllegalStateException("Meta rollup mappings already contain rollup " + request.getRollup().getId() + " for index [" + targetIndexResolvedName + "]"));
                    return;
                }
                HashMap<String, Map> rollupJobEntries = new HashMap<String, Map>(rollups);
                rollupJobEntries.put(request.getRollup().getId(), rollup);
                HashMap<String, HashMap<String, Map>> updatedRollups = new HashMap<String, HashMap<String, Map>>();
                updatedRollups.put("rollups", rollupJobEntries);
                metaMappings.put("_meta", updatedRollups);
            }
        }
        PutMappingRequest putMappingRequest = new PutMappingRequest(new String[]{targetIndexResolvedName}).source(metaMappings);
        this.client.admin().indices().putMapping(putMappingRequest, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse response) {
                listener.onResponse((Object)response);
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }
}

