/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.rollup.action.start;

import io.lucenia.indexmanagement.luceniaapi.ContentParserUtils;
import io.lucenia.indexmanagement.rollup.action.start.StartRollupRequest;
import io.lucenia.indexmanagement.rollup.model.Rollup;
import io.lucenia.indexmanagement.rollup.model.RollupMetadata;
import io.lucenia.indexmanagement.rollup.util.RollupUtils;
import io.lucenia.indexmanagement.settings.IndexManagementSettings;
import io.lucenia.indexmanagement.util.SecurityUtils;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.DocWriteResponse;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.action.get.GetRequest;
import io.skylite.core.action.get.GetResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.action.update.UpdateRequest;
import io.skylite.core.action.update.UpdateResponse;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.security.auth.User;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentHelper;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.time.Instant;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportStartRollupAction
extends HandledTransportAction<StartRollupRequest, AcknowledgedResponse> {
    private final Client client;
    private final ClusterService clusterService;
    private final Settings settings;
    private final NamedXContentRegistry xContentRegistry;
    private final Logger log = LogManager.getLogger(TransportStartRollupAction.class);
    private volatile boolean filterByEnabled;

    @Inject
    public TransportStartRollupAction(TransportService transportService, Client client, ClusterService clusterService, Settings settings, ActionFilters actionFilters, NamedXContentRegistry xContentRegistry) {
        super("cluster:admin/lucenia/rollup/start", transportService, actionFilters, StartRollupRequest::new);
        this.client = client;
        this.clusterService = clusterService;
        this.settings = settings;
        this.xContentRegistry = xContentRegistry;
        this.filterByEnabled = (Boolean)IndexManagementSettings.FILTER_BY_BACKEND_ROLES.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(IndexManagementSettings.FILTER_BY_BACKEND_ROLES, it -> {
            this.filterByEnabled = it;
        });
    }

    protected void doExecute(Task task, final StartRollupRequest request, final ActionListener<AcknowledgedResponse> actionListener) {
        this.log.debug("User and roles string from thread context: {}", this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
        GetRequest getReq = new GetRequest(".opendistro-ism-config", request.getId());
        final User user = SecurityUtils.buildUser(this.client.threadPool().getThreadContext());
        try (ThreadContext.StoredContext ignored = this.client.threadPool().getThreadContext().stashContext();){
            this.client.get(getReq, (ActionListener)new ActionListener<GetResponse>(){

                public void onResponse(GetResponse response) {
                    Rollup rollup;
                    if (!response.isExists()) {
                        actionListener.onFailure((Exception)((Object)new SkyliteStatusException("Rollup not found", RestStatus.NOT_FOUND, new Object[0])));
                        return;
                    }
                    try {
                        rollup = RollupUtils.parseRollup(response, TransportStartRollupAction.this.xContentRegistry);
                    }
                    catch (IOException | IllegalArgumentException e) {
                        actionListener.onFailure((Exception)((Object)new SkyliteStatusException("Rollup not found", RestStatus.NOT_FOUND, new Object[0])));
                        return;
                    }
                    if (!SecurityUtils.userHasPermissionForResource(user, rollup.getUser(), TransportStartRollupAction.this.filterByEnabled, "rollup", rollup.getId(), actionListener)) {
                        return;
                    }
                    if (rollup.getEnabled()) {
                        TransportStartRollupAction.this.log.debug("Rollup job is already enabled, checking if metadata needs to be updated");
                        if (rollup.getMetadataID() == null) {
                            actionListener.onResponse((Object)new AcknowledgedResponse(true));
                        } else {
                            TransportStartRollupAction.this.getRollupMetadata(rollup, (ActionListener<AcknowledgedResponse>)actionListener);
                        }
                        return;
                    }
                    TransportStartRollupAction.this.updateRollupJob(rollup, request, (ActionListener<AcknowledgedResponse>)actionListener);
                }

                public void onFailure(Exception e) {
                    actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)e));
                }
            });
        }
    }

    private void updateRollupJob(final Rollup rollup, StartRollupRequest request, final ActionListener<AcknowledgedResponse> actionListener) {
        long now = Instant.now().toEpochMilli();
        UpdateRequest updateReq = new UpdateRequest(".opendistro-ism-config", request.getId());
        HashMap<String, Comparable<Boolean>> rollupDoc = new HashMap<String, Comparable<Boolean>>();
        rollupDoc.put("enabled", Boolean.valueOf(true));
        rollupDoc.put("enabled_time", Long.valueOf(now));
        rollupDoc.put("last_updated_time", Long.valueOf(now));
        HashMap<String, HashMap<String, Comparable<Boolean>>> doc = new HashMap<String, HashMap<String, Comparable<Boolean>>>();
        doc.put("rollup", rollupDoc);
        updateReq.doc(doc);
        this.client.update(updateReq, (ActionListener)new ActionListener<UpdateResponse>(){

            public void onResponse(UpdateResponse response) {
                if (response.getResult() == DocWriteResponse.Result.UPDATED) {
                    if (rollup.getMetadataID() != null) {
                        TransportStartRollupAction.this.getRollupMetadata(rollup, (ActionListener<AcknowledgedResponse>)actionListener);
                    } else {
                        actionListener.onResponse((Object)new AcknowledgedResponse(true));
                    }
                } else {
                    actionListener.onResponse((Object)new AcknowledgedResponse(false));
                }
            }

            public void onFailure(Exception e) {
                actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)e));
            }
        });
    }

    private void getRollupMetadata(final Rollup rollup, final ActionListener<AcknowledgedResponse> actionListener) {
        GetRequest req = new GetRequest(".opendistro-ism-config", rollup.getMetadataID()).routing(rollup.getId());
        this.client.get(req, (ActionListener)new ActionListener<GetResponse>(){

            public void onResponse(GetResponse response) {
                if (!response.isExists() || response.isSourceEmpty()) {
                    actionListener.onResponse((Object)new AcknowledgedResponse(true));
                } else {
                    RollupMetadata metadata = null;
                    if (response.getSourceAsBytesRef() != null) {
                        try {
                            XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)response.getSourceAsBytesRef(), (MediaType)MediaTypeRegistry.JSON);
                            metadata = ContentParserUtils.parseWithType(xcp, response.getId(), response.getSeqNo(), response.getPrimaryTerm(), RollupMetadata::parse);
                        }
                        catch (Exception e) {
                            actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)e));
                            return;
                        }
                    }
                    if (metadata == null) {
                        actionListener.onResponse((Object)new AcknowledgedResponse(true));
                    } else {
                        TransportStartRollupAction.this.updateRollupMetadata(rollup, metadata, (ActionListener<AcknowledgedResponse>)actionListener);
                    }
                }
            }

            public void onFailure(Exception e) {
                actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)e));
            }
        });
    }

    private void updateRollupMetadata(Rollup rollup, RollupMetadata metadata, final ActionListener<AcknowledgedResponse> actionListener) {
        RollupMetadata.Status updatedStatus;
        long now = Instant.now().toEpochMilli();
        switch (metadata.getStatus()) {
            case FINISHED: 
            case STOPPED: {
                updatedStatus = RollupMetadata.Status.STARTED;
                break;
            }
            case STARTED: 
            case INIT: 
            case RETRY: {
                actionListener.onResponse((Object)new AcknowledgedResponse(true));
                return;
            }
            case FAILED: {
                updatedStatus = RollupMetadata.Status.RETRY;
                break;
            }
            default: {
                updatedStatus = RollupMetadata.Status.STARTED;
            }
        }
        HashMap<String, Object> metadataDoc = new HashMap<String, Object>();
        metadataDoc.put("status", updatedStatus.getType());
        metadataDoc.put("failure_reason", null);
        metadataDoc.put("last_updated_time", now);
        HashMap<String, HashMap<String, Object>> doc = new HashMap<String, HashMap<String, Object>>();
        doc.put("rollup_metadata", metadataDoc);
        UpdateRequest updateRequest = new UpdateRequest(".opendistro-ism-config", rollup.getMetadataID()).doc(doc).routing(rollup.getId());
        this.client.update(updateRequest, (ActionListener)new ActionListener<UpdateResponse>(){

            public void onResponse(UpdateResponse response) {
                actionListener.onResponse((Object)new AcknowledgedResponse(response.getResult() == DocWriteResponse.Result.UPDATED));
            }

            public void onFailure(Exception e) {
                actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)e));
            }
        });
    }
}

