/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.rollup.action.stop;

import io.lucenia.indexmanagement.luceniaapi.ContentParserUtils;
import io.lucenia.indexmanagement.rollup.action.stop.StopRollupRequest;
import io.lucenia.indexmanagement.rollup.model.Rollup;
import io.lucenia.indexmanagement.rollup.model.RollupMetadata;
import io.lucenia.indexmanagement.rollup.util.RollupUtils;
import io.lucenia.indexmanagement.settings.IndexManagementSettings;
import io.lucenia.indexmanagement.util.SecurityUtils;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.DocWriteResponse;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.action.get.GetRequest;
import io.skylite.core.action.get.GetResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.action.update.UpdateRequest;
import io.skylite.core.action.update.UpdateResponse;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.security.auth.User;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentHelper;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.time.Instant;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportStopRollupAction
extends HandledTransportAction<StopRollupRequest, AcknowledgedResponse> {
    private final Client client;
    private final ClusterService clusterService;
    private final Settings settings;
    private final NamedXContentRegistry xContentRegistry;
    private final Logger log = LogManager.getLogger(TransportStopRollupAction.class);
    private volatile boolean filterByEnabled;

    @Inject
    public TransportStopRollupAction(TransportService transportService, Client client, ClusterService clusterService, Settings settings, ActionFilters actionFilters, NamedXContentRegistry xContentRegistry) {
        super("cluster:admin/lucenia/rollup/stop", transportService, actionFilters, StopRollupRequest::new);
        this.client = client;
        this.clusterService = clusterService;
        this.settings = settings;
        this.xContentRegistry = xContentRegistry;
        this.filterByEnabled = (Boolean)IndexManagementSettings.FILTER_BY_BACKEND_ROLES.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(IndexManagementSettings.FILTER_BY_BACKEND_ROLES, it -> {
            this.filterByEnabled = it;
        });
    }

    protected void doExecute(Task task, final StopRollupRequest request, final ActionListener<AcknowledgedResponse> actionListener) {
        this.log.debug("Executing StopRollupAction on {}", (Object)request.getId());
        this.log.debug("User and roles string from thread context: {}", this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info"));
        GetRequest getRequest = new GetRequest(".opendistro-ism-config", request.getId());
        final User user = SecurityUtils.buildUser(this.client.threadPool().getThreadContext());
        try (ThreadContext.StoredContext ignored = this.client.threadPool().getThreadContext().stashContext();){
            this.client.get(getRequest, (ActionListener)new ActionListener<GetResponse>(){

                public void onResponse(GetResponse response) {
                    Rollup rollup;
                    if (!response.isExists()) {
                        actionListener.onFailure((Exception)((Object)new SkyliteStatusException("Rollup not found", RestStatus.NOT_FOUND, new Object[0])));
                        return;
                    }
                    try {
                        rollup = RollupUtils.parseRollup(response, TransportStopRollupAction.this.xContentRegistry);
                    }
                    catch (IOException | IllegalArgumentException e) {
                        actionListener.onFailure((Exception)((Object)new SkyliteStatusException("Rollup not found", RestStatus.NOT_FOUND, new Object[0])));
                        return;
                    }
                    if (!SecurityUtils.userHasPermissionForResource(user, rollup.getUser(), TransportStopRollupAction.this.filterByEnabled, "rollup", rollup.getId(), actionListener)) {
                        return;
                    }
                    if (rollup.getMetadataID() != null) {
                        TransportStopRollupAction.this.getRollupMetadata(rollup, request, (ActionListener<AcknowledgedResponse>)actionListener);
                    } else {
                        TransportStopRollupAction.this.updateRollupJob(rollup, request, (ActionListener<AcknowledgedResponse>)actionListener);
                    }
                }

                public void onFailure(Exception e) {
                    actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)e));
                }
            });
        }
    }

    private void getRollupMetadata(final Rollup rollup, final StopRollupRequest request, final ActionListener<AcknowledgedResponse> actionListener) {
        GetRequest req = new GetRequest(".opendistro-ism-config", rollup.getMetadataID()).routing(rollup.getId());
        this.client.get(req, (ActionListener)new ActionListener<GetResponse>(){

            public void onResponse(GetResponse response) {
                if (!response.isExists() || response.isSourceEmpty()) {
                    TransportStopRollupAction.this.updateRollupJob(rollup, request, (ActionListener<AcknowledgedResponse>)actionListener);
                } else {
                    RollupMetadata metadata = null;
                    if (response.getSourceAsBytesRef() != null) {
                        try {
                            XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)response.getSourceAsBytesRef(), (MediaType)MediaTypeRegistry.JSON);
                            metadata = ContentParserUtils.parseWithType(xcp, response.getId(), response.getSeqNo(), response.getPrimaryTerm(), RollupMetadata::parse);
                        }
                        catch (Exception e) {
                            actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)e));
                            return;
                        }
                    }
                    if (metadata == null) {
                        TransportStopRollupAction.this.updateRollupJob(rollup, request, (ActionListener<AcknowledgedResponse>)actionListener);
                    } else {
                        TransportStopRollupAction.this.updateRollupMetadata(rollup, metadata, request, (ActionListener<AcknowledgedResponse>)actionListener);
                    }
                }
            }

            public void onFailure(Exception e) {
                actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)e));
            }
        });
    }

    private void updateRollupMetadata(final Rollup rollup, RollupMetadata metadata, final StopRollupRequest request, final ActionListener<AcknowledgedResponse> actionListener) {
        RollupMetadata.Status updatedStatus;
        long now = Instant.now().toEpochMilli();
        String failureReason = null;
        switch (metadata.getStatus()) {
            case STARTED: 
            case INIT: 
            case STOPPED: {
                updatedStatus = RollupMetadata.Status.STOPPED;
                break;
            }
            case FINISHED: 
            case FAILED: {
                updatedStatus = metadata.getStatus();
                break;
            }
            case RETRY: {
                updatedStatus = RollupMetadata.Status.FAILED;
                failureReason = "Stopped a rollup that was in retry, rolling back to failed status";
                break;
            }
            default: {
                updatedStatus = RollupMetadata.Status.STOPPED;
            }
        }
        HashMap<String, Object> metadataDoc = new HashMap<String, Object>();
        metadataDoc.put("status", updatedStatus.getType());
        metadataDoc.put("failure_reason", failureReason);
        metadataDoc.put("last_updated_time", now);
        HashMap<String, HashMap<String, Object>> doc = new HashMap<String, HashMap<String, Object>>();
        doc.put("rollup_metadata", metadataDoc);
        UpdateRequest updateRequest = new UpdateRequest(".opendistro-ism-config", rollup.getMetadataID()).doc(doc).routing(rollup.getId());
        this.client.update(updateRequest, (ActionListener)new ActionListener<UpdateResponse>(){

            public void onResponse(UpdateResponse response) {
                if (response.getResult() == DocWriteResponse.Result.UPDATED) {
                    TransportStopRollupAction.this.updateRollupJob(rollup, request, (ActionListener<AcknowledgedResponse>)actionListener);
                } else {
                    actionListener.onResponse((Object)new AcknowledgedResponse(false));
                }
            }

            public void onFailure(Exception e) {
                actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)e));
            }
        });
    }

    private void updateRollupJob(Rollup rollup, StopRollupRequest request, final ActionListener<AcknowledgedResponse> actionListener) {
        long now = Instant.now().toEpochMilli();
        HashMap<String, Comparable<Boolean>> rollupDoc = new HashMap<String, Comparable<Boolean>>();
        rollupDoc.put("enabled", Boolean.valueOf(false));
        rollupDoc.put("enabled_time", null);
        rollupDoc.put("last_updated_time", Long.valueOf(now));
        HashMap<String, HashMap<String, Comparable<Boolean>>> doc = new HashMap<String, HashMap<String, Comparable<Boolean>>>();
        doc.put("rollup", rollupDoc);
        UpdateRequest updateReq = new UpdateRequest(".opendistro-ism-config", request.getId()).setIfSeqNo(rollup.getSeqNo()).setIfPrimaryTerm(rollup.getPrimaryTerm()).doc(doc).routing(rollup.getId());
        this.client.update(updateReq, (ActionListener)new ActionListener<UpdateResponse>(){

            public void onResponse(UpdateResponse response) {
                actionListener.onResponse((Object)new AcknowledgedResponse(response.getResult() == DocWriteResponse.Result.UPDATED));
            }

            public void onFailure(Exception e) {
                actionListener.onFailure((Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)e));
            }
        });
    }
}

