/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.rollup.actionfilter;

import io.lucenia.indexmanagement.IndexManagementModulePlugin;
import io.lucenia.indexmanagement.rollup.actionfilter.ISMFieldCapabilities;
import io.lucenia.indexmanagement.rollup.actionfilter.ISMFieldCapabilitiesIndexResponse;
import io.lucenia.indexmanagement.rollup.actionfilter.ISMFieldCapabilitiesResponse;
import io.lucenia.indexmanagement.rollup.actionfilter.ISMIndexFieldCapabilities;
import io.lucenia.indexmanagement.rollup.model.Rollup;
import io.lucenia.indexmanagement.rollup.model.RollupFieldMapping;
import io.lucenia.indexmanagement.rollup.settings.RollupSettings;
import io.lucenia.indexmanagement.rollup.util.RollupUtils;
import io.lucenia.indexmanagement.util.IndexUtils;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilter;
import io.skylite.core.action.ActionFilterChain;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.fieldcaps.FieldCapabilities;
import io.skylite.core.action.fieldcaps.FieldCapabilitiesRequest;
import io.skylite.core.action.fieldcaps.FieldCapabilitiesResponse;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.Task;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FieldCapsFilter
implements ActionFilter {
    private static final Logger logger = LogManager.getLogger(FieldCapsFilter.class);
    private final ClusterService clusterService;
    private final Settings settings;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private volatile boolean shouldIntercept;

    public FieldCapsFilter(ClusterService clusterService, Settings settings, IndexNameExpressionResolver indexNameExpressionResolver) {
        this.clusterService = clusterService;
        this.settings = settings;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.shouldIntercept = (Boolean)RollupSettings.ROLLUP_DASHBOARDS.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(RollupSettings.ROLLUP_DASHBOARDS, flag -> {
            this.shouldIntercept = flag;
        });
    }

    public <Request extends ActionRequest, Response extends ActionResponse> void apply(Task task, String action, Request request, final ActionListener<Response> listener, ActionFilterChain<Request, Response> chain) {
        if (request instanceof FieldCapabilitiesRequest && this.shouldIntercept) {
            FieldCapabilitiesRequest fieldCapsRequest = (FieldCapabilitiesRequest)request;
            String[] indices = (String[])Arrays.stream(fieldCapsRequest.indices()).map(Object::toString).toArray(String[]::new);
            final HashSet<String> rollupIndices = new HashSet<String>();
            HashSet<Object> nonRollupIndices = new HashSet<Object>();
            Map remoteClusterIndices = IndexManagementModulePlugin.GuiceHolder.remoteClusterService.groupIndices(fieldCapsRequest.indicesOptions(), indices, idx -> this.indexNameExpressionResolver.hasIndexAbstraction(idx, this.clusterService.state()));
            Object localIndicesObj = remoteClusterIndices.remove("");
            if (localIndicesObj != null) {
                try {
                    String[] concreteIndices;
                    Method indicesMethod = localIndicesObj.getClass().getMethod("indices", new Class[0]);
                    String[] localIndicesArray = (String[])indicesMethod.invoke(localIndicesObj, new Object[0]);
                    for (String index : concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(this.clusterService.state(), fieldCapsRequest.indicesOptions(), localIndicesArray)) {
                        boolean isRollup = RollupUtils.isRollupIndex(index, this.clusterService.state());
                        if (isRollup) {
                            rollupIndices.add(index);
                            continue;
                        }
                        nonRollupIndices.add(index);
                    }
                }
                catch (Exception e) {
                    logger.error("Failed to get local indices", (Throwable)e);
                }
            }
            Set entries = remoteClusterIndices.entrySet();
            for (Map.Entry entry : entries) {
                String cluster = (String)entry.getKey();
                Object clusterIndicesObj = entry.getValue();
                try {
                    Method indicesMethod = clusterIndicesObj.getClass().getMethod("indices", new Class[0]);
                    Iterable clusterIndices = (Iterable)indicesMethod.invoke(clusterIndicesObj, new Object[0]);
                    for (String index : clusterIndices) {
                        nonRollupIndices.add(cluster + ":" + index);
                    }
                }
                catch (Exception e) {
                    logger.error("Failed to get cluster indices for cluster: " + cluster, (Throwable)e);
                }
            }
            logger.debug("Resolved into rollup {} and non rollup {} indices", rollupIndices, nonRollupIndices);
            if (rollupIndices.isEmpty()) {
                chain.proceed(task, action, request, listener);
                return;
            }
            if (!nonRollupIndices.isEmpty()) {
                fieldCapsRequest.indices(nonRollupIndices.toArray(new String[0]));
            }
            final boolean shouldDiscardResponse = nonRollupIndices.isEmpty();
            chain.proceed(task, action, request, new ActionListener<Response>(){

                public void onResponse(Response response) {
                    logger.info("Has rollup indices will rewrite field caps response");
                    FieldCapabilitiesResponse fieldCapsResponse = (FieldCapabilitiesResponse)response;
                    try {
                        ActionResponse rewrittenResponse = FieldCapsFilter.this.rewriteResponse(fieldCapsResponse, rollupIndices, shouldDiscardResponse);
                        listener.onResponse((Object)rewrittenResponse);
                    }
                    catch (IOException e) {
                        this.onFailure(e);
                    }
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        } else {
            chain.proceed(task, action, request, listener);
        }
    }

    ActionResponse rewriteResponse(FieldCapabilitiesResponse response, Set<String> rollupIndices, boolean shouldDiscardResponse) throws IOException {
        List<Object> indexResponses;
        ISMFieldCapabilitiesResponse ismFieldCapabilitiesResponse = ISMFieldCapabilitiesResponse.fromFieldCapabilitiesResponse(response);
        boolean isMergedResponse = ismFieldCapabilitiesResponse.getIndexResponses().isEmpty();
        HashMap<String, Map<String, FieldCapabilities>> fields = shouldDiscardResponse ? new HashMap() : response.get();
        String[] indices = shouldDiscardResponse ? new String[]{} : response.getIndices();
        List<Object> list = indexResponses = shouldDiscardResponse ? new ArrayList() : ismFieldCapabilitiesResponse.getIndexResponses();
        if (isMergedResponse) {
            return this.rewriteResponse(indices, fields, rollupIndices);
        }
        List<ISMFieldCapabilitiesIndexResponse> rollupIndexResponses = this.populateRollupIndexResponses(rollupIndices);
        ArrayList<ISMFieldCapabilitiesIndexResponse> mergedIndexResponses = new ArrayList<ISMFieldCapabilitiesIndexResponse>(indexResponses);
        mergedIndexResponses.addAll(rollupIndexResponses);
        ISMFieldCapabilitiesResponse rewrittenISMResponse = new ISMFieldCapabilitiesResponse(new String[0], new HashMap<String, Map<String, ISMFieldCapabilities>>(), mergedIndexResponses);
        return rewrittenISMResponse.toFieldCapabilitiesResponse();
    }

    private List<ISMFieldCapabilitiesIndexResponse> populateRollupIndexResponses(Set<String> rollupIndices) throws IOException {
        ArrayList<ISMFieldCapabilitiesIndexResponse> indexResponses = new ArrayList<ISMFieldCapabilitiesIndexResponse>();
        for (String rollupIndex : rollupIndices) {
            HashMap<String, ISMIndexFieldCapabilities> rollupIsmFieldCapabilities = new HashMap<String, ISMIndexFieldCapabilities>();
            Set<RollupFieldMapping> rollupFieldMappings = this.populateSourceFieldMappingsForRollupIndex(rollupIndex);
            for (RollupFieldMapping rollupFieldMapping : rollupFieldMappings) {
                String fieldName = rollupFieldMapping.getFieldName();
                String type = rollupFieldMapping.getSourceType();
                boolean isSearchable = rollupFieldMapping.getFieldType() == RollupFieldMapping.FieldType.DIMENSION;
                rollupIsmFieldCapabilities.put(fieldName, new ISMIndexFieldCapabilities(fieldName, type, isSearchable, true, new HashMap<String, String>()));
            }
            indexResponses.add(new ISMFieldCapabilitiesIndexResponse(rollupIndex, rollupIsmFieldCapabilities, true));
        }
        return indexResponses;
    }

    private ActionResponse rewriteResponse(String[] indices, Map<String, Map<String, FieldCapabilities>> fields, Set<String> rollupIndices) throws IOException {
        Map<String, Map<String, FieldCapabilities>> filteredIndicesFields = this.expandIndicesInFields(indices, fields);
        Map<String, Map<String, FieldCapabilities>> rollupIndicesFields = this.populateRollupIndicesFields(rollupIndices);
        Map<String, Map<String, FieldCapabilities>> mergedFields = this.mergeFields(filteredIndicesFields, rollupIndicesFields);
        String[] mergedIndices = new String[indices.length + rollupIndices.size()];
        System.arraycopy(indices, 0, mergedIndices, 0, indices.length);
        int i = indices.length;
        for (String rollupIndex : rollupIndices) {
            mergedIndices[i++] = rollupIndex;
        }
        return new FieldCapabilitiesResponse(mergedIndices, mergedFields);
    }

    private Map<String, Map<String, FieldCapabilities>> populateRollupIndicesFields(Set<String> rollupIndices) throws IOException {
        Map<RollupFieldMapping, Set<String>> fieldMappingIndexMap = this.populateSourceFieldMappingsForRollupIndices(rollupIndices);
        HashMap<String, Map<String, FieldCapabilities>> response = new HashMap<String, Map<String, FieldCapabilities>>();
        for (Map.Entry<RollupFieldMapping, Set<String>> entry : fieldMappingIndexMap.entrySet()) {
            RollupFieldMapping fieldMapping = entry.getKey();
            String fieldName = fieldMapping.getFieldName();
            String type = fieldMapping.getSourceType();
            response.putIfAbsent(fieldName, new HashMap());
            boolean isSearchable = fieldMapping.getFieldType() == RollupFieldMapping.FieldType.DIMENSION;
            ((Map)response.get(fieldName)).put(type, new FieldCapabilities(fieldName, type, isSearchable, true, entry.getValue().toArray(new String[0]), null, null, new HashMap()));
        }
        return response;
    }

    private Set<RollupFieldMapping> populateSourceFieldMappingsForRollupJob(Rollup rollup) {
        String[] sourceIndices;
        Set<RollupFieldMapping> rollupFieldMappings = RollupUtils.populateFieldMappings(rollup);
        for (String sourceIndex : sourceIndices = this.indexNameExpressionResolver.concreteIndexNames(this.clusterService.state(), IndicesOptions.lenientExpand(), true, new String[]{rollup.getSourceIndex()})) {
            Map mappings = this.clusterService.state().metadata().index(sourceIndex).mapping().sourceAsMap();
            if (mappings == null) {
                return rollupFieldMappings;
            }
            for (RollupFieldMapping fieldMapping : rollupFieldMappings) {
                String fieldType = this.getFieldType(fieldMapping.getFieldName(), mappings);
                if (fieldType == null) continue;
                fieldMapping.setSourceType(fieldType);
            }
        }
        return rollupFieldMappings;
    }

    private Set<RollupFieldMapping> populateSourceFieldMappingsForRollupIndex(String rollupIndex) throws IOException {
        HashSet<RollupFieldMapping> fieldMappings = new HashSet<RollupFieldMapping>();
        List<Rollup> rollupJobs = RollupUtils.getRollupJobs(this.clusterService.state().metadata().index(rollupIndex));
        if (rollupJobs == null) {
            return fieldMappings;
        }
        for (Rollup rollup : rollupJobs) {
            fieldMappings.addAll(this.populateSourceFieldMappingsForRollupJob(rollup));
        }
        return fieldMappings;
    }

    private Map<RollupFieldMapping, Set<String>> populateSourceFieldMappingsForRollupIndices(Set<String> rollupIndices) throws IOException {
        HashMap<RollupFieldMapping, Set<String>> fieldMappingsMap = new HashMap<RollupFieldMapping, Set<String>>();
        for (String rollupIndex : rollupIndices) {
            Set<RollupFieldMapping> fieldMappings = this.populateSourceFieldMappingsForRollupIndex(rollupIndex);
            for (RollupFieldMapping fieldMapping : fieldMappings) {
                fieldMappingsMap.putIfAbsent(fieldMapping, new HashSet());
                ((Set)fieldMappingsMap.get(fieldMapping)).add(rollupIndex);
            }
        }
        return fieldMappingsMap;
    }

    private String getFieldType(String fieldName, Map<String, Object> mappings) {
        Map<?, ?> field = IndexUtils.getFieldFromMappings(fieldName, mappings);
        if (field != null && field.containsKey("type")) {
            return field.get("type").toString();
        }
        return null;
    }

    private Map<String, Map<String, FieldCapabilities>> expandIndicesInFields(String[] indices, Map<String, Map<String, FieldCapabilities>> fields) {
        HashMap<String, Map<String, FieldCapabilities>> expandedResponse = new HashMap<String, Map<String, FieldCapabilities>>();
        for (String field : fields.keySet()) {
            Map<String, FieldCapabilities> fieldTypes = fields.get(field);
            for (String type : fieldTypes.keySet()) {
                expandedResponse.putIfAbsent(field, new HashMap());
                FieldCapabilities fieldCaps = fieldTypes.get(type);
                String[] rewrittenIndices = fieldCaps.indices() != null && fieldCaps.indices().length > 0 ? fieldCaps.indices() : indices;
                ((Map)expandedResponse.get(field)).put(type, new FieldCapabilities(fieldCaps.getName(), fieldCaps.getType(), fieldCaps.isSearchable(), fieldCaps.isAggregatable(), rewrittenIndices, fieldCaps.nonSearchableIndices(), fieldCaps.nonAggregatableIndices(), fieldCaps.meta()));
            }
        }
        return expandedResponse;
    }

    private Map<String, Map<String, FieldCapabilities>> mergeFields(Map<String, Map<String, FieldCapabilities>> f1, Map<String, Map<String, FieldCapabilities>> f2) {
        HashMap<String, Map<String, FieldCapabilities>> mergedResponses = new HashMap<String, Map<String, FieldCapabilities>>();
        HashSet<String> fields = new HashSet<String>();
        fields.addAll(f1.keySet());
        fields.addAll(f2.keySet());
        for (String field : fields) {
            Map<String, FieldCapabilities> mergedFields = this.mergeTypes(f1.get(field), f2.get(field));
            if (mergedFields == null) continue;
            mergedResponses.put(field, mergedFields);
        }
        return mergedResponses;
    }

    private Map<String, FieldCapabilities> mergeTypes(Map<String, FieldCapabilities> t1, Map<String, FieldCapabilities> t2) {
        if (t1 == null) {
            return t2;
        }
        if (t2 == null) {
            return t1;
        }
        HashMap<String, FieldCapabilities> mergedFields = new HashMap<String, FieldCapabilities>();
        HashSet<String> types = new HashSet<String>();
        types.addAll(t1.keySet());
        types.addAll(t2.keySet());
        for (String type : types) {
            FieldCapabilities mergedTypes = this.mergeFieldCaps(t1.get(type), t2.get(type));
            if (mergedTypes == null) continue;
            mergedFields.put(type, mergedTypes);
        }
        return mergedFields;
    }

    private FieldCapabilities mergeFieldCaps(FieldCapabilities fc1, FieldCapabilities fc2) {
        if (fc1 == null) {
            return fc2;
        }
        if (fc2 == null) {
            return fc1;
        }
        if (!fc1.getName().equals(fc2.getName()) || !fc1.getType().equals(fc2.getType())) {
            logger.warn("cannot merge {} and {}", (Object)fc1, (Object)fc2);
            return null;
        }
        boolean isSearchable = fc1.isSearchable() || fc2.isSearchable();
        boolean isAggregatable = fc1.isAggregatable() || fc2.isAggregatable();
        String name = fc1.getName();
        String type = fc1.getType();
        String[] indices = new String[fc1.indices().length + fc2.indices().length];
        System.arraycopy(fc1.indices(), 0, indices, 0, fc1.indices().length);
        System.arraycopy(fc2.indices(), 0, indices, fc1.indices().length, fc2.indices().length);
        String[] nonAggregatableIndices = this.mergeNonAggregatableIndices(fc1, fc2);
        String[] nonSearchableIndices = this.mergeNonSearchableIndices(fc1, fc2);
        HashMap meta = new HashMap();
        HashSet metaKeys = new HashSet();
        metaKeys.addAll(fc1.meta().keySet());
        metaKeys.addAll(fc2.meta().keySet());
        for (String key : metaKeys) {
            HashSet data = new HashSet();
            if (fc1.meta().containsKey(key)) {
                data.addAll((Collection)fc1.meta().get(key));
            }
            if (fc2.meta().containsKey(key)) {
                data.addAll((Collection)fc2.meta().get(key));
            }
            meta.put(key, data);
        }
        return new FieldCapabilities(name, type, isSearchable, isAggregatable, indices, nonSearchableIndices, nonAggregatableIndices, meta);
    }

    private String[] mergeNonAggregatableIndices(FieldCapabilities fc1, FieldCapabilities fc2) {
        HashSet<String> response = new HashSet<String>();
        if (fc1.isAggregatable() || fc2.isAggregatable()) {
            if (!fc1.isAggregatable()) {
                response.addAll(Arrays.asList(fc1.indices()));
            }
            if (!fc2.isAggregatable()) {
                response.addAll(Arrays.asList(fc2.indices()));
            }
            if (fc1.nonAggregatableIndices() != null) {
                response.addAll(Arrays.asList(fc1.nonAggregatableIndices()));
            }
            if (fc2.nonAggregatableIndices() != null) {
                response.addAll(Arrays.asList(fc2.nonAggregatableIndices()));
            }
        }
        return response.isEmpty() ? null : response.toArray(new String[0]);
    }

    private String[] mergeNonSearchableIndices(FieldCapabilities fc1, FieldCapabilities fc2) {
        HashSet<String> response = new HashSet<String>();
        if (fc1.isSearchable() || fc2.isSearchable()) {
            if (!fc1.isSearchable()) {
                response.addAll(Arrays.asList(fc1.indices()));
            }
            if (!fc2.isSearchable()) {
                response.addAll(Arrays.asList(fc2.indices()));
            }
            if (fc1.nonSearchableIndices() != null) {
                response.addAll(Arrays.asList(fc1.nonSearchableIndices()));
            }
            if (fc2.nonSearchableIndices() != null) {
                response.addAll(Arrays.asList(fc2.nonSearchableIndices()));
            }
        }
        return response.isEmpty() ? null : response.toArray(new String[0]);
    }

    public int order() {
        return Integer.MAX_VALUE;
    }
}

