/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.rollup.interceptor;

import io.lucenia.indexmanagement.common.model.dimension.DateHistogram;
import io.lucenia.indexmanagement.common.model.dimension.Dimension;
import io.lucenia.indexmanagement.rollup.model.Rollup;
import io.lucenia.indexmanagement.rollup.model.RollupFieldMapping;
import io.lucenia.indexmanagement.rollup.query.QueryStringQueryUtil;
import io.lucenia.indexmanagement.rollup.settings.RollupSettings;
import io.lucenia.indexmanagement.rollup.util.RollupUtils;
import io.lucenia.indexmanagement.util.IndexUtils;
import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.aggregations.AggregationBuilder;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.index.query.BoolQueryBuilder;
import io.skylite.core.index.query.DisMaxQueryBuilder;
import io.skylite.core.index.query.MatchAllQueryBuilder;
import io.skylite.core.index.query.MatchPhraseQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.QueryStringQueryBuilder;
import io.skylite.core.index.query.RangeQueryBuilder;
import io.skylite.core.index.query.TermQueryBuilder;
import io.skylite.core.index.query.support.MatchQuery;
import io.skylite.core.search.internal.ShardSearchRequest;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportChannel;
import io.skylite.core.transport.TransportInterceptor;
import io.skylite.core.transport.TransportRequest;
import io.skylite.core.transport.TransportRequestHandler;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.index.query.BoostingQueryBuilder;
import org.opensearch.index.query.ConstantScoreQueryBuilder;
import org.opensearch.index.query.TermsQueryBuilder;
import org.opensearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.opensearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.opensearch.search.aggregations.bucket.histogram.HistogramAggregationBuilder;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.opensearch.search.aggregations.metrics.AvgAggregationBuilder;
import org.opensearch.search.aggregations.metrics.MaxAggregationBuilder;
import org.opensearch.search.aggregations.metrics.MinAggregationBuilder;
import org.opensearch.search.aggregations.metrics.SumAggregationBuilder;
import org.opensearch.search.aggregations.metrics.ValueCountAggregationBuilder;

public class RollupInterceptor
implements TransportInterceptor {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private final ClusterService clusterService;
    private final Settings settings;
    private final IndexNameExpressionResolver indexNameExpressionResolver;
    private volatile boolean searchEnabled;
    private volatile boolean searchAllJobs;
    private volatile boolean searchRawRollupIndices;

    public RollupInterceptor(ClusterService clusterService, Settings settings, IndexNameExpressionResolver indexNameExpressionResolver) {
        this.clusterService = clusterService;
        this.settings = settings;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.searchEnabled = (Boolean)RollupSettings.ROLLUP_SEARCH_ENABLED.get(settings);
        this.searchAllJobs = (Boolean)RollupSettings.ROLLUP_SEARCH_ALL_JOBS.get(settings);
        this.searchRawRollupIndices = (Boolean)RollupSettings.ROLLUP_SEARCH_SOURCE_INDICES.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(RollupSettings.ROLLUP_SEARCH_ENABLED, value -> {
            this.searchEnabled = value;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(RollupSettings.ROLLUP_SEARCH_ALL_JOBS, value -> {
            this.searchAllJobs = value;
        });
        clusterService.getClusterSettings().addSettingsUpdateConsumer(RollupSettings.ROLLUP_SEARCH_SOURCE_INDICES, value -> {
            this.searchRawRollupIndices = value;
        });
    }

    public <T extends TransportRequest> TransportRequestHandler<T> interceptHandler(String action, String executor, boolean forceExecution, final TransportRequestHandler<T> actualHandler) {
        return new TransportRequestHandler<T>(){

            public void messageReceived(T request, TransportChannel channel, Task task) throws Exception {
                ShardSearchRequest shardRequest;
                String index;
                boolean isRollupIndex;
                if (RollupInterceptor.this.searchEnabled && request instanceof ShardSearchRequest && (isRollupIndex = RollupUtils.isRollupIndex(index = (shardRequest = (ShardSearchRequest)request).shardId().getIndexName(), RollupInterceptor.this.clusterService.state()))) {
                    if (shardRequest.source().size() != 0) {
                        throw new IllegalArgumentException("Rollup search must have size explicitly set to 0, but found " + shardRequest.source().size());
                    }
                    String[] indices = (String[])Arrays.stream(shardRequest.indices()).map(Object::toString).toArray(String[]::new);
                    String[] concreteIndices = RollupInterceptor.this.indexNameExpressionResolver.concreteIndexNames(RollupInterceptor.this.clusterService.state(), shardRequest.indicesOptions(), indices);
                    List<Rollup> rollupJobs = RollupUtils.getRollupJobs(RollupInterceptor.this.clusterService.state().metadata().index(index));
                    if (rollupJobs == null || rollupJobs.isEmpty()) {
                        throw new IllegalArgumentException("No rollup job associated with target_index");
                    }
                    Rollup rollupJob = rollupJobs.get(0);
                    Set<RollupFieldMapping> queryFieldMappings = RollupInterceptor.this.getQueryMetadata(shardRequest.source().query(), RollupInterceptor.this.getConcreteSourceIndex(rollupJob.getSourceIndex(), RollupInterceptor.this.indexNameExpressionResolver, RollupInterceptor.this.clusterService.state()), new HashSet<RollupFieldMapping>());
                    Set<RollupFieldMapping> aggregationFieldMappings = RollupInterceptor.this.getAggregationMetadata(shardRequest.source().aggregations() != null ? shardRequest.source().aggregations().getAggregatorFactories() : null, new HashSet<RollupFieldMapping>());
                    HashSet<RollupFieldMapping> fieldMappings = new HashSet<RollupFieldMapping>();
                    fieldMappings.addAll(queryFieldMappings);
                    fieldMappings.addAll(aggregationFieldMappings);
                    Map<Rollup, Set<RollupFieldMapping>> allMatchingRollupJobs = RollupInterceptor.this.validateIndices(concreteIndices, fieldMappings);
                    if (!fieldMappings.isEmpty()) {
                        RollupInterceptor.this.rewriteShardSearchForRollupJobs(shardRequest, allMatchingRollupJobs);
                    }
                }
                actualHandler.messageReceived(request, channel, task);
            }
        };
    }

    public String getConcreteSourceIndex(String sourceIndex, IndexNameExpressionResolver resolver, ClusterState clusterState) {
        String[] concreteIndexNames = resolver.concreteIndexNames(clusterState, IndicesOptions.LENIENT_EXPAND_OPEN, new String[]{sourceIndex});
        if (concreteIndexNames.length == 0) {
            this.logger.warn("Cannot resolve rollup sourceIndex [" + sourceIndex + "]");
            return "";
        }
        String concreteIndexName = "";
        if (concreteIndexNames.length == 1 && IndexUtils.isConcreteIndex(concreteIndexNames[0], clusterState)) {
            concreteIndexName = concreteIndexNames[0];
        } else if (concreteIndexNames.length > 1) {
            concreteIndexName = IndexUtils.getNewestIndexByCreationDate(concreteIndexNames, clusterState);
        } else if (IndexUtils.isAlias(sourceIndex, clusterState) || IndexUtils.isDataStream(sourceIndex, clusterState)) {
            String writeIndex = IndexUtils.getWriteIndex(sourceIndex, clusterState);
            concreteIndexName = writeIndex != null ? writeIndex : IndexUtils.getNewestIndexByCreationDate(concreteIndexNames, clusterState);
        }
        return concreteIndexName;
    }

    private Map<Rollup, Set<RollupFieldMapping>> validateIndices(String[] concreteIndices, Set<RollupFieldMapping> fieldMappings) throws IOException {
        HashMap<Rollup, Set<RollupFieldMapping>> allMatchingRollupJobs = new HashMap<Rollup, Set<RollupFieldMapping>>();
        for (String concreteIndex : concreteIndices) {
            List<Rollup> rollupJobs = RollupUtils.getRollupJobs(this.clusterService.state().metadata().index(concreteIndex));
            if (rollupJobs != null) {
                Pair<Map<Rollup, Set<RollupFieldMapping>>, Set<String>> result = this.findMatchingRollupJobs(fieldMappings, rollupJobs);
                Map<Rollup, Set<RollupFieldMapping>> matchingRollupJobs = result.getKey();
                Set<String> issues = result.getValue();
                if (!issues.isEmpty() || matchingRollupJobs.isEmpty()) {
                    throw new IllegalArgumentException("Could not find a rollup job that can answer this query because " + String.valueOf(issues));
                }
                allMatchingRollupJobs.putAll(matchingRollupJobs);
                continue;
            }
            if (this.searchRawRollupIndices) continue;
            throw new IllegalArgumentException("Not all indices have rollup job");
        }
        return allMatchingRollupJobs;
    }

    private Set<RollupFieldMapping> getAggregationMetadata(Collection<AggregationBuilder> aggregationBuilders, Set<RollupFieldMapping> fieldMappings) {
        if (aggregationBuilders == null) {
            return fieldMappings;
        }
        for (AggregationBuilder it : aggregationBuilders) {
            if (it instanceof TermsAggregationBuilder) {
                TermsAggregationBuilder terms = (TermsAggregationBuilder)it;
                fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.FieldType.DIMENSION, terms.field(), terms.getType()));
            } else if (it instanceof DateHistogramAggregationBuilder) {
                DateHistogramAggregationBuilder dateHist = (DateHistogramAggregationBuilder)it;
                fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.FieldType.DIMENSION, dateHist.field(), dateHist.getType()));
            } else if (it instanceof HistogramAggregationBuilder) {
                HistogramAggregationBuilder hist = (HistogramAggregationBuilder)it;
                fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.FieldType.DIMENSION, hist.field(), hist.getType()));
            } else if (it instanceof SumAggregationBuilder) {
                SumAggregationBuilder sum = (SumAggregationBuilder)it;
                fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.FieldType.METRIC, sum.field(), sum.getType()));
            } else if (it instanceof AvgAggregationBuilder) {
                AvgAggregationBuilder avg = (AvgAggregationBuilder)it;
                fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.FieldType.METRIC, avg.field(), avg.getType()));
            } else if (it instanceof MaxAggregationBuilder) {
                MaxAggregationBuilder max = (MaxAggregationBuilder)it;
                fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.FieldType.METRIC, max.field(), max.getType()));
            } else if (it instanceof MinAggregationBuilder) {
                MinAggregationBuilder min = (MinAggregationBuilder)it;
                fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.FieldType.METRIC, min.field(), min.getType()));
            } else if (it instanceof ValueCountAggregationBuilder) {
                ValueCountAggregationBuilder valueCount = (ValueCountAggregationBuilder)it;
                fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.FieldType.METRIC, valueCount.field(), valueCount.getType()));
            } else {
                throw new IllegalArgumentException("The " + it.getType() + " aggregation is not currently supported in rollups");
            }
            if (it.getSubAggregations() == null || it.getSubAggregations().isEmpty()) continue;
            this.getAggregationMetadata(it.getSubAggregations(), fieldMappings);
        }
        return fieldMappings;
    }

    private Set<RollupFieldMapping> getQueryMetadata(QueryBuilder query, String concreteSourceIndexName, Set<RollupFieldMapping> fieldMappings) throws IOException {
        if (query == null) {
            return fieldMappings;
        }
        if (query instanceof TermQueryBuilder) {
            TermQueryBuilder termQuery = (TermQueryBuilder)query;
            fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.FieldType.DIMENSION, termQuery.fieldName(), Dimension.Type.TERMS.getType()));
        } else if (query instanceof TermsQueryBuilder) {
            TermsQueryBuilder termsQuery = (TermsQueryBuilder)query;
            fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.FieldType.DIMENSION, termsQuery.fieldName(), Dimension.Type.TERMS.getType()));
        } else if (query instanceof RangeQueryBuilder) {
            RangeQueryBuilder rangeQuery = (RangeQueryBuilder)query;
            fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.FieldType.DIMENSION, rangeQuery.fieldName(), "unknown"));
        } else if (!(query instanceof MatchAllQueryBuilder)) {
            if (query instanceof BoolQueryBuilder) {
                BoolQueryBuilder boolQuery = (BoolQueryBuilder)query;
                if (boolQuery.must() != null) {
                    for (QueryBuilder q : boolQuery.must()) {
                        this.getQueryMetadata(q, concreteSourceIndexName, fieldMappings);
                    }
                }
                if (boolQuery.mustNot() != null) {
                    for (QueryBuilder q : boolQuery.mustNot()) {
                        this.getQueryMetadata(q, concreteSourceIndexName, fieldMappings);
                    }
                }
                if (boolQuery.should() != null) {
                    for (QueryBuilder q : boolQuery.should()) {
                        this.getQueryMetadata(q, concreteSourceIndexName, fieldMappings);
                    }
                }
                if (boolQuery.filter() != null) {
                    for (QueryBuilder q : boolQuery.filter()) {
                        this.getQueryMetadata(q, concreteSourceIndexName, fieldMappings);
                    }
                }
            } else if (query instanceof BoostingQueryBuilder) {
                BoostingQueryBuilder boostingQuery = (BoostingQueryBuilder)query;
                this.getQueryMetadata(boostingQuery.positiveQuery(), concreteSourceIndexName, fieldMappings);
                this.getQueryMetadata(boostingQuery.negativeQuery(), concreteSourceIndexName, fieldMappings);
            } else if (query instanceof ConstantScoreQueryBuilder) {
                ConstantScoreQueryBuilder constantScoreQuery = (ConstantScoreQueryBuilder)query;
                this.getQueryMetadata(constantScoreQuery.innerQuery(), concreteSourceIndexName, fieldMappings);
            } else if (query instanceof DisMaxQueryBuilder) {
                DisMaxQueryBuilder disMaxQuery = (DisMaxQueryBuilder)query;
                for (QueryBuilder q : disMaxQuery.innerQueries()) {
                    this.getQueryMetadata(q, concreteSourceIndexName, fieldMappings);
                }
            } else if (query instanceof MatchPhraseQueryBuilder) {
                MatchPhraseQueryBuilder matchPhraseQuery = (MatchPhraseQueryBuilder)query;
                if (matchPhraseQuery.analyzer() != null && !matchPhraseQuery.analyzer().isEmpty() || matchPhraseQuery.slop() != 0 || matchPhraseQuery.zeroTermsQuery() != MatchQuery.DEFAULT_ZERO_TERMS_QUERY) {
                    throw new IllegalArgumentException("The " + query.getName() + " query is currently not supported with analyzer/slop/zero_terms_query in rollups");
                }
                fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.FieldType.DIMENSION, matchPhraseQuery.fieldName(), Dimension.Type.TERMS.getType()));
            } else if (query instanceof QueryStringQueryBuilder) {
                QueryStringQueryBuilder queryStringQuery = (QueryStringQueryBuilder)query;
                if (concreteSourceIndexName == null || concreteSourceIndexName.isEmpty()) {
                    throw new IllegalArgumentException("Can't parse query_string query without sourceIndex mappings!");
                }
                QueryStringQueryUtil.FieldsExtractionResult extracted = QueryStringQueryUtil.extractFieldsFromQueryString((QueryBuilder)queryStringQuery, concreteSourceIndexName);
                HashSet<String> queryFields = new HashSet<String>(extracted.discoveredFields);
                HashMap<String, Float> otherFields = new HashMap<String, Float>(extracted.otherFields);
                for (String field : queryFields) {
                    fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.FieldType.DIMENSION, field, Dimension.Type.TERMS.getType()));
                }
                for (String field : otherFields.keySet()) {
                    fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.FieldType.DIMENSION, field, Dimension.Type.TERMS.getType()));
                }
            } else {
                throw new IllegalArgumentException("The " + query.getName() + " query is currently not supported in rollups");
            }
        }
        return fieldMappings;
    }

    private Pair<Map<Rollup, Set<RollupFieldMapping>>, Set<String>> findMatchingRollupJobs(Set<RollupFieldMapping> fieldMappings, List<Rollup> rollupJobs) {
        Map<Rollup, Set> rollupFieldMappings = rollupJobs.stream().collect(Collectors.toMap(rollup -> rollup, rollup -> RollupUtils.populateFieldMappings(rollup)));
        HashSet<RollupFieldMapping> knownFieldMappings = new HashSet<RollupFieldMapping>();
        HashSet<String> unknownFields = new HashSet<String>();
        for (RollupFieldMapping it : fieldMappings) {
            if (it.getMappingType().equals("unknown")) {
                unknownFields.add(it.getFieldName());
                continue;
            }
            knownFieldMappings.add(it);
        }
        Map<Rollup, Set> potentialRollupFieldMappings = rollupFieldMappings.entrySet().stream().filter(entry -> {
            Set mappings = (Set)entry.getValue();
            Set fieldNames = mappings.stream().map(RollupFieldMapping::getFieldName).collect(Collectors.toSet());
            return mappings.containsAll(knownFieldMappings) && fieldNames.containsAll(unknownFields);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        HashSet<String> issues = new HashSet<String>();
        if (potentialRollupFieldMappings.isEmpty()) {
            HashSet allFieldMappings = new HashSet();
            for (Set mappings : rollupFieldMappings.values()) {
                allFieldMappings.addAll(mappings);
            }
            Set allFields = allFieldMappings.stream().map(RollupFieldMapping::getFieldName).collect(Collectors.toSet());
            for (RollupFieldMapping it : fieldMappings) {
                if (!allFields.contains(it.getFieldName())) {
                    issues.add(it.toIssue(true));
                    continue;
                }
                if (it.getMappingType().equals("unknown") || allFieldMappings.contains(it)) continue;
                issues.add(it.toIssue(false));
            }
        }
        return new Pair<Map<Rollup, Set<RollupFieldMapping>>, Set<String>>(potentialRollupFieldMappings, issues);
    }

    private Rollup pickRollupJob(Set<Rollup> rollups) {
        if (rollups.size() == 1) {
            return rollups.iterator().next();
        }
        List sortedRollups = rollups.stream().sorted(Comparator.comparing(Rollup::getId)).collect(Collectors.toList());
        return sortedRollups.stream().reduce((matched, newRollup) -> {
            if (this.getEstimateRollupInterval((Rollup)matched) > this.getEstimateRollupInterval((Rollup)newRollup)) {
                return matched;
            }
            return newRollup;
        }).orElse((Rollup)sortedRollups.get(0));
    }

    private long getEstimateRollupInterval(Rollup rollup) {
        DateHistogram dateHistogram = RollupUtils.getDateHistogram(rollup);
        if (dateHistogram.getCalendarInterval() != null) {
            return new DateHistogramInterval(dateHistogram.getCalendarInterval()).estimateMillis();
        }
        return new DateHistogramInterval(dateHistogram.getFixedInterval()).estimateMillis();
    }

    private void rewriteShardSearchForRollupJobs(ShardSearchRequest request, Map<Rollup, Set<RollupFieldMapping>> matchingRollupJobs) throws IOException {
        Rollup matchedRollup = this.pickRollupJob(matchingRollupJobs.keySet());
        Map<String, String> fieldNameMappingTypeMap = matchingRollupJobs.get(matchedRollup).stream().collect(Collectors.toMap(RollupFieldMapping::getFieldName, RollupFieldMapping::getMappingType, (v1, v2) -> v2));
        String concreteSourceIndex = this.getConcreteSourceIndex(matchedRollup.getSourceIndex(), this.indexNameExpressionResolver, this.clusterService.state());
        if (this.searchAllJobs) {
            request.source(RollupUtils.rewriteSearchSourceBuilder(request.source(), matchingRollupJobs.keySet(), fieldNameMappingTypeMap, concreteSourceIndex));
        } else {
            if (matchingRollupJobs.keySet().size() > 1) {
                this.logger.trace("Trying search with search across multiple rollup jobs disabled so will give result with largest rollup window");
            }
            request.source(RollupUtils.rewriteSearchSourceBuilder(request.source(), matchedRollup, fieldNameMappingTypeMap, concreteSourceIndex));
        }
    }

    private static class Pair<K, V> {
        private final K key;
        private final V value;

        public Pair(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }
    }
}

