/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.rollup.model;

import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.time.Instant;
import java.util.Objects;

public class ContinuousMetadata
implements ToXContentObject,
Writeable {
    private static final String NEXT_WINDOW_START_TIME_FIELD = "next_window_start_time";
    private static final String NEXT_WINDOW_START_TIME_FIELD_IN_MILLIS = "next_window_start_time_in_millis";
    private static final String NEXT_WINDOW_END_TIME_FIELD = "next_window_end_time";
    private static final String NEXT_WINDOW_END_TIME_FIELD_IN_MILLIS = "next_window_end_time_in_millis";
    private final Instant nextWindowStartTime;
    private final Instant nextWindowEndTime;

    public ContinuousMetadata(Instant nextWindowStartTime, Instant nextWindowEndTime) {
        this.nextWindowStartTime = nextWindowStartTime;
        this.nextWindowEndTime = nextWindowEndTime;
    }

    public ContinuousMetadata(StreamInput sin) throws IOException {
        this.nextWindowStartTime = sin.readInstant();
        this.nextWindowEndTime = sin.readInstant();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().timeField(NEXT_WINDOW_START_TIME_FIELD, NEXT_WINDOW_START_TIME_FIELD_IN_MILLIS, this.nextWindowStartTime.toEpochMilli()).timeField(NEXT_WINDOW_END_TIME_FIELD, NEXT_WINDOW_END_TIME_FIELD_IN_MILLIS, this.nextWindowEndTime.toEpochMilli()).endObject();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeInstant(this.nextWindowStartTime);
        out.writeInstant(this.nextWindowEndTime);
    }

    public Instant getNextWindowStartTime() {
        return this.nextWindowStartTime;
    }

    public Instant getNextWindowEndTime() {
        return this.nextWindowEndTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContinuousMetadata that = (ContinuousMetadata)o;
        return Objects.equals(this.nextWindowStartTime, that.nextWindowStartTime) && Objects.equals(this.nextWindowEndTime, that.nextWindowEndTime);
    }

    public int hashCode() {
        return Objects.hash(this.nextWindowStartTime, this.nextWindowEndTime);
    }

    public String toString() {
        return "ContinuousMetadata{nextWindowStartTime=" + String.valueOf(this.nextWindowStartTime) + ", nextWindowEndTime=" + String.valueOf(this.nextWindowEndTime) + "}";
    }

    public static ContinuousMetadata parse(XContentParser xcp) throws IOException {
        Instant windowStartTime = null;
        Instant windowEndTime = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "next_window_start_time": {
                    windowStartTime = LuceniaExtensions.parseInstant(xcp);
                    break;
                }
                case "next_window_end_time": {
                    windowEndTime = LuceniaExtensions.parseInstant(xcp);
                }
            }
        }
        if (windowStartTime == null) {
            throw new IllegalArgumentException("Next window start time must not be null for a continuous job");
        }
        if (windowEndTime == null) {
            throw new IllegalArgumentException("Next window end time must not be null for a continuous job");
        }
        return new ContinuousMetadata(windowStartTime, windowEndTime);
    }
}

