/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.rollup.model;

import io.lucenia.indexmanagement.common.model.dimension.DateHistogram;
import io.lucenia.indexmanagement.common.model.dimension.Dimension;
import io.lucenia.indexmanagement.common.model.dimension.Histogram;
import io.lucenia.indexmanagement.common.model.dimension.Terms;
import io.lucenia.indexmanagement.rollup.model.Rollup;
import io.lucenia.indexmanagement.rollup.model.RollupMetrics;
import io.lucenia.indexmanagement.rollup.model.metric.Metric;
import io.skylite.LuceniaVersion;
import io.skylite.Version;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.jobs.schedule.Schedule;
import io.skylite.core.security.auth.User;
import io.skylite.core.settings.Settings;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.jobs.schedule.IntervalSchedule;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.codec.digest.DigestUtils;

public class ISMRollup
implements ToXContentObject,
Writeable {
    private final String description;
    private final String targetIndex;
    private final Settings targetIndexSettings;
    private final int pageSize;
    private final List<Dimension> dimensions;
    private final List<RollupMetrics> metrics;

    public ISMRollup(String description, String targetIndex, Settings targetIndexSettings, int pageSize, List<Dimension> dimensions, List<RollupMetrics> metrics) {
        if (pageSize < 1 || pageSize > 10000) {
            throw new IllegalArgumentException("Page size must be between 1 and 10000");
        }
        if (description == null || description.isEmpty()) {
            throw new IllegalArgumentException("Description cannot be empty");
        }
        if (targetIndex == null || targetIndex.isEmpty()) {
            throw new IllegalArgumentException("Target Index cannot be empty");
        }
        long dateHistogramCount = 0L;
        for (Dimension dimension : dimensions) {
            if (dimension.getType() != Dimension.Type.DATE_HISTOGRAM) continue;
            ++dateHistogramCount;
        }
        if (dateHistogramCount != 1L) {
            throw new IllegalArgumentException("Must specify precisely one date histogram dimension");
        }
        if (dimensions.get(0).getType() != Dimension.Type.DATE_HISTOGRAM) {
            throw new IllegalArgumentException("The first dimension must be a date histogram");
        }
        this.description = description;
        this.targetIndex = targetIndex;
        this.targetIndexSettings = targetIndexSettings;
        this.pageSize = pageSize;
        this.dimensions = dimensions;
        this.metrics = metrics;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("description", this.description);
        builder.field("target_index", this.targetIndex);
        builder.field("page_size", this.pageSize);
        builder.field("dimensions", this.dimensions);
        builder.field("metrics", this.metrics);
        if (this.targetIndexSettings != null) {
            builder.startObject("target_index_settings");
            this.targetIndexSettings.toXContent(builder, params);
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public Rollup toRollup(String sourceIndex, User user) {
        String id = sourceIndex + this.toString();
        Instant currentTime = Instant.now();
        return new Rollup(DigestUtils.sha1Hex((String)id), -2L, 0L, true, 1L, (Schedule)new IntervalSchedule(Instant.now(), 1, ChronoUnit.MINUTES), currentTime, currentTime, this.description, sourceIndex, this.targetIndex, this.targetIndexSettings, null, this.pageSize, null, false, this.dimensions, this.metrics, user);
    }

    public Rollup toRollup(String sourceIndex) {
        return this.toRollup(sourceIndex, null);
    }

    public ISMRollup(StreamInput sin) throws IOException {
        this.description = sin.readString();
        this.targetIndex = sin.readString();
        this.targetIndexSettings = sin.getVersion().onOrAfter((Version)LuceniaVersion.V_0_9_0) && sin.readBoolean() ? Settings.readSettingsFromStream((StreamInput)sin) : null;
        this.pageSize = sin.readInt();
        ArrayList<Dimension> dimensionsList = new ArrayList<Dimension>();
        int size = sin.readVInt();
        block5: for (int i = 0; i < size; ++i) {
            Dimension.Type type = (Dimension.Type)sin.readEnum(Dimension.Type.class);
            if (type == null) {
                throw new IllegalArgumentException("Dimension type cannot be null");
            }
            switch (type) {
                case DATE_HISTOGRAM: {
                    dimensionsList.add(new DateHistogram(sin));
                    continue block5;
                }
                case TERMS: {
                    dimensionsList.add(new Terms(sin));
                    continue block5;
                }
                case HISTOGRAM: {
                    dimensionsList.add(new Histogram(sin));
                }
            }
        }
        this.dimensions = dimensionsList;
        this.metrics = sin.readList(RollupMetrics::new);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.targetIndex);
        sb.append(this.targetIndexSettings);
        sb.append(this.pageSize);
        for (Dimension dimension : this.dimensions) {
            sb.append((Object)dimension.getType());
            sb.append(dimension.getSourceField());
        }
        for (RollupMetrics metric : this.metrics) {
            sb.append(metric.getSourceField());
            for (Metric m : metric.getMetrics()) {
                sb.append((Object)m.getType());
            }
        }
        return sb.toString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.description);
        out.writeString(this.targetIndex);
        if (out.getVersion().onOrAfter((Version)LuceniaVersion.V_0_9_0)) {
            out.writeBoolean(this.targetIndexSettings != null);
            if (this.targetIndexSettings != null) {
                Settings.writeSettingsToStream((Settings)this.targetIndexSettings, (StreamOutput)out);
            }
        }
        out.writeInt(this.pageSize);
        out.writeVInt(this.dimensions.size());
        for (Dimension dimension : this.dimensions) {
            out.writeEnum((Enum)dimension.getType());
            if (dimension instanceof DateHistogram) {
                ((DateHistogram)dimension).writeTo(out);
                continue;
            }
            if (dimension instanceof Terms) {
                ((Terms)dimension).writeTo(out);
                continue;
            }
            if (!(dimension instanceof Histogram)) continue;
            ((Histogram)dimension).writeTo(out);
        }
        out.writeCollection(this.metrics);
    }

    public String getDescription() {
        return this.description;
    }

    public String getTargetIndex() {
        return this.targetIndex;
    }

    public Settings getTargetIndexSettings() {
        return this.targetIndexSettings;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public List<Dimension> getDimensions() {
        return this.dimensions;
    }

    public List<RollupMetrics> getMetrics() {
        return this.metrics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ISMRollup ismRollup = (ISMRollup)o;
        return this.pageSize == ismRollup.pageSize && Objects.equals(this.description, ismRollup.description) && Objects.equals(this.targetIndex, ismRollup.targetIndex) && Objects.equals(this.targetIndexSettings, ismRollup.targetIndexSettings) && Objects.equals(this.dimensions, ismRollup.dimensions) && Objects.equals(this.metrics, ismRollup.metrics);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.targetIndex, this.targetIndexSettings, this.pageSize, this.dimensions, this.metrics);
    }

    public static ISMRollup parse(XContentParser xcp) throws IOException {
        String description = "";
        String targetIndex = "";
        Settings targetIndexSettings = null;
        int pageSize = 0;
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
        ArrayList<RollupMetrics> metrics = new ArrayList<RollupMetrics>();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block16: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "description": {
                    description = xcp.text();
                    continue block16;
                }
                case "target_index": {
                    targetIndex = xcp.text();
                    continue block16;
                }
                case "target_index_settings": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    targetIndexSettings = Settings.fromXContent((XContentParser)xcp);
                    continue block16;
                }
                case "page_size": {
                    pageSize = xcp.intValue();
                    continue block16;
                }
                case "dimensions": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        dimensions.add(Dimension.parse(xcp));
                    }
                    continue block16;
                }
                case "metrics": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        metrics.add(RollupMetrics.parse(xcp));
                    }
                    continue block16;
                }
            }
            throw new IllegalArgumentException("Invalid field, [" + fieldName + "] not supported in ISM Rollup.");
        }
        return new ISMRollup(description, targetIndex, targetIndexSettings, pageSize, dimensions, metrics);
    }
}

