/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.rollup.model;

import io.lucenia.indexmanagement.common.model.dimension.DateHistogram;
import io.lucenia.indexmanagement.common.model.dimension.Dimension;
import io.lucenia.indexmanagement.common.model.dimension.Histogram;
import io.lucenia.indexmanagement.common.model.dimension.Terms;
import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.lucenia.indexmanagement.rollup.model.RollupMetrics;
import io.lucenia.indexmanagement.rollup.query.QueryStringQueryUtil;
import io.skylite.LuceniaVersion;
import io.skylite.Version;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.index.query.BoolQueryBuilder;
import io.skylite.core.index.query.DisMaxQueryBuilder;
import io.skylite.core.index.query.MatchPhraseQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.QueryStringQueryBuilder;
import io.skylite.core.index.query.RangeQueryBuilder;
import io.skylite.core.index.query.TermQueryBuilder;
import io.skylite.core.jobs.ScheduledJobParameter;
import io.skylite.core.jobs.schedule.Schedule;
import io.skylite.core.security.auth.User;
import io.skylite.core.settings.IndexScopedSettings;
import io.skylite.core.settings.Settings;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.jobs.schedule.CronSchedule;
import io.skylite.jobs.schedule.IntervalSchedule;
import io.skylite.jobs.schedule.ScheduleParser;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.index.query.BoostingQueryBuilder;
import org.opensearch.index.query.ConstantScoreQueryBuilder;
import org.opensearch.index.query.TermsQueryBuilder;

public class Rollup
implements ScheduledJobParameter,
Writeable {
    public static final long ROLLUP_LOCK_DURATION_SECONDS = 1800L;
    public static final String ROLLUP_TYPE = "rollup";
    public static final String ROLLUP_ID_FIELD = "rollup_id";
    public static final String ENABLED_FIELD = "enabled";
    public static final String SCHEMA_VERSION_FIELD = "schema_version";
    public static final String SCHEDULE_FIELD = "schedule";
    public static final String LAST_UPDATED_TIME_FIELD = "last_updated_time";
    public static final String ENABLED_TIME_FIELD = "enabled_time";
    public static final String DESCRIPTION_FIELD = "description";
    public static final String SOURCE_INDEX_FIELD = "source_index";
    public static final String TARGET_INDEX_FIELD = "target_index";
    public static final String TARGET_INDEX_SETTINGS_FIELD = "target_index_settings";
    public static final String METADATA_ID_FIELD = "metadata_id";
    public static final String ROLES_FIELD = "roles";
    public static final String PAGE_SIZE_FIELD = "page_size";
    public static final String DELAY_FIELD = "delay";
    public static final String CONTINUOUS_FIELD = "continuous";
    public static final String DIMENSIONS_FIELD = "dimensions";
    public static final String METRICS_FIELD = "metrics";
    public static final int MINIMUM_JOB_INTERVAL = 1;
    public static final int MINIMUM_DELAY = 0;
    public static final int MINIMUM_PAGE_SIZE = 1;
    public static final int MAXIMUM_PAGE_SIZE = 10000;
    public static final String ROLLUP_DOC_ID_FIELD = "rollup._id";
    public static final String ROLLUP_DOC_COUNT_FIELD = "_doc_count";
    public static final String ROLLUP_DOC_SCHEMA_VERSION_FIELD = "rollup._schema_version";
    public static final String USER_FIELD = "user";
    private final String id;
    private final long seqNo;
    private final long primaryTerm;
    private final boolean enabled;
    private final long schemaVersion;
    private Schedule jobSchedule;
    private final Instant jobLastUpdatedTime;
    private final Instant jobEnabledTime;
    private final String description;
    private final String sourceIndex;
    private final String targetIndex;
    private final Settings targetIndexSettings;
    private final String metadataID;
    private final int pageSize;
    private final Long delay;
    private final boolean continuous;
    private final List<Dimension> dimensions;
    private final List<RollupMetrics> metrics;
    private final User user;

    public Rollup(String id, long seqNo, long primaryTerm, boolean enabled, long schemaVersion, Schedule jobSchedule, Instant jobLastUpdatedTime, Instant jobEnabledTime, String description, String sourceIndex, String targetIndex, Settings targetIndexSettings, String metadataID, int pageSize, Long delay, boolean continuous, List<Dimension> dimensions, List<RollupMetrics> metrics, User user) {
        if (enabled) {
            if (jobEnabledTime == null) {
                throw new IllegalArgumentException("Job enabled time must be present if the job is enabled");
            }
        } else if (jobEnabledTime != null) {
            throw new IllegalArgumentException("Job enabled time must not be present if the job is disabled");
        }
        if (!Objects.equals(jobSchedule.getDelay(), delay) && continuous) {
            if (jobSchedule instanceof CronSchedule) {
                CronSchedule cronSchedule = (CronSchedule)jobSchedule;
                jobSchedule = new CronSchedule(cronSchedule.getCronExpression(), cronSchedule.getTimeZone(), delay == null ? 0L : delay);
            } else if (jobSchedule instanceof IntervalSchedule) {
                IntervalSchedule intervalSchedule = (IntervalSchedule)jobSchedule;
                jobSchedule = new IntervalSchedule(intervalSchedule.getStartTime(), intervalSchedule.getInterval(), intervalSchedule.getUnit(), delay == null ? 0L : delay);
            }
        }
        if (jobSchedule instanceof IntervalSchedule && ((IntervalSchedule)jobSchedule).getInterval() < 1) {
            throw new IllegalArgumentException("Rollup job schedule interval must be greater than 0");
        }
        if (sourceIndex.equals(targetIndex)) {
            throw new IllegalArgumentException("Your source and target index cannot be the same");
        }
        if (targetIndexSettings != null) {
            new IndexScopedSettings(null, IndexScopedSettings.BUILT_IN_INDEX_SETTINGS).validate(targetIndexSettings, true);
        }
        long dateHistogramCount = 0L;
        for (Dimension dimension : dimensions) {
            if (dimension.getType() != Dimension.Type.DATE_HISTOGRAM) continue;
            ++dateHistogramCount;
        }
        if (dateHistogramCount != 1L) {
            throw new IllegalArgumentException("Must specify precisely one date histogram dimension");
        }
        if (dimensions.get(0).getType() != Dimension.Type.DATE_HISTOGRAM) {
            throw new IllegalArgumentException("The first dimension must be a date histogram");
        }
        if (pageSize < 1 || pageSize > 10000) {
            throw new IllegalArgumentException("Page size must be between 1 and 10,000");
        }
        if (delay != null) {
            if (delay < 0L) {
                throw new IllegalArgumentException("Delay must be non-negative if set");
            }
            if (delay > Instant.now().toEpochMilli()) {
                throw new IllegalArgumentException("Delay must be less than the current unix time");
            }
        }
        this.id = id;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
        this.enabled = enabled;
        this.schemaVersion = schemaVersion;
        this.jobSchedule = jobSchedule;
        this.jobLastUpdatedTime = jobLastUpdatedTime;
        this.jobEnabledTime = jobEnabledTime;
        this.description = description;
        this.sourceIndex = sourceIndex;
        this.targetIndex = targetIndex;
        this.targetIndexSettings = targetIndexSettings;
        this.metadataID = metadataID;
        this.pageSize = pageSize;
        this.delay = delay;
        this.continuous = continuous;
        this.dimensions = dimensions;
        this.metrics = metrics;
        this.user = user;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getName() {
        return this.id;
    }

    public Instant getEnabledTime() {
        return this.jobEnabledTime;
    }

    public Schedule getSchedule() {
        return this.jobSchedule;
    }

    public Instant getLastUpdateTime() {
        return this.jobLastUpdatedTime;
    }

    public Long getLockDurationSeconds() {
        return 1800L;
    }

    public Rollup(StreamInput sin) throws IOException {
        this.id = sin.readString();
        this.seqNo = sin.readLong();
        this.primaryTerm = sin.readLong();
        this.enabled = sin.readBoolean();
        this.schemaVersion = sin.readLong();
        ScheduleType scheduleType = (ScheduleType)sin.readEnum(ScheduleType.class);
        if (scheduleType == null) {
            throw new IllegalArgumentException("ScheduleType cannot be null");
        }
        switch (scheduleType.ordinal()) {
            case 0: {
                this.jobSchedule = new CronSchedule(sin);
                break;
            }
            case 1: {
                this.jobSchedule = new IntervalSchedule(sin);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown schedule type: " + String.valueOf((Object)scheduleType));
            }
        }
        this.jobLastUpdatedTime = sin.readInstant();
        this.jobEnabledTime = sin.readOptionalInstant();
        this.description = sin.readString();
        this.sourceIndex = sin.readString();
        this.targetIndex = sin.readString();
        this.targetIndexSettings = sin.getVersion().onOrAfter((Version)LuceniaVersion.V_0_9_0) && sin.readBoolean() ? Settings.readSettingsFromStream((StreamInput)sin) : null;
        this.metadataID = sin.readOptionalString();
        sin.readStringArray();
        this.pageSize = sin.readInt();
        this.delay = sin.readOptionalLong();
        this.continuous = sin.readBoolean();
        ArrayList<Dimension> dimensionsList = new ArrayList<Dimension>();
        int size = sin.readVInt();
        block9: for (int i = 0; i < size; ++i) {
            Dimension.Type type = (Dimension.Type)sin.readEnum(Dimension.Type.class);
            if (type == null) {
                throw new IllegalArgumentException("Dimension type cannot be null");
            }
            switch (type) {
                case DATE_HISTOGRAM: {
                    dimensionsList.add(new DateHistogram(sin));
                    continue block9;
                }
                case TERMS: {
                    dimensionsList.add(new Terms(sin));
                    continue block9;
                }
                case HISTOGRAM: {
                    dimensionsList.add(new Histogram(sin));
                }
            }
        }
        this.dimensions = dimensionsList;
        this.metrics = sin.readList(RollupMetrics::new);
        this.user = sin.readBoolean() ? new User(sin) : null;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (params.paramAsBoolean("with_type", true)) {
            builder.startObject(ROLLUP_TYPE);
        }
        builder.field(ROLLUP_ID_FIELD, this.id);
        builder.field(ENABLED_FIELD, this.enabled);
        builder.field(SCHEDULE_FIELD, (ToXContent)this.jobSchedule);
        LuceniaExtensions.optionalTimeField(builder, LAST_UPDATED_TIME_FIELD, this.jobLastUpdatedTime);
        LuceniaExtensions.optionalTimeField(builder, ENABLED_TIME_FIELD, this.jobEnabledTime);
        builder.field(DESCRIPTION_FIELD, this.description);
        builder.field(SCHEMA_VERSION_FIELD, this.schemaVersion);
        builder.field(SOURCE_INDEX_FIELD, this.sourceIndex);
        builder.field(TARGET_INDEX_FIELD, this.targetIndex);
        builder.field(METADATA_ID_FIELD, this.metadataID);
        builder.field(PAGE_SIZE_FIELD, this.pageSize);
        builder.field(DELAY_FIELD, this.delay);
        builder.field(CONTINUOUS_FIELD, this.continuous);
        builder.field(DIMENSIONS_FIELD, (Object)this.dimensions.toArray());
        builder.field(METRICS_FIELD, (Object)this.metrics.toArray());
        if (this.targetIndexSettings != null) {
            builder.startObject(TARGET_INDEX_SETTINGS_FIELD);
            this.targetIndexSettings.toXContent(builder, params);
            builder.endObject();
        }
        if (params.paramAsBoolean("with_user", true)) {
            LuceniaExtensions.optionalUserField(builder, USER_FIELD, this.user);
        }
        if (params.paramAsBoolean("with_type", true)) {
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeLong(this.seqNo);
        out.writeLong(this.primaryTerm);
        out.writeBoolean(this.enabled);
        out.writeLong(this.schemaVersion);
        if (this.jobSchedule instanceof CronSchedule) {
            out.writeEnum((Enum)ScheduleType.CRON);
        } else {
            out.writeEnum((Enum)ScheduleType.INTERVAL);
        }
        this.jobSchedule.writeTo(out);
        out.writeInstant(this.jobLastUpdatedTime);
        out.writeOptionalInstant(this.jobEnabledTime);
        out.writeString(this.description);
        out.writeString(this.sourceIndex);
        out.writeString(this.targetIndex);
        if (out.getVersion().onOrAfter((Version)LuceniaVersion.V_0_9_0)) {
            out.writeBoolean(this.targetIndexSettings != null);
            if (this.targetIndexSettings != null) {
                Settings.writeSettingsToStream((Settings)this.targetIndexSettings, (StreamOutput)out);
            }
        }
        out.writeOptionalString(this.metadataID);
        out.writeStringArray(new String[0]);
        out.writeInt(this.pageSize);
        out.writeOptionalLong(this.delay);
        out.writeBoolean(this.continuous);
        out.writeVInt(this.dimensions.size());
        for (Dimension dimension : this.dimensions) {
            out.writeEnum((Enum)dimension.getType());
            if (dimension instanceof DateHistogram) {
                ((DateHistogram)dimension).writeTo(out);
                continue;
            }
            if (dimension instanceof Terms) {
                ((Terms)dimension).writeTo(out);
                continue;
            }
            if (!(dimension instanceof Histogram)) continue;
            ((Histogram)dimension).writeTo(out);
        }
        out.writeCollection(this.metrics);
        out.writeBoolean(this.user != null);
        if (this.user != null) {
            this.user.writeTo(out);
        }
    }

    public String getId() {
        return this.id;
    }

    public long getSeqNo() {
        return this.seqNo;
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public long getSchemaVersion() {
        return this.schemaVersion;
    }

    public Schedule getJobSchedule() {
        return this.jobSchedule;
    }

    public Instant getJobLastUpdatedTime() {
        return this.jobLastUpdatedTime;
    }

    public Instant getJobEnabledTime() {
        return this.jobEnabledTime;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSourceIndex() {
        return this.sourceIndex;
    }

    public String getTargetIndex() {
        return this.targetIndex;
    }

    public Settings getTargetIndexSettings() {
        return this.targetIndexSettings;
    }

    public String getMetadataID() {
        return this.metadataID;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public Long getDelay() {
        return this.delay;
    }

    public boolean getContinuous() {
        return this.continuous;
    }

    public List<Dimension> getDimensions() {
        return this.dimensions;
    }

    public List<RollupMetrics> getMetrics() {
        return this.metrics;
    }

    public User getUser() {
        return this.user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rollup rollup = (Rollup)o;
        return this.seqNo == rollup.seqNo && this.primaryTerm == rollup.primaryTerm && this.enabled == rollup.enabled && this.schemaVersion == rollup.schemaVersion && this.pageSize == rollup.pageSize && this.continuous == rollup.continuous && Objects.equals(this.id, rollup.id) && Objects.equals(this.jobSchedule, rollup.jobSchedule) && Objects.equals(this.jobLastUpdatedTime, rollup.jobLastUpdatedTime) && Objects.equals(this.jobEnabledTime, rollup.jobEnabledTime) && Objects.equals(this.description, rollup.description) && Objects.equals(this.sourceIndex, rollup.sourceIndex) && Objects.equals(this.targetIndex, rollup.targetIndex) && Objects.equals(this.targetIndexSettings, rollup.targetIndexSettings) && Objects.equals(this.metadataID, rollup.metadataID) && Objects.equals(this.delay, rollup.delay) && Objects.equals(this.dimensions, rollup.dimensions) && Objects.equals(this.metrics, rollup.metrics) && Objects.equals(this.user, rollup.user);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.seqNo, this.primaryTerm, this.enabled, this.schemaVersion, this.jobSchedule, this.jobLastUpdatedTime, this.jobEnabledTime, this.description, this.sourceIndex, this.targetIndex, this.targetIndexSettings, this.metadataID, this.pageSize, this.delay, this.continuous, this.dimensions, this.metrics, this.user);
    }

    public String toString() {
        return "Rollup{id='" + this.id + "', seqNo=" + this.seqNo + ", primaryTerm=" + this.primaryTerm + ", enabled=" + this.enabled + ", schemaVersion=" + this.schemaVersion + ", jobSchedule=" + String.valueOf(this.jobSchedule) + ", jobLastUpdatedTime=" + String.valueOf(this.jobLastUpdatedTime) + ", jobEnabledTime=" + String.valueOf(this.jobEnabledTime) + ", description='" + this.description + "', sourceIndex='" + this.sourceIndex + "', targetIndex='" + this.targetIndex + "', targetIndexSettings=" + String.valueOf(this.targetIndexSettings) + ", metadataID='" + this.metadataID + "', pageSize=" + this.pageSize + ", delay=" + this.delay + ", continuous=" + this.continuous + ", dimensions=" + String.valueOf(this.dimensions) + ", metrics=" + String.valueOf(this.metrics) + ", user=" + String.valueOf(this.user) + "}";
    }

    public static Rollup parse(XContentParser xcp, String id, long seqNo, long primaryTerm) throws IOException {
        Schedule schedule = null;
        long schemaVersion = 1L;
        Instant lastUpdatedTime = null;
        Instant enabledTime = null;
        boolean enabled = true;
        String description = null;
        String sourceIndex = null;
        String targetIndex = null;
        Settings targetIndexSettings = null;
        String metadataID = null;
        Integer pageSize = null;
        Long delay = null;
        boolean continuous = false;
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
        ArrayList<RollupMetrics> metrics = new ArrayList<RollupMetrics>();
        User user = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block40: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "rollup_id": {
                    if (xcp.text() != null) continue block40;
                    throw new IllegalArgumentException("The rollup_id field is null");
                }
                case "enabled": {
                    enabled = xcp.booleanValue();
                    continue block40;
                }
                case "schedule": {
                    schedule = ScheduleParser.parse((XContentParser)xcp);
                    continue block40;
                }
                case "schema_version": {
                    schemaVersion = xcp.longValue();
                    continue block40;
                }
                case "enabled_time": {
                    enabledTime = LuceniaExtensions.parseInstant(xcp);
                    continue block40;
                }
                case "last_updated_time": {
                    lastUpdatedTime = LuceniaExtensions.parseInstant(xcp);
                    continue block40;
                }
                case "description": {
                    description = xcp.text();
                    continue block40;
                }
                case "source_index": {
                    sourceIndex = xcp.text();
                    continue block40;
                }
                case "target_index": {
                    targetIndex = xcp.text();
                    continue block40;
                }
                case "target_index_settings": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    targetIndexSettings = Settings.fromXContent((XContentParser)xcp);
                    continue block40;
                }
                case "metadata_id": {
                    metadataID = xcp.textOrNull();
                    continue block40;
                }
                case "roles": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        xcp.text();
                    }
                    continue block40;
                }
                case "page_size": {
                    pageSize = xcp.intValue();
                    continue block40;
                }
                case "delay": {
                    delay = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : Long.valueOf(xcp.longValue());
                    continue block40;
                }
                case "continuous": {
                    continuous = xcp.booleanValue();
                    continue block40;
                }
                case "dimensions": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        dimensions.add(Dimension.parse(xcp));
                    }
                    continue block40;
                }
                case "metrics": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        metrics.add(RollupMetrics.parse(xcp));
                    }
                    continue block40;
                }
                case "user": {
                    user = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : User.parse((XContentParser)xcp);
                    continue block40;
                }
            }
            throw new IllegalArgumentException("Invalid field [" + fieldName + "] found in Rollup.");
        }
        if (enabled && enabledTime == null) {
            enabledTime = Instant.now();
        } else if (!enabled) {
            enabledTime = null;
        }
        if ((seqNo == -2L || primaryTerm == 0L) && schedule instanceof IntervalSchedule) {
            IntervalSchedule intervalSchedule = (IntervalSchedule)schedule;
            schedule = new IntervalSchedule(intervalSchedule.getStartTime() != null ? intervalSchedule.getStartTime() : Instant.now(), intervalSchedule.getInterval(), intervalSchedule.getUnit(), intervalSchedule.getDelay() != null ? intervalSchedule.getDelay() : 0L);
        }
        if (schedule == null) {
            throw new IllegalArgumentException("Rollup schedule is null");
        }
        if (description == null) {
            throw new IllegalArgumentException("Rollup description is null");
        }
        if (sourceIndex == null) {
            throw new IllegalArgumentException("Rollup source index is null");
        }
        if (targetIndex == null) {
            throw new IllegalArgumentException("Rollup target index is null");
        }
        if (pageSize == null) {
            throw new IllegalArgumentException("Rollup page size is null");
        }
        return new Rollup(id, seqNo, primaryTerm, enabled, schemaVersion, schedule, lastUpdatedTime != null ? lastUpdatedTime : Instant.now(), enabledTime, description, sourceIndex, targetIndex, targetIndexSettings, metadataID, pageSize, delay, continuous, dimensions, metrics, user);
    }

    public static Rollup parse(XContentParser xcp) throws IOException {
        return Rollup.parse(xcp, "", -2L, 0L);
    }

    public QueryBuilder rewriteQueryBuilder(QueryBuilder queryBuilder, Map<String, String> fieldNameMappingTypeMap, String concreteIndexName) throws IOException {
        if (queryBuilder instanceof TermQueryBuilder) {
            TermQueryBuilder tqb = (TermQueryBuilder)queryBuilder;
            String updatedFieldName = tqb.fieldName() + "." + Dimension.Type.TERMS.getType();
            TermQueryBuilder updated = new TermQueryBuilder(updatedFieldName, tqb.value());
            updated.boost(tqb.boost());
            updated.queryName(tqb.queryName());
            return updated;
        }
        if (queryBuilder instanceof TermsQueryBuilder) {
            TermsQueryBuilder tqb = (TermsQueryBuilder)queryBuilder;
            String updatedFieldName = tqb.fieldName() + "." + Dimension.Type.TERMS.getType();
            TermsQueryBuilder updated = new TermsQueryBuilder(updatedFieldName, (Iterable)tqb.values());
            updated.boost(tqb.boost());
            updated.queryName(tqb.queryName());
            return updated;
        }
        if (queryBuilder instanceof RangeQueryBuilder) {
            RangeQueryBuilder rqb = (RangeQueryBuilder)queryBuilder;
            String updatedFieldName = rqb.fieldName() + "." + fieldNameMappingTypeMap.get(rqb.fieldName());
            RangeQueryBuilder updated = new RangeQueryBuilder(updatedFieldName);
            updated.includeLower(rqb.includeLower());
            updated.includeUpper(rqb.includeUpper());
            updated.from(rqb.from());
            updated.to(rqb.to());
            if (rqb.timeZone() != null) {
                updated.timeZone(rqb.timeZone());
            }
            if (rqb.format() != null) {
                updated.format(rqb.format());
            }
            if (rqb.relation() != null && rqb.relation().name() != null) {
                updated.relation(rqb.relation().name());
            }
            updated.queryName(rqb.queryName());
            updated.boost(rqb.boost());
            return updated;
        }
        if (queryBuilder instanceof BoolQueryBuilder) {
            BoolQueryBuilder bqb = (BoolQueryBuilder)queryBuilder;
            BoolQueryBuilder newBool = new BoolQueryBuilder();
            if (bqb.must() != null) {
                for (QueryBuilder must : bqb.must()) {
                    newBool.must(this.rewriteQueryBuilder(must, fieldNameMappingTypeMap, concreteIndexName));
                }
            }
            if (bqb.mustNot() != null) {
                for (QueryBuilder mustNot : bqb.mustNot()) {
                    newBool.mustNot(this.rewriteQueryBuilder(mustNot, fieldNameMappingTypeMap, concreteIndexName));
                }
            }
            if (bqb.should() != null) {
                for (QueryBuilder should : bqb.should()) {
                    newBool.should(this.rewriteQueryBuilder(should, fieldNameMappingTypeMap, concreteIndexName));
                }
            }
            if (bqb.filter() != null) {
                for (QueryBuilder filter : bqb.filter()) {
                    newBool.filter(this.rewriteQueryBuilder(filter, fieldNameMappingTypeMap, concreteIndexName));
                }
            }
            newBool.minimumShouldMatch(bqb.minimumShouldMatch());
            newBool.adjustPureNegative(bqb.adjustPureNegative());
            newBool.queryName(bqb.queryName());
            newBool.boost(bqb.boost());
            return newBool;
        }
        if (queryBuilder instanceof BoostingQueryBuilder) {
            BoostingQueryBuilder boostQb = (BoostingQueryBuilder)queryBuilder;
            QueryBuilder newPositive = this.rewriteQueryBuilder(boostQb.positiveQuery(), fieldNameMappingTypeMap, concreteIndexName);
            QueryBuilder newNegative = this.rewriteQueryBuilder(boostQb.negativeQuery(), fieldNameMappingTypeMap, concreteIndexName);
            BoostingQueryBuilder newBoost = new BoostingQueryBuilder(newPositive, newNegative);
            if (boostQb.negativeBoost() >= 0.0f) {
                newBoost.negativeBoost(boostQb.negativeBoost());
            }
            newBoost.queryName(boostQb.queryName());
            newBoost.boost(boostQb.boost());
            return newBoost;
        }
        if (queryBuilder instanceof ConstantScoreQueryBuilder) {
            ConstantScoreQueryBuilder csqb = (ConstantScoreQueryBuilder)queryBuilder;
            QueryBuilder newInner = this.rewriteQueryBuilder(csqb.innerQuery(), fieldNameMappingTypeMap, concreteIndexName);
            ConstantScoreQueryBuilder newConstant = new ConstantScoreQueryBuilder(newInner);
            newConstant.boost(csqb.boost());
            newConstant.queryName(csqb.queryName());
            return newConstant;
        }
        if (queryBuilder instanceof DisMaxQueryBuilder) {
            DisMaxQueryBuilder dmqb = (DisMaxQueryBuilder)queryBuilder;
            DisMaxQueryBuilder newDisMax = new DisMaxQueryBuilder();
            for (QueryBuilder inner : dmqb.innerQueries()) {
                newDisMax.add(this.rewriteQueryBuilder(inner, fieldNameMappingTypeMap, concreteIndexName));
            }
            newDisMax.tieBreaker(dmqb.tieBreaker());
            newDisMax.queryName(dmqb.queryName());
            newDisMax.boost(dmqb.boost());
            return newDisMax;
        }
        if (queryBuilder instanceof MatchPhraseQueryBuilder) {
            MatchPhraseQueryBuilder mpqb = (MatchPhraseQueryBuilder)queryBuilder;
            String newFieldName = mpqb.fieldName() + "." + Dimension.Type.TERMS.getType();
            MatchPhraseQueryBuilder newMatch = new MatchPhraseQueryBuilder(newFieldName, mpqb.value());
            newMatch.queryName(mpqb.queryName());
            newMatch.boost(mpqb.boost());
            return newMatch;
        }
        if (queryBuilder instanceof QueryStringQueryBuilder) {
            return QueryStringQueryUtil.rewriteQueryStringQuery(queryBuilder, concreteIndexName);
        }
        return queryBuilder;
    }

    public static enum ScheduleType {
        CRON,
        INTERVAL;

    }

    public static class Builder {
        private String id;
        private long seqNo;
        private long primaryTerm;
        private boolean enabled;
        private long schemaVersion;
        private Schedule jobSchedule;
        private Instant jobLastUpdatedTime;
        private Instant jobEnabledTime;
        private String description;
        private String sourceIndex;
        private String targetIndex;
        private Settings targetIndexSettings;
        private String metadataID;
        private int pageSize;
        private Long delay;
        private boolean continuous;
        private List<Dimension> dimensions;
        private List<RollupMetrics> metrics;
        private User user;

        public Builder(Rollup src) {
            this.id = src.id;
            this.seqNo = src.seqNo;
            this.primaryTerm = src.primaryTerm;
            this.enabled = src.enabled;
            this.schemaVersion = src.schemaVersion;
            this.jobSchedule = src.jobSchedule;
            this.jobLastUpdatedTime = src.jobLastUpdatedTime;
            this.jobEnabledTime = src.jobEnabledTime;
            this.description = src.description;
            this.sourceIndex = src.sourceIndex;
            this.targetIndex = src.targetIndex;
            this.targetIndexSettings = src.targetIndexSettings;
            this.metadataID = src.metadataID;
            this.pageSize = src.pageSize;
            this.delay = src.delay;
            this.continuous = src.continuous;
            this.dimensions = src.dimensions;
            this.metrics = src.metrics;
            this.user = src.user;
        }

        public Builder jobLastUpdatedTime(Instant val) {
            this.jobLastUpdatedTime = val;
            return this;
        }

        public Builder jobEnabledTime(Instant val) {
            this.jobEnabledTime = val;
            return this;
        }

        public Builder jobSchedule(Schedule jobSchedule) {
            this.jobSchedule = jobSchedule;
            return this;
        }

        public Builder sourceIndex(String sourceIndex) {
            this.sourceIndex = sourceIndex;
            return this;
        }

        public Builder isContinuous(boolean continuous) {
            this.continuous = continuous;
            return this;
        }

        public Builder user(User val) {
            this.user = val;
            return this;
        }

        public Builder metadataID(String val) {
            this.metadataID = val;
            return this;
        }

        public Builder enabled(boolean val) {
            this.enabled = val;
            return this;
        }

        public Builder pageSize(int val) {
            this.pageSize = val;
            return this;
        }

        public Builder schemaVersion(long val) {
            this.schemaVersion = val;
            return this;
        }

        public Builder seqNo(long val) {
            this.seqNo = val;
            return this;
        }

        public Builder primaryTerm(long val) {
            this.primaryTerm = val;
            return this;
        }

        public Builder id(String val) {
            this.id = val;
            return this;
        }

        public Builder description(String val) {
            this.description = val;
            return this;
        }

        public Builder targetIndex(String val) {
            this.targetIndex = val;
            return this;
        }

        public Builder targetIndexSettings(Settings val) {
            this.targetIndexSettings = val;
            return this;
        }

        public Builder delay(Long val) {
            this.delay = val;
            return this;
        }

        public Builder dimensions(List<Dimension> val) {
            this.dimensions = val;
            return this;
        }

        public Builder metrics(List<RollupMetrics> val) {
            this.metrics = val;
            return this;
        }

        public Rollup build() {
            return new Rollup(this.id, this.seqNo, this.primaryTerm, this.enabled, this.schemaVersion, this.jobSchedule, this.jobLastUpdatedTime, this.jobEnabledTime, this.description, this.sourceIndex, this.targetIndex, this.targetIndexSettings, this.metadataID, this.pageSize, this.delay, this.continuous, this.dimensions, this.metrics, this.user);
        }
    }
}

