/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.rollup.model;

import java.util.Objects;

public class RollupFieldMapping {
    public static final String UNKNOWN_MAPPING = "unknown";
    private final FieldType fieldType;
    private final String fieldName;
    private final String mappingType;
    private String sourceType;

    public RollupFieldMapping(FieldType fieldType, String fieldName, String mappingType, String sourceType) {
        this.fieldType = fieldType;
        this.fieldName = fieldName;
        this.mappingType = mappingType;
        this.sourceType = sourceType;
    }

    public RollupFieldMapping(FieldType fieldType, String fieldName, String mappingType) {
        this(fieldType, fieldName, mappingType, null);
    }

    public void setSourceType(String type) {
        this.sourceType = type;
    }

    public String toString() {
        return this.fieldName + "." + this.mappingType;
    }

    public String toIssue(boolean isFieldMissing) {
        if (isFieldMissing || UNKNOWN_MAPPING.equals(this.mappingType)) {
            return "missing field " + this.fieldName;
        }
        switch (this.fieldType.ordinal()) {
            case 1: {
                return "missing " + this.mappingType + " aggregation on " + this.fieldName;
            }
        }
        return "missing " + this.mappingType + " grouping on " + this.fieldName;
    }

    public String toIssue() {
        return this.toIssue(false);
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getMappingType() {
        return this.mappingType;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RollupFieldMapping that = (RollupFieldMapping)o;
        return this.fieldType == that.fieldType && Objects.equals(this.fieldName, that.fieldName) && Objects.equals(this.mappingType, that.mappingType) && Objects.equals(this.sourceType, that.sourceType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fieldType, this.fieldName, this.mappingType, this.sourceType});
    }

    public static enum FieldType {
        DIMENSION("dimensions"),
        METRIC("metrics");

        private final String type;

        private FieldType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public String toString() {
            return this.type;
        }
    }
}

