/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.rollup.model;

import java.util.Objects;

public abstract class RollupJobValidationResult {
    private RollupJobValidationResult() {
    }

    public static class Failure
    extends RollupJobValidationResult {
        private final String message;
        private final Exception exception;

        public Failure(String message, Exception exception) {
            this.message = message;
            this.exception = exception;
        }

        public Failure(String message) {
            this(message, null);
        }

        public String getMessage() {
            return this.message;
        }

        public Exception getException() {
            return this.exception;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Failure failure = (Failure)o;
            return Objects.equals(this.message, failure.message) && Objects.equals(this.exception, failure.exception);
        }

        public int hashCode() {
            return Objects.hash(this.message, this.exception);
        }

        public String toString() {
            return "Failure{message='" + this.message + "', exception=" + String.valueOf(this.exception) + "}";
        }
    }

    public static class Invalid
    extends RollupJobValidationResult {
        private final String reason;

        public Invalid(String reason) {
            this.reason = reason;
        }

        public String getReason() {
            return this.reason;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Invalid invalid = (Invalid)o;
            return Objects.equals(this.reason, invalid.reason);
        }

        public int hashCode() {
            return Objects.hash(this.reason);
        }

        public String toString() {
            return "Invalid{reason='" + this.reason + "'}";
        }
    }

    public static class Valid
    extends RollupJobValidationResult {
        private static final Valid INSTANCE = new Valid();

        private Valid() {
        }

        public static Valid getInstance() {
            return INSTANCE;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return Objects.hash(this.getClass());
        }

        public String toString() {
            return "Valid";
        }
    }
}

