/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.rollup.model;

import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.lucenia.indexmanagement.rollup.model.ContinuousMetadata;
import io.lucenia.indexmanagement.rollup.model.RollupStats;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.time.Instant;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.opensearch.search.aggregations.bucket.composite.InternalComposite;

public class RollupMetadata
implements ToXContentObject,
Writeable {
    public static final String ROLLUP_METADATA_TYPE = "rollup_metadata";
    public static final String ROLLUP_ID_FIELD = "rollup_id";
    public static final String AFTER_KEY_FIELD = "after_key";
    public static final String LAST_UPDATED_FIELD = "last_updated_time";
    public static final String LAST_UPDATED_FIELD_IN_MILLIS = "last_updated_time_in_millis";
    public static final String CONTINUOUS_FIELD = "continuous";
    public static final String STATUS_FIELD = "status";
    public static final String FAILURE_REASON = "failure_reason";
    public static final String STATS_FIELD = "stats";
    private final String id;
    private final long seqNo;
    private final long primaryTerm;
    private final String rollupID;
    private final Map<String, Object> afterKey;
    private final Instant lastUpdatedTime;
    private final ContinuousMetadata continuous;
    private final Status status;
    private final String failureReason;
    private final RollupStats stats;

    public RollupMetadata(String id, long seqNo, long primaryTerm, String rollupID, Map<String, Object> afterKey, Instant lastUpdatedTime, ContinuousMetadata continuous, Status status, String failureReason, RollupStats stats) {
        this.id = id;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
        this.rollupID = rollupID;
        this.afterKey = afterKey;
        this.lastUpdatedTime = lastUpdatedTime;
        this.continuous = continuous;
        this.status = status;
        this.failureReason = failureReason;
        this.stats = stats;
    }

    public RollupMetadata(StreamInput sin) throws IOException {
        this.id = sin.readString();
        this.seqNo = sin.readLong();
        this.primaryTerm = sin.readLong();
        this.rollupID = sin.readString();
        this.afterKey = sin.readBoolean() ? sin.readMap() : null;
        this.lastUpdatedTime = sin.readInstant();
        this.continuous = sin.readBoolean() ? new ContinuousMetadata(sin) : null;
        this.status = (Status)sin.readEnum(Status.class);
        this.failureReason = sin.readOptionalString();
        this.stats = new RollupStats(sin);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (params.paramAsBoolean("with_type", false)) {
            builder.startObject(ROLLUP_METADATA_TYPE);
        }
        builder.field(ROLLUP_ID_FIELD, this.rollupID);
        if (this.afterKey != null) {
            builder.field(AFTER_KEY_FIELD, this.afterKey);
        }
        builder.timeField(LAST_UPDATED_FIELD, LAST_UPDATED_FIELD_IN_MILLIS, this.lastUpdatedTime.toEpochMilli());
        if (this.continuous != null) {
            builder.field(CONTINUOUS_FIELD, (ToXContent)this.continuous);
        }
        builder.field(STATUS_FIELD, this.status.type);
        builder.field(FAILURE_REASON, this.failureReason);
        builder.field(STATS_FIELD, (ToXContent)this.stats);
        if (params.paramAsBoolean("with_type", false)) {
            builder.endObject();
        }
        return builder.endObject();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeLong(this.seqNo);
        out.writeLong(this.primaryTerm);
        out.writeString(this.rollupID);
        out.writeBoolean(this.afterKey != null);
        if (this.afterKey != null) {
            out.writeMap(this.afterKey);
        }
        out.writeInstant(this.lastUpdatedTime);
        out.writeBoolean(this.continuous != null);
        if (this.continuous != null) {
            this.continuous.writeTo(out);
        }
        out.writeEnum((Enum)this.status);
        out.writeOptionalString(this.failureReason);
        this.stats.writeTo(out);
    }

    public String getId() {
        return this.id;
    }

    public long getSeqNo() {
        return this.seqNo;
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public String getRollupID() {
        return this.rollupID;
    }

    public Map<String, Object> getAfterKey() {
        return this.afterKey;
    }

    public Instant getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public ContinuousMetadata getContinuous() {
        return this.continuous;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public RollupStats getStats() {
        return this.stats;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RollupMetadata that = (RollupMetadata)o;
        return this.seqNo == that.seqNo && this.primaryTerm == that.primaryTerm && Objects.equals(this.id, that.id) && Objects.equals(this.rollupID, that.rollupID) && Objects.equals(this.afterKey, that.afterKey) && Objects.equals(this.lastUpdatedTime, that.lastUpdatedTime) && Objects.equals(this.continuous, that.continuous) && this.status == that.status && Objects.equals(this.failureReason, that.failureReason) && Objects.equals(this.stats, that.stats);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.seqNo, this.primaryTerm, this.rollupID, this.afterKey, this.lastUpdatedTime, this.continuous, this.status, this.failureReason, this.stats});
    }

    public String toString() {
        return "RollupMetadata{id='" + this.id + "', seqNo=" + this.seqNo + ", primaryTerm=" + this.primaryTerm + ", rollupID='" + this.rollupID + "', afterKey=" + String.valueOf(this.afterKey) + ", lastUpdatedTime=" + String.valueOf(this.lastUpdatedTime) + ", continuous=" + String.valueOf(this.continuous) + ", status=" + String.valueOf((Object)this.status) + ", failureReason='" + this.failureReason + "', stats=" + String.valueOf(this.stats) + "}";
    }

    public static RollupMetadata parse(XContentParser xcp, String id, long seqNo, long primaryTerm) throws IOException {
        String rollupID = null;
        Map afterKey = null;
        Instant lastUpdatedTime = null;
        ContinuousMetadata continuous = null;
        Status status = null;
        String failureReason = null;
        RollupStats stats = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "rollup_id": {
                    rollupID = xcp.text();
                    break;
                }
                case "after_key": {
                    afterKey = xcp.map();
                    break;
                }
                case "last_updated_time": {
                    lastUpdatedTime = LuceniaExtensions.parseInstant(xcp);
                    break;
                }
                case "continuous": {
                    continuous = ContinuousMetadata.parse(xcp);
                    break;
                }
                case "status": {
                    status = Status.valueOf(xcp.text().toUpperCase(Locale.ROOT));
                    break;
                }
                case "failure_reason": {
                    failureReason = xcp.textOrNull();
                    break;
                }
                case "stats": {
                    stats = RollupStats.parse(xcp);
                }
            }
        }
        if (rollupID == null) {
            throw new IllegalArgumentException("RollupID must not be null");
        }
        if (lastUpdatedTime == null) {
            throw new IllegalArgumentException("Last updated time must not be null");
        }
        if (status == null) {
            throw new IllegalArgumentException("Status must not be null");
        }
        if (stats == null) {
            throw new IllegalArgumentException("Stats must not be null");
        }
        return new RollupMetadata(id, seqNo, primaryTerm, rollupID, afterKey, lastUpdatedTime, continuous, status, failureReason, stats);
    }

    public static RollupMetadata parse(XContentParser xcp) throws IOException {
        return RollupMetadata.parse(xcp, "", -2L, 0L);
    }

    public static RollupMetadata readFrom(StreamInput sin) throws IOException {
        return new RollupMetadata(sin);
    }

    public RollupMetadata incrementStats(SearchResponse response, InternalComposite internalComposite) {
        long docCount = 0L;
        for (CompositeAggregation.Bucket bucket : internalComposite.getBuckets()) {
            docCount += bucket.getDocCount();
        }
        RollupStats newStats = new RollupStats(this.stats.getPagesProcessed() + 1L, this.stats.getDocumentsProcessed() + docCount, this.stats.getRollupsIndexed(), this.stats.getIndexTimeInMillis(), this.stats.getSearchTimeInMillis() + response.getTook().millis());
        return new RollupMetadata(this.id, this.seqNo, this.primaryTerm, this.rollupID, this.afterKey, this.lastUpdatedTime, this.continuous, this.status, this.failureReason, newStats);
    }

    public RollupMetadata mergeStats(RollupStats statsToMerge) {
        RollupStats newStats = new RollupStats(this.stats.getPagesProcessed() + statsToMerge.getPagesProcessed(), this.stats.getDocumentsProcessed() + statsToMerge.getDocumentsProcessed(), this.stats.getRollupsIndexed() + statsToMerge.getRollupsIndexed(), this.stats.getIndexTimeInMillis() + statsToMerge.getIndexTimeInMillis(), this.stats.getSearchTimeInMillis() + statsToMerge.getSearchTimeInMillis());
        return new RollupMetadata(this.id, this.seqNo, this.primaryTerm, this.rollupID, this.afterKey, this.lastUpdatedTime, this.continuous, this.status, this.failureReason, newStats);
    }

    public static enum Status {
        INIT("init"),
        STARTED("started"),
        STOPPED("stopped"),
        FINISHED("finished"),
        FAILED("failed"),
        RETRY("retry");

        private final String type;

        private Status(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public String toString() {
            return this.type;
        }
    }

    public static class Builder {
        private String id;
        private long seqNo;
        private long primaryTerm;
        private String rollupID;
        private Map<String, Object> afterKey;
        private Instant lastUpdatedTime;
        private ContinuousMetadata continuous;
        private Status status;
        private String failureReason;
        private RollupStats stats;

        public Builder(RollupMetadata src) {
            this.id = src.id;
            this.seqNo = src.seqNo;
            this.primaryTerm = src.primaryTerm;
            this.rollupID = src.rollupID;
            this.afterKey = src.afterKey;
            this.lastUpdatedTime = src.lastUpdatedTime;
            this.continuous = src.continuous;
            this.status = src.status;
            this.failureReason = src.failureReason;
            this.stats = src.stats;
        }

        public Builder id(String val) {
            this.id = val;
            return this;
        }

        public Builder seqNo(long val) {
            this.seqNo = val;
            return this;
        }

        public Builder primaryTerm(long val) {
            this.primaryTerm = val;
            return this;
        }

        public Builder rollupID(String val) {
            this.rollupID = val;
            return this;
        }

        public Builder afterKey(Map<String, Object> val) {
            this.afterKey = val;
            return this;
        }

        public Builder lastUpdatedTime(Instant val) {
            this.lastUpdatedTime = val;
            return this;
        }

        public Builder continuous(ContinuousMetadata val) {
            this.continuous = val;
            return this;
        }

        public Builder status(Status val) {
            this.status = val;
            return this;
        }

        public Builder failureReason(String val) {
            this.failureReason = val;
            return this;
        }

        public Builder stats(RollupStats val) {
            this.stats = val;
            return this;
        }

        public RollupMetadata build() {
            return new RollupMetadata(this.id, this.seqNo, this.primaryTerm, this.rollupID, this.afterKey, this.lastUpdatedTime, this.continuous, this.status, this.failureReason, this.stats);
        }
    }
}

