/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.rollup.model;

import io.lucenia.indexmanagement.rollup.model.metric.Average;
import io.lucenia.indexmanagement.rollup.model.metric.Max;
import io.lucenia.indexmanagement.rollup.model.metric.Metric;
import io.lucenia.indexmanagement.rollup.model.metric.Min;
import io.lucenia.indexmanagement.rollup.model.metric.Sum;
import io.lucenia.indexmanagement.rollup.model.metric.ValueCount;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

public class RollupMetrics
implements ToXContentObject,
Writeable {
    public static final String SOURCE_FIELD_FIELD = "source_field";
    public static final String TARGET_FIELD_FIELD = "target_field";
    public static final String METRICS_FIELD = "metrics";
    private final String sourceField;
    private final String targetField;
    private final List<Metric> metrics;

    public RollupMetrics(String sourceField, String targetField, List<Metric> metrics) {
        if (sourceField == null || sourceField.isEmpty() || targetField == null || targetField.isEmpty()) {
            throw new IllegalArgumentException("Source and target field must not be empty");
        }
        if (metrics == null || metrics.isEmpty()) {
            throw new IllegalArgumentException("Must specify at least one metric to aggregate on for " + sourceField);
        }
        HashSet<Metric.Type> types = new HashSet<Metric.Type>();
        for (Metric metric : metrics) {
            if (types.add(metric.getType())) continue;
            throw new IllegalArgumentException("Cannot have multiple metrics of the same type in a single rollup metric [" + String.valueOf(metrics) + "]");
        }
        this.sourceField = sourceField;
        this.targetField = targetField;
        this.metrics = metrics;
    }

    public RollupMetrics(StreamInput sin) throws IOException {
        this.sourceField = sin.readString();
        this.targetField = sin.readString();
        ArrayList<Metric> metricsList = new ArrayList<Metric>();
        int size = sin.readVInt();
        block7: for (int i = 0; i < size; ++i) {
            Metric.Type type = (Metric.Type)sin.readEnum(Metric.Type.class);
            if (type == null) {
                throw new IllegalArgumentException("Metric type cannot be null");
            }
            switch (type) {
                case AVERAGE: {
                    metricsList.add(new Average(sin));
                    continue block7;
                }
                case MAX: {
                    metricsList.add(new Max(sin));
                    continue block7;
                }
                case MIN: {
                    metricsList.add(new Min(sin));
                    continue block7;
                }
                case SUM: {
                    metricsList.add(new Sum(sin));
                    continue block7;
                }
                case VALUE_COUNT: {
                    metricsList.add(new ValueCount(sin));
                }
            }
        }
        this.metrics = metricsList;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field(SOURCE_FIELD_FIELD, this.sourceField).field(METRICS_FIELD, (Object)this.metrics.toArray()).endObject();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.sourceField);
        out.writeString(this.targetField);
        out.writeVInt(this.metrics.size());
        for (Metric metric : this.metrics) {
            out.writeEnum((Enum)metric.getType());
            if (metric instanceof Average) {
                ((Average)metric).writeTo(out);
                continue;
            }
            if (metric instanceof Max) {
                ((Max)metric).writeTo(out);
                continue;
            }
            if (metric instanceof Min) {
                ((Min)metric).writeTo(out);
                continue;
            }
            if (metric instanceof Sum) {
                ((Sum)metric).writeTo(out);
                continue;
            }
            if (!(metric instanceof ValueCount)) continue;
            ((ValueCount)metric).writeTo(out);
        }
    }

    public String targetFieldWithType(Metric metric) {
        if (metric instanceof Average) {
            return this.targetField + ".avg";
        }
        if (metric instanceof Sum) {
            return this.targetField + ".sum";
        }
        if (metric instanceof Max) {
            return this.targetField + ".max";
        }
        if (metric instanceof Min) {
            return this.targetField + ".min";
        }
        if (metric instanceof ValueCount) {
            return this.targetField + ".value_count";
        }
        throw new IllegalArgumentException("Found unsupported metric aggregation " + metric.getType().getType());
    }

    public String getSourceField() {
        return this.sourceField;
    }

    public String getTargetField() {
        return this.targetField;
    }

    public List<Metric> getMetrics() {
        return this.metrics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RollupMetrics that = (RollupMetrics)o;
        return Objects.equals(this.sourceField, that.sourceField) && Objects.equals(this.targetField, that.targetField) && Objects.equals(this.metrics, that.metrics);
    }

    public int hashCode() {
        return Objects.hash(this.sourceField, this.targetField, this.metrics);
    }

    public String toString() {
        return "RollupMetrics{sourceField='" + this.sourceField + "', targetField='" + this.targetField + "', metrics=" + String.valueOf(this.metrics) + "}";
    }

    public static RollupMetrics parse(XContentParser xcp) throws IOException {
        String sourceField = null;
        String targetField = null;
        ArrayList<Metric> metrics = new ArrayList<Metric>();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block10: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "source_field": {
                    sourceField = xcp.text();
                    continue block10;
                }
                case "target_field": {
                    targetField = xcp.text();
                    continue block10;
                }
                case "metrics": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        metrics.add(Metric.parse(xcp));
                    }
                    continue block10;
                }
            }
            throw new IllegalArgumentException("Invalid dimension type [" + fieldName + "] found in rollup metrics");
        }
        if (targetField == null) {
            targetField = sourceField;
        }
        if (sourceField == null) {
            throw new IllegalArgumentException("Source field must not be null");
        }
        if (targetField == null) {
            throw new IllegalArgumentException("Target field must not be null");
        }
        return new RollupMetrics(sourceField, targetField, metrics);
    }
}

