/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.rollup.model;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.Objects;

public class RollupStats
implements ToXContentObject,
Writeable {
    private static final String PAGES_PROCESSED_FIELD = "pages_processed";
    private static final String DOCUMENTS_PROCESSED_FIELD = "documents_processed";
    private static final String ROLLUPS_INDEXED_FIELD = "rollups_indexed";
    private static final String INDEX_TIME_IN_MILLIS_FIELD = "index_time_in_millis";
    private static final String SEARCH_TIME_IN_MILLIS_FIELD = "search_time_in_millis";
    private final long pagesProcessed;
    private final long documentsProcessed;
    private final long rollupsIndexed;
    private final long indexTimeInMillis;
    private final long searchTimeInMillis;

    public RollupStats(long pagesProcessed, long documentsProcessed, long rollupsIndexed, long indexTimeInMillis, long searchTimeInMillis) {
        this.pagesProcessed = pagesProcessed;
        this.documentsProcessed = documentsProcessed;
        this.rollupsIndexed = rollupsIndexed;
        this.indexTimeInMillis = indexTimeInMillis;
        this.searchTimeInMillis = searchTimeInMillis;
    }

    public RollupStats(StreamInput sin) throws IOException {
        this.pagesProcessed = sin.readLong();
        this.documentsProcessed = sin.readLong();
        this.rollupsIndexed = sin.readLong();
        this.indexTimeInMillis = sin.readLong();
        this.searchTimeInMillis = sin.readLong();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field(PAGES_PROCESSED_FIELD, this.pagesProcessed).field(DOCUMENTS_PROCESSED_FIELD, this.documentsProcessed).field(ROLLUPS_INDEXED_FIELD, this.rollupsIndexed).field(INDEX_TIME_IN_MILLIS_FIELD, this.indexTimeInMillis).field(SEARCH_TIME_IN_MILLIS_FIELD, this.searchTimeInMillis).endObject();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.pagesProcessed);
        out.writeLong(this.documentsProcessed);
        out.writeLong(this.rollupsIndexed);
        out.writeLong(this.indexTimeInMillis);
        out.writeLong(this.searchTimeInMillis);
    }

    public long getPagesProcessed() {
        return this.pagesProcessed;
    }

    public long getDocumentsProcessed() {
        return this.documentsProcessed;
    }

    public long getRollupsIndexed() {
        return this.rollupsIndexed;
    }

    public long getIndexTimeInMillis() {
        return this.indexTimeInMillis;
    }

    public long getSearchTimeInMillis() {
        return this.searchTimeInMillis;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RollupStats that = (RollupStats)o;
        return this.pagesProcessed == that.pagesProcessed && this.documentsProcessed == that.documentsProcessed && this.rollupsIndexed == that.rollupsIndexed && this.indexTimeInMillis == that.indexTimeInMillis && this.searchTimeInMillis == that.searchTimeInMillis;
    }

    public int hashCode() {
        return Objects.hash(this.pagesProcessed, this.documentsProcessed, this.rollupsIndexed, this.indexTimeInMillis, this.searchTimeInMillis);
    }

    public String toString() {
        return "RollupStats{pagesProcessed=" + this.pagesProcessed + ", documentsProcessed=" + this.documentsProcessed + ", rollupsIndexed=" + this.rollupsIndexed + ", indexTimeInMillis=" + this.indexTimeInMillis + ", searchTimeInMillis=" + this.searchTimeInMillis + "}";
    }

    public static RollupStats parse(XContentParser xcp) throws IOException {
        Long pagesProcessed = null;
        Long documentsProcessed = null;
        Long rollupsIndexed = null;
        Long indexTimeInMillis = null;
        Long searchTimeInMillis = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "pages_processed": {
                    pagesProcessed = xcp.longValue();
                    break;
                }
                case "documents_processed": {
                    documentsProcessed = xcp.longValue();
                    break;
                }
                case "rollups_indexed": {
                    rollupsIndexed = xcp.longValue();
                    break;
                }
                case "index_time_in_millis": {
                    indexTimeInMillis = xcp.longValue();
                    break;
                }
                case "search_time_in_millis": {
                    searchTimeInMillis = xcp.longValue();
                }
            }
        }
        if (pagesProcessed == null) {
            throw new IllegalArgumentException("Pages processed must not be null");
        }
        if (documentsProcessed == null) {
            throw new IllegalArgumentException("Documents processed must not be null");
        }
        if (rollupsIndexed == null) {
            throw new IllegalArgumentException("Rollups indexed must not be null");
        }
        if (indexTimeInMillis == null) {
            throw new IllegalArgumentException("Index time in millis must not be null");
        }
        if (searchTimeInMillis == null) {
            throw new IllegalArgumentException("Search time in millis must not be null");
        }
        return new RollupStats(pagesProcessed, documentsProcessed, rollupsIndexed, indexTimeInMillis, searchTimeInMillis);
    }
}

