/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.rollup.model.metric;

import io.lucenia.indexmanagement.rollup.model.metric.Average;
import io.lucenia.indexmanagement.rollup.model.metric.Max;
import io.lucenia.indexmanagement.rollup.model.metric.Min;
import io.lucenia.indexmanagement.rollup.model.metric.Sum;
import io.lucenia.indexmanagement.rollup.model.metric.ValueCount;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;

public abstract class Metric
implements ToXContentObject,
Writeable {
    private final Type type;

    protected Metric(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public static Metric parse(XContentParser xcp) throws IOException {
        Metric metric = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block14: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "avg": {
                    metric = Average.parse(xcp);
                    continue block14;
                }
                case "max": {
                    metric = Max.parse(xcp);
                    continue block14;
                }
                case "min": {
                    metric = Min.parse(xcp);
                    continue block14;
                }
                case "sum": {
                    metric = Sum.parse(xcp);
                    continue block14;
                }
                case "value_count": {
                    metric = ValueCount.parse(xcp);
                    continue block14;
                }
            }
            throw new IllegalArgumentException("Invalid metric type [" + fieldName + "] found in metrics");
        }
        if (metric == null) {
            throw new IllegalArgumentException("Metric is null");
        }
        return metric;
    }

    public static enum Type {
        AVERAGE("avg"),
        SUM("sum"),
        MAX("max"),
        MIN("min"),
        VALUE_COUNT("value_count");

        private final String type;

        private Type(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public String toString() {
            return this.type;
        }
    }
}

