/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.rollup.query;

import io.skylite.core.common.regex.Regex;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.index.query.support.QueryStringQueryParser;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.Query;

public class QueryStringQueryParserExt
extends QueryStringQueryParser {
    public static final String EXISTS = "_exists_";
    private final List<String> discoveredFields = new ArrayList<String>();
    private boolean hasLonelyTerms = false;

    public QueryStringQueryParserExt(QueryShardContext context, boolean lenient) {
        super(context, lenient);
    }

    public QueryStringQueryParserExt(QueryShardContext context, String defaultField, boolean lenient) {
        super(context, defaultField, lenient);
    }

    public QueryStringQueryParserExt(QueryShardContext context, Map<String, Float> resolvedFields, boolean lenient) {
        super(context, resolvedFields, lenient);
    }

    public List<String> getDiscoveredFields() {
        return this.discoveredFields;
    }

    public boolean hasLonelyTerms() {
        return this.hasLonelyTerms;
    }

    protected Query getFuzzyQuery(String field, String termStr, float minSimilarity) throws ParseException {
        this.handleFieldQueryDiscovered(field, null);
        return super.getFuzzyQuery(field, termStr, minSimilarity);
    }

    protected Query getPrefixQuery(String field, String termStr) throws ParseException {
        this.handleFieldQueryDiscovered(field, null);
        return super.getPrefixQuery(field, termStr);
    }

    public Query getFieldQuery(String field, String queryText, boolean quoted) throws ParseException {
        this.handleFieldQueryDiscovered(field, queryText);
        return super.getFieldQuery(field, queryText, quoted);
    }

    protected Query getWildcardQuery(String field, String termStr) throws ParseException {
        this.handleFieldQueryDiscovered(field, null);
        return super.getWildcardQuery(field, termStr);
    }

    protected Query getFieldQuery(String field, String queryText, int slop) throws ParseException {
        this.handleFieldQueryDiscovered(field, queryText);
        return super.getFieldQuery(field, queryText, slop);
    }

    protected Query getRangeQuery(String field, String part1, String part2, boolean startInclusive, boolean endInclusive) throws ParseException {
        this.handleFieldQueryDiscovered(field, null);
        return super.getRangeQuery(field, part1, part2, startInclusive, endInclusive);
    }

    protected Query getRegexpQuery(String field, String termStr) throws ParseException {
        this.handleFieldQueryDiscovered(field, null);
        return super.getRegexpQuery(field, termStr);
    }

    private void handleFieldQueryDiscovered(String field, String queryText) {
        if (field == null || Regex.isSimpleMatchPattern((String)field)) {
            this.hasLonelyTerms = true;
        } else if (EXISTS.equals(field) && queryText != null && !queryText.isEmpty()) {
            this.discoveredFields.add(queryText);
        } else {
            this.discoveredFields.add(field);
        }
    }
}

