/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.rollup.query;

import io.lucenia.indexmanagement.common.model.dimension.Dimension;
import io.lucenia.indexmanagement.rollup.query.QueryStringQueryParserExt;
import io.lucenia.indexmanagement.rollup.util.QueryShardContextFactory;
import io.skylite.SkyliteParseException;
import io.skylite.core.analysis.NamedAnalyzer;
import io.skylite.core.common.regex.Regex;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.index.query.QueryShardException;
import io.skylite.core.index.query.QueryStringQueryBuilder;
import io.skylite.core.index.query.support.QueryParserHelper;
import io.skylite.core.index.query.support.QueryParsers;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;

public class QueryStringQueryUtil {
    public static QueryStringQueryBuilder rewriteQueryStringQuery(QueryBuilder queryBuilder, String concreteIndexName) throws IOException {
        QueryStringQueryBuilder qsqBuilder = (QueryStringQueryBuilder)queryBuilder;
        FieldsExtractionResult extractionResult = QueryStringQueryUtil.extractFieldsFromQueryString(queryBuilder, concreteIndexName);
        List<String> fieldsFromQueryString = extractionResult.discoveredFields;
        Map<String, Float> otherFields = extractionResult.otherFields;
        String newQueryString = qsqBuilder.queryString();
        for (String field : fieldsFromQueryString) {
            String escapedField = QueryStringQueryUtil.escapeSpaceCharacters(field);
            newQueryString = newQueryString.replace((String)escapedField + ":", (String)escapedField + "." + Dimension.Type.TERMS.getType() + ":");
            newQueryString = newQueryString.replace("_exists_:" + (String)escapedField, "_exists_:" + (String)escapedField + "." + Dimension.Type.TERMS.getType());
        }
        Object newDefaultField = qsqBuilder.defaultField();
        newDefaultField = newDefaultField != null && !Regex.isSimpleMatchPattern((String)newDefaultField) ? (String)newDefaultField + "." + Dimension.Type.TERMS.getType() : null;
        HashMap<CallSite, Float> newFields = null;
        if (!otherFields.isEmpty()) {
            newFields = new HashMap<CallSite, Float>();
            for (Map.Entry entry : otherFields.entrySet()) {
                newFields.put((CallSite)((Object)((String)entry.getKey() + "." + Dimension.Type.TERMS.getType())), (Float)entry.getValue());
            }
        }
        QueryStringQueryBuilder retVal = ((QueryStringQueryBuilder)((QueryStringQueryBuilder)new QueryStringQueryBuilder(newQueryString).rewrite(qsqBuilder.rewrite()).fuzzyRewrite(qsqBuilder.fuzzyRewrite()).autoGenerateSynonymsPhraseQuery(qsqBuilder.autoGenerateSynonymsPhraseQuery()).allowLeadingWildcard(qsqBuilder.allowLeadingWildcard()).analyzeWildcard(qsqBuilder.analyzeWildcard()).defaultOperator(qsqBuilder.defaultOperator()).escape(qsqBuilder.escape()).fuzziness(qsqBuilder.fuzziness()).lenient(qsqBuilder.lenient()).enablePositionIncrements(qsqBuilder.enablePositionIncrements()).fuzzyMaxExpansions(qsqBuilder.fuzzyMaxExpansions()).fuzzyPrefixLength(qsqBuilder.fuzzyPrefixLength()).queryName(qsqBuilder.queryName())).quoteAnalyzer(qsqBuilder.quoteAnalyzer()).analyzer(qsqBuilder.analyzer()).minimumShouldMatch(qsqBuilder.minimumShouldMatch()).timeZone(qsqBuilder.timeZone()).phraseSlop(qsqBuilder.phraseSlop()).quoteFieldSuffix(qsqBuilder.quoteFieldSuffix()).boost(qsqBuilder.boost())).fuzzyTranspositions(qsqBuilder.fuzzyTranspositions());
        if (newDefaultField != null) {
            retVal = retVal.defaultField((String)newDefaultField);
        } else if (newFields != null && !newFields.isEmpty()) {
            retVal = retVal.fields(newFields);
        }
        if (qsqBuilder.tieBreaker() != null) {
            retVal = retVal.tieBreaker(qsqBuilder.tieBreaker().floatValue());
        }
        return retVal;
    }

    private static String escapeSpaceCharacters(String field) {
        return field.replace(" ", "\\ ");
    }

    public static FieldsExtractionResult extractFieldsFromQueryString(QueryBuilder queryBuilder, String concreteIndexName) throws IOException {
        QueryStringQueryParserExt queryParser;
        QueryShardContext context = QueryShardContextFactory.createShardContext(concreteIndexName);
        QueryStringQueryBuilder qsqBuilder = (QueryStringQueryBuilder)queryBuilder;
        String rewrittenQueryString = qsqBuilder.escape() ? QueryParser.escape((String)qsqBuilder.queryString()) : qsqBuilder.queryString();
        boolean isLenient = qsqBuilder.lenient() != null ? qsqBuilder.lenient().booleanValue() : context.queryStringLenient();
        Map<Object, Object> otherFields = new HashMap();
        if (qsqBuilder.defaultField() != null) {
            if (Regex.isMatchAllPattern((String)qsqBuilder.defaultField())) {
                otherFields = QueryStringQueryUtil.resolveMatchPatternFields(context, "*");
                queryParser = new QueryStringQueryParserExt(context, qsqBuilder.lenient() != null ? qsqBuilder.lenient() : true);
            } else if (Regex.isSimpleMatchPattern((String)qsqBuilder.defaultField())) {
                otherFields = QueryStringQueryUtil.resolveMatchPatternFields(context, qsqBuilder.defaultField());
                queryParser = new QueryStringQueryParserExt(context, qsqBuilder.defaultField(), isLenient);
            } else {
                queryParser = new QueryStringQueryParserExt(context, qsqBuilder.defaultField(), isLenient);
            }
        } else if (!qsqBuilder.fields().isEmpty()) {
            Map resolvedFields = QueryParserHelper.resolveMappingFields((QueryShardContext)context, (Map)qsqBuilder.fields());
            otherFields = resolvedFields;
            queryParser = QueryParserHelper.hasAllFieldsWildcard(qsqBuilder.fields().keySet()) ? new QueryStringQueryParserExt(context, resolvedFields, qsqBuilder.lenient() != null ? qsqBuilder.lenient() : true) : new QueryStringQueryParserExt(context, resolvedFields, isLenient);
        } else {
            List defaultFields = context.defaultFields();
            if (QueryParserHelper.hasAllFieldsWildcard((Collection)defaultFields)) {
                otherFields = QueryStringQueryUtil.resolveMatchPatternFields(context, "*");
                queryParser = new QueryStringQueryParserExt(context, qsqBuilder.lenient() != null ? qsqBuilder.lenient() : true);
            } else {
                Map resolvedFields = QueryParserHelper.resolveMappingFields((QueryShardContext)context, (Map)QueryParserHelper.parseFieldsAndWeights((List)defaultFields));
                otherFields = resolvedFields;
                queryParser = new QueryStringQueryParserExt(context, resolvedFields, isLenient);
            }
        }
        if (qsqBuilder.analyzer() != null) {
            NamedAnalyzer namedAnalyzer = context.getIndexAnalyzers().get(qsqBuilder.analyzer());
            if (namedAnalyzer == null) {
                throw new QueryShardException(context.getFullyQualifiedIndex(), "[query_string] analyzer [" + qsqBuilder.analyzer() + "] not found", new Object[0]);
            }
            queryParser.setForceAnalyzer((Analyzer)namedAnalyzer);
        }
        if (qsqBuilder.quoteAnalyzer() != null) {
            NamedAnalyzer forceQuoteAnalyzer = context.getIndexAnalyzers().get(qsqBuilder.quoteAnalyzer());
            if (forceQuoteAnalyzer == null) {
                throw new QueryShardException(context.getFullyQualifiedIndex(), "[query_string] quote_analyzer [" + qsqBuilder.quoteAnalyzer() + "] not found", new Object[0]);
            }
            queryParser.setForceQuoteAnalyzer((Analyzer)forceQuoteAnalyzer);
        }
        queryParser.setDefaultOperator(qsqBuilder.defaultOperator().toQueryParserOperator());
        queryParser.setType(QueryStringQueryBuilder.DEFAULT_TYPE);
        if (qsqBuilder.tieBreaker() != null) {
            queryParser.setGroupTieBreaker(qsqBuilder.tieBreaker().floatValue());
        } else {
            queryParser.setGroupTieBreaker(QueryStringQueryBuilder.DEFAULT_TYPE.tieBreaker());
        }
        queryParser.setPhraseSlop(qsqBuilder.phraseSlop());
        queryParser.setQuoteFieldSuffix(qsqBuilder.quoteFieldSuffix());
        queryParser.setAllowLeadingWildcard(qsqBuilder.allowLeadingWildcard() != null ? qsqBuilder.allowLeadingWildcard().booleanValue() : context.queryStringAllowLeadingWildcard());
        queryParser.setAnalyzeWildcard(qsqBuilder.analyzeWildcard() != null ? qsqBuilder.analyzeWildcard().booleanValue() : context.queryStringAnalyzeWildcard());
        queryParser.setEnablePositionIncrements(qsqBuilder.enablePositionIncrements());
        queryParser.setFuzziness(qsqBuilder.fuzziness());
        queryParser.setFuzzyPrefixLength(qsqBuilder.fuzzyPrefixLength());
        queryParser.setFuzzyMaxExpansions(qsqBuilder.fuzzyMaxExpansions());
        queryParser.setFuzzyRewriteMethod(QueryParsers.parseRewriteMethod((String)qsqBuilder.fuzzyRewrite(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE));
        queryParser.setMultiTermRewriteMethod(QueryParsers.parseRewriteMethod((String)qsqBuilder.rewrite(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE));
        queryParser.setTimeZone(qsqBuilder.timeZone());
        queryParser.setDeterminizeWorkLimit(qsqBuilder.maxDeterminizedStates());
        queryParser.setAutoGenerateMultiTermSynonymsPhraseQuery(qsqBuilder.autoGenerateSynonymsPhraseQuery());
        queryParser.setFuzzyTranspositions(qsqBuilder.fuzzyTranspositions());
        try {
            queryParser.parse(rewrittenQueryString);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Failed to parse query [" + qsqBuilder.queryString() + "]", e);
        }
        return new FieldsExtractionResult(queryParser.getDiscoveredFields(), (Map<String, Float>)(queryParser.hasLonelyTerms() ? otherFields : new HashMap()));
    }

    public static Map<String, Float> resolveMatchPatternFields(QueryShardContext context, String pattern) {
        Set allFields = context.simpleMatchToIndexNames(pattern);
        HashMap<String, Float> fields = new HashMap<String, Float>();
        for (String fieldName : allFields) {
            String resolvedFieldName;
            MappedFieldType fieldType = context.getFieldType(fieldName);
            if (fieldType == null || fieldType.name().startsWith("_")) continue;
            try {
                fieldType.termQuery((Object)"", context);
            }
            catch (QueryShardException | UnsupportedOperationException e) {
                continue;
            }
            catch (SkyliteParseException | IllegalArgumentException e) {
                // empty catch block
            }
            if (!allFields.contains(resolvedFieldName = fieldType.name())) continue;
            fields.put(fieldName, Float.valueOf(1.0f));
        }
        return fields;
    }

    private QueryStringQueryUtil() {
    }

    public static class FieldsExtractionResult {
        public final List<String> discoveredFields;
        public final Map<String, Float> otherFields;

        public FieldsExtractionResult(List<String> discoveredFields, Map<String, Float> otherFields) {
            this.discoveredFields = discoveredFields;
            this.otherFields = otherFields;
        }
    }
}

