/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.rollup.resthandler;

import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.lucenia.indexmanagement.rollup.action.index.IndexRollupAction;
import io.lucenia.indexmanagement.rollup.action.index.IndexRollupRequest;
import io.lucenia.indexmanagement.rollup.action.index.IndexRollupResponse;
import io.lucenia.indexmanagement.rollup.model.Rollup;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionType;
import io.skylite.core.action.WriteRequest;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.rest.RestChannel;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.xcontent.ToXContent;
import java.io.IOException;
import java.time.Instant;
import java.util.List;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.action.RestResponseListener;

public class RestIndexRollupAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return List.of();
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return List.of(new RestHandler.ReplacedRoute(RestRequest.Method.PUT, "/_plugins/_rollup/jobs", RestRequest.Method.PUT, "/_opendistro/_rollup/jobs"), new RestHandler.ReplacedRoute(RestRequest.Method.PUT, "/_plugins/_rollup/jobs/{rollupID}", RestRequest.Method.PUT, "/_opendistro/_rollup/jobs/{rollupID}"));
    }

    public String getName() {
        return "opendistro_index_rollup_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String id = request.param("rollupID", "");
        if ("".equals(id)) {
            throw new IllegalArgumentException("Missing rollup ID");
        }
        long seqNo = request.paramAsLong("if_seq_no", -2L);
        long primaryTerm = request.paramAsLong("if_primary_term", 0L);
        Rollup rollup = new Rollup.Builder(LuceniaExtensions.parseWithType(request.contentParser(), id, seqNo, primaryTerm, Rollup::parse)).jobLastUpdatedTime(Instant.now()).build();
        WriteRequest.RefreshPolicy refreshPolicy = request.hasParam("refresh") ? WriteRequest.RefreshPolicy.parse((String)request.param("refresh")) : WriteRequest.RefreshPolicy.IMMEDIATE;
        IndexRollupRequest indexRollupRequest = new IndexRollupRequest(rollup, refreshPolicy);
        return channel -> client.execute((ActionType)IndexRollupAction.INSTANCE, (ActionRequest)indexRollupRequest, this.indexRollupResponse((RestChannel)channel));
    }

    private RestResponseListener<IndexRollupResponse> indexRollupResponse(RestChannel channel) {
        return new RestResponseListener<IndexRollupResponse>(this, channel){

            public RestResponse buildResponse(IndexRollupResponse response) throws Exception {
                BytesRestResponse restResponse = new BytesRestResponse(response.getStatus(), response.toXContent(this.channel.newBuilder(), ToXContent.EMPTY_PARAMS));
                if (response.getStatus() == RestStatus.CREATED) {
                    String location = "/_plugins/_rollup/jobs/" + response.getId();
                    restResponse.addHeader("Location", location);
                }
                return restResponse;
            }
        };
    }
}

