/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.rollup.util;

import io.lucenia.plugins.PluginsService;
import io.skylite.Version;
import io.skylite.core.analysis.AnalysisModule;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.io.stream.NamedWriteableRegistry;
import io.skylite.core.common.regex.Regex;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.env.Environment;
import io.skylite.core.index.Index;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.index.similarity.SimilarityService;
import io.skylite.core.mapper.MapperService;
import io.skylite.core.mapper.MergeReason;
import io.skylite.core.plugins.MapperPlugin;
import io.skylite.core.script.ScriptService;
import io.skylite.core.settings.IndexScopedSettings;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.SettingsModule;
import io.skylite.core.xcontent.NamedXContentRegistry;
import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import org.opensearch.indices.IndicesModule;

public class QueryShardContextFactory {
    private static Client client;
    private static ClusterService clusterService;
    private static ScriptService scriptService;
    private static NamedXContentRegistry xContentRegistry;
    private static NamedWriteableRegistry namedWriteableRegistry;
    private static Environment environment;

    private QueryShardContextFactory() {
    }

    public static void init(Client client, ClusterService clusterService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, NamedWriteableRegistry namedWriteableRegistry, Environment environment) {
        QueryShardContextFactory.client = client;
        QueryShardContextFactory.clusterService = clusterService;
        QueryShardContextFactory.scriptService = scriptService;
        QueryShardContextFactory.xContentRegistry = xContentRegistry;
        QueryShardContextFactory.namedWriteableRegistry = namedWriteableRegistry;
        QueryShardContextFactory.environment = environment;
    }

    private static IndexSettingsAndMetadata getIndexSettingsAndMetadata(String indexName) {
        IndexMetadata indexMetadata = clusterService.state().metadata().index(indexName);
        if (indexMetadata == null) {
            throw new IllegalArgumentException("Can't find IndexMetadata for index: [" + indexName + "]");
        }
        Index index = indexMetadata.getIndex();
        Settings indexSettings = indexMetadata.getSettings();
        return new IndexSettingsAndMetadata(index, indexSettings, indexMetadata);
    }

    public static QueryShardContext createShardContext(String indexName) throws IOException {
        IndexSettingsAndMetadata metadata = QueryShardContextFactory.getIndexSettingsAndMetadata(indexName);
        Index index = metadata.index;
        Settings indexSettings = metadata.settings;
        IndexMetadata indexMetadata = metadata.indexMetadata;
        Settings nodeSettings = Settings.builder().put("node.name", "dummyNodeName").put(Environment.PATH_HOME_SETTING.getKey(), environment.tmpDir()).build();
        PluginsService pluginsService = new PluginsService(nodeSettings, null, null, null, Collections.emptyList());
        List additionalSettings = pluginsService.getPluginSettings();
        SettingsModule settingsModule = new SettingsModule(nodeSettings, additionalSettings, pluginsService.getPluginSettingsFilter(), Collections.emptySet());
        IndexScopedSettings indexScopedSettings = settingsModule.getIndexScopedSettings();
        IndexSettings idxSettings = QueryShardContextFactory.newIndexSettings(index, indexSettings, indexScopedSettings);
        IndicesModule indicesModule = new IndicesModule(pluginsService.filterPlugins(MapperPlugin.class));
        AnalysisModule analysisModule = new AnalysisModule(environment, Collections.emptyList());
        SimilarityService similarityService = new SimilarityService(idxSettings, null, Collections.emptyMap());
        MapperService mapperService = new MapperService(idxSettings, analysisModule.getAnalysisRegistry().build(idxSettings), xContentRegistry, similarityService, indicesModule.getMapperRegistry(), () -> {
            try {
                return QueryShardContextFactory.createShardContext(null);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create shard context", e);
            }
        }, () -> false, scriptService);
        if (indexMetadata != null && indexMetadata.mapping() != null) {
            mapperService.merge("_doc", indexMetadata.mapping().source(), MergeReason.MAPPING_UPDATE);
        }
        return new QueryShardContext(0, idxSettings, BigArrays.NON_RECYCLING_INSTANCE, null, null, mapperService, null, similarityService, scriptService, xContentRegistry, namedWriteableRegistry, null, null, () -> Instant.now().toEpochMilli(), null, pattern -> Regex.simpleMatch((String)pattern, (String)index.getName()), () -> true, null);
    }

    private static IndexSettings newIndexSettings(Index index, Settings settings, IndexScopedSettings indexScopedSettings) {
        Settings build = Settings.builder().put("index.version.created", Version.CURRENT).put("index.number_of_replicas", 1).put("index.number_of_shards", 1).put(settings).build();
        IndexMetadata metadata = IndexMetadata.builder((String)index.getName()).settings(build).build();
        return new IndexSettings(metadata, Settings.EMPTY, indexScopedSettings);
    }

    private static class IndexSettingsAndMetadata {
        final Index index;
        final Settings settings;
        final IndexMetadata indexMetadata;

        IndexSettingsAndMetadata(Index index, Settings settings, IndexMetadata indexMetadata) {
            this.index = index;
            this.settings = settings;
            this.indexMetadata = indexMetadata;
        }
    }
}

