/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.rollup.util;

import io.lucenia.indexmanagement.indexstatemanagement.util.RestHandlerUtils;
import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.lucenia.indexmanagement.rollup.model.Rollup;
import io.skylite.common.xcontent.XContentFactory;
import io.skylite.core.cluster.metadata.IndexAbstraction;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.script.Script;
import io.skylite.core.script.ScriptService;
import io.skylite.core.script.ScriptType;
import io.skylite.core.script.TemplateScript;
import io.skylite.core.xcontent.ToXContent;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public class RollupFieldValueExpressionResolver {
    private static final Set<String> VALID_TOP_CONTEXT_FIELDS = Collections.singleton("source_index");
    private static ScriptService scriptService;
    private static ClusterService clusterService;
    private static IndexAliasUtils indexAliasUtils;

    private RollupFieldValueExpressionResolver() {
    }

    public static String resolve(Rollup rollup, String fieldValue) {
        Map<String, Object> contextMap;
        Script script = new Script(ScriptType.INLINE, "mustache", fieldValue, Collections.emptyMap());
        try {
            contextMap = LuceniaExtensions.toMap(rollup.toXContent(XContentFactory.jsonBuilder(), (ToXContent.Params)RestHandlerUtils.XCONTENT_WITHOUT_TYPE));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to convert rollup to map", e);
        }
        HashMap<String, Object> filteredContextMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : contextMap.entrySet()) {
            if (!VALID_TOP_CONTEXT_FIELDS.contains(entry.getKey())) continue;
            filteredContextMap.put(entry.getKey(), entry.getValue());
        }
        HashMap<String, HashMap<String, Object>> params = new HashMap<String, HashMap<String, Object>>(script.getParams());
        params.put("ctx", filteredContextMap);
        String compiledValue = ((TemplateScript.Factory)scriptService.compile(script, TemplateScript.CONTEXT)).newInstance(params).execute();
        if (indexAliasUtils.isAlias(compiledValue)) {
            compiledValue = indexAliasUtils.getWriteIndexNameForAlias(compiledValue);
        }
        return compiledValue == null || compiledValue.isEmpty() ? fieldValue : compiledValue;
    }

    public static void registerServices(ScriptService scriptService, ClusterService clusterService) {
        RollupFieldValueExpressionResolver.scriptService = scriptService;
        RollupFieldValueExpressionResolver.clusterService = clusterService;
        indexAliasUtils = new IndexAliasUtils(clusterService);
    }

    public static void registerServices(ScriptService scriptService, ClusterService clusterService, IndexAliasUtils indexAliasUtils) {
        RollupFieldValueExpressionResolver.scriptService = scriptService;
        RollupFieldValueExpressionResolver.clusterService = clusterService;
        RollupFieldValueExpressionResolver.indexAliasUtils = indexAliasUtils;
    }

    public static IndexAliasUtils getIndexAliasUtils() {
        return indexAliasUtils;
    }

    public static class IndexAliasUtils {
        private final ClusterService clusterService;

        public IndexAliasUtils(ClusterService clusterService) {
            this.clusterService = clusterService;
        }

        public boolean hasAlias(String index) {
            IndexMetadata indexMetadata = (IndexMetadata)this.clusterService.state().metadata().indices().get(index);
            if (indexMetadata != null) {
                return !indexMetadata.getAliases().isEmpty();
            }
            return false;
        }

        public boolean isAlias(String index) {
            SortedMap indicesLookup = this.clusterService.state().metadata().getIndicesLookup();
            if (indicesLookup != null) {
                IndexAbstraction indexAbstraction = (IndexAbstraction)indicesLookup.get(index);
                return indexAbstraction instanceof IndexAbstraction.Alias;
            }
            return false;
        }

        public String getWriteIndexNameForAlias(String alias) {
            IndexAbstraction indexAbstraction;
            SortedMap indicesLookup = this.clusterService.state().metadata().getIndicesLookup();
            if (indicesLookup != null && (indexAbstraction = (IndexAbstraction)indicesLookup.get(alias)) != null && indexAbstraction.getWriteIndex() != null) {
                return indexAbstraction.getWriteIndex().getIndex().getName();
            }
            return null;
        }

        public List<IndexMetadata> getBackingIndicesForAlias(String alias) {
            IndexAbstraction indexAbstraction;
            SortedMap indicesLookup = this.clusterService.state().metadata().getIndicesLookup();
            if (indicesLookup != null && (indexAbstraction = (IndexAbstraction)indicesLookup.get(alias)) != null) {
                return indexAbstraction.getIndices();
            }
            return null;
        }
    }
}

