/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.rollup.util;

import io.lucenia.indexmanagement.common.model.dimension.DateHistogram;
import io.lucenia.indexmanagement.common.model.dimension.Dimension;
import io.lucenia.indexmanagement.common.model.dimension.Histogram;
import io.lucenia.indexmanagement.common.model.dimension.Terms;
import io.lucenia.indexmanagement.luceniaapi.ParseUtils;
import io.lucenia.indexmanagement.rollup.model.Rollup;
import io.lucenia.indexmanagement.rollup.model.RollupFieldMapping;
import io.lucenia.indexmanagement.rollup.model.RollupMetadata;
import io.lucenia.indexmanagement.rollup.model.RollupMetrics;
import io.lucenia.indexmanagement.rollup.model.metric.Average;
import io.lucenia.indexmanagement.rollup.model.metric.Max;
import io.lucenia.indexmanagement.rollup.model.metric.Metric;
import io.lucenia.indexmanagement.rollup.model.metric.Min;
import io.lucenia.indexmanagement.rollup.model.metric.Sum;
import io.lucenia.indexmanagement.rollup.model.metric.ValueCount;
import io.lucenia.indexmanagement.rollup.query.QueryStringQueryUtil;
import io.lucenia.indexmanagement.rollup.settings.LegacyOpenDistroRollupSettings;
import io.lucenia.indexmanagement.rollup.settings.RollupSettings;
import io.lucenia.indexmanagement.rollup.util.RollupFieldValueExpressionResolver;
import io.skylite.core.action.get.GetResponse;
import io.skylite.core.aggregations.AggregationBuilder;
import io.skylite.core.aggregations.AggregatorFactories;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.MappingMetadata;
import io.skylite.core.cluster.state.ClusterState;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.compress.CompressedXContent;
import io.skylite.core.index.query.BoolQueryBuilder;
import io.skylite.core.index.query.DisMaxQueryBuilder;
import io.skylite.core.index.query.MatchAllQueryBuilder;
import io.skylite.core.index.query.MatchPhraseQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.QueryStringQueryBuilder;
import io.skylite.core.index.query.RangeQueryBuilder;
import io.skylite.core.index.query.TermQueryBuilder;
import io.skylite.core.script.Script;
import io.skylite.core.script.ScriptType;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.search.fetch.subphase.FieldAndFormat;
import io.skylite.core.search.rescore.RescorerBuilder;
import io.skylite.core.search.sort.BaseSortBuilder;
import io.skylite.core.search.sort.SortBuilder;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentHelper;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.opensearch.index.query.BoostingQueryBuilder;
import org.opensearch.index.query.ConstantScoreQueryBuilder;
import org.opensearch.index.query.TermsQueryBuilder;
import org.opensearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.opensearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.opensearch.search.aggregations.bucket.histogram.HistogramAggregationBuilder;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.opensearch.search.aggregations.metrics.AvgAggregationBuilder;
import org.opensearch.search.aggregations.metrics.MaxAggregationBuilder;
import org.opensearch.search.aggregations.metrics.MinAggregationBuilder;
import org.opensearch.search.aggregations.metrics.ScriptedMetricAggregationBuilder;
import org.opensearch.search.aggregations.metrics.SumAggregationBuilder;
import org.opensearch.search.aggregations.metrics.ValueCountAggregationBuilder;
import org.opensearch.search.aggregations.support.ValuesSourceAggregationBuilder;

public final class RollupUtils {
    public static final String DATE_FIELD_STRICT_DATE_OPTIONAL_TIME_FORMAT = "strict_date_optional_time";
    public static final String DATE_FIELD_EPOCH_MILLIS_FORMAT = "epoch_millis";

    private RollupUtils() {
    }

    public static boolean isRollupIndex(String index, ClusterState clusterState) {
        IndexMetadata idx = clusterState.metadata().index(index);
        if (idx == null) {
            return false;
        }
        if (((Boolean)RollupSettings.ROLLUP_INDEX.get(idx.getSettings())).booleanValue()) {
            return true;
        }
        return (Boolean)LegacyOpenDistroRollupSettings.ROLLUP_INDEX.get(idx.getSettings()) != false;
    }

    public static boolean isTargetIndexAlias(Rollup rollup) {
        return RollupFieldValueExpressionResolver.getIndexAliasUtils().isAlias(rollup.getTargetIndex());
    }

    public static SearchRequest getRollupSearchRequest(Rollup rollup, RollupMetadata metadata) {
        Object query = metadata.getContinuous() != null ? new RangeQueryBuilder(RollupUtils.getDateHistogram(rollup).getSourceField()).from((Object)metadata.getContinuous().getNextWindowStartTime().toEpochMilli(), true).to((Object)metadata.getContinuous().getNextWindowEndTime().toEpochMilli(), false).format(DATE_FIELD_EPOCH_MILLIS_FORMAT) : new MatchAllQueryBuilder();
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().trackTotalHits(false).size(0).aggregation((AggregationBuilder)RollupUtils.getCompositeAggregationBuilder(rollup, metadata.getAfterKey())).query((QueryBuilder)query);
        return new SearchRequest(new String[]{rollup.getSourceIndex()}).source(searchSourceBuilder).allowPartialSearchResults(false);
    }

    public static CompositeAggregationBuilder getCompositeAggregationBuilder(Rollup rollup, Map<String, Object> afterKey) {
        List sources = rollup.getDimensions().stream().map(dimension -> dimension.toSourceBuilder(true)).collect(Collectors.toList());
        CompositeAggregationBuilder compositeAgg = new CompositeAggregationBuilder(rollup.getId(), sources).size(rollup.getPageSize());
        if (afterKey != null) {
            compositeAgg.aggregateAfter(afterKey);
        }
        rollup.getMetrics().forEach(metric -> {
            List<AggregationBuilder> subAggs = metric.getMetrics().stream().flatMap(agg -> {
                ArrayList<ValuesSourceAggregationBuilder> builders = new ArrayList<ValuesSourceAggregationBuilder>();
                if (agg instanceof Average) {
                    builders.add(new SumAggregationBuilder(metric.targetFieldWithType((Metric)agg) + ".sum").field(metric.getSourceField()));
                    builders.add(new ValueCountAggregationBuilder(metric.targetFieldWithType((Metric)agg) + ".value_count").field(metric.getSourceField()));
                } else if (agg instanceof Sum) {
                    builders.add(new SumAggregationBuilder(metric.targetFieldWithType((Metric)agg)).field(metric.getSourceField()));
                } else if (agg instanceof Max) {
                    builders.add(new MaxAggregationBuilder(metric.targetFieldWithType((Metric)agg)).field(metric.getSourceField()));
                } else if (agg instanceof Min) {
                    builders.add(new MinAggregationBuilder(metric.targetFieldWithType((Metric)agg)).field(metric.getSourceField()));
                } else if (agg instanceof ValueCount) {
                    builders.add(new ValueCountAggregationBuilder(metric.targetFieldWithType((Metric)agg)).field(metric.getSourceField()));
                } else {
                    throw new IllegalArgumentException("Found unsupported metric aggregation " + agg.getType().getType());
                }
                return builders.stream();
            }).collect(Collectors.toList());
            subAggs.forEach(arg_0 -> ((CompositeAggregationBuilder)compositeAgg).subAggregation(arg_0));
        });
        return compositeAgg;
    }

    public static DateHistogram getDateHistogram(Rollup rollup) {
        Dimension dimension = rollup.getDimensions().get(0);
        if (!(dimension instanceof DateHistogram)) {
            throw new IllegalArgumentException("The first dimension in rollup must be a date histogram");
        }
        return (DateHistogram)dimension;
    }

    public static Dimension findMatchingDimension(Rollup rollup, String field, Dimension.Type type) {
        return rollup.getDimensions().stream().filter(dimension -> dimension.getSourceField().equals(field) && dimension.getType() == type).findFirst().orElse(null);
    }

    public static <T> String findMatchingMetricField(Rollup rollup, String field, Class<T> metricClass) {
        for (RollupMetrics rollupMetrics : rollup.getMetrics()) {
            if (!rollupMetrics.getSourceField().equals(field)) continue;
            for (Metric metric : rollupMetrics.getMetrics()) {
                if (!metricClass.isInstance(metric)) continue;
                return rollupMetrics.targetFieldWithType(metric);
            }
        }
        throw new IllegalStateException("Did not find matching rollup metric");
    }

    public static List<Rollup> getRollupJobs(IndexMetadata indexMetadata) throws IOException {
        ArrayList<Rollup> rollupJobs = new ArrayList<Rollup>();
        MappingMetadata source = indexMetadata.mapping();
        if (source == null) {
            return null;
        }
        CompressedXContent sourceRef = source.source();
        XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)sourceRef.compressedReference(), (MediaType)MediaTypeRegistry.JSON);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            if ("_meta".equals(fieldName)) {
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                    String metaField = xcp.currentName();
                    xcp.nextToken();
                    if ("rollups".equals(metaField)) {
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                            String rollupID = xcp.currentName();
                            xcp.nextToken();
                            rollupJobs.add(Rollup.parse(xcp, rollupID, -2L, 0L));
                        }
                        continue;
                    }
                    xcp.skipChildren();
                }
                continue;
            }
            xcp.skipChildren();
        }
        return rollupJobs.size() > 0 ? rollupJobs : null;
    }

    public static AggregationBuilder rewriteAggregationBuilder(Rollup rollup, AggregationBuilder aggregationBuilder) {
        AggregatorFactories.Builder aggFactory = AggregatorFactories.builder();
        aggregationBuilder.getSubAggregations().forEach(subAgg -> aggFactory.addAggregator(RollupUtils.rewriteAggregationBuilder(rollup, subAgg)));
        if (aggregationBuilder instanceof TermsAggregationBuilder) {
            TermsAggregationBuilder terms = (TermsAggregationBuilder)aggregationBuilder;
            Terms dim = (Terms)RollupUtils.findMatchingDimension(rollup, terms.field(), Dimension.Type.TERMS);
            return dim.getRewrittenAggregation(terms, aggFactory);
        }
        if (aggregationBuilder instanceof DateHistogramAggregationBuilder) {
            DateHistogramAggregationBuilder dateHisto = (DateHistogramAggregationBuilder)aggregationBuilder;
            DateHistogram dim = (DateHistogram)RollupUtils.findMatchingDimension(rollup, dateHisto.field(), Dimension.Type.DATE_HISTOGRAM);
            return dim.getRewrittenAggregation(dateHisto, aggFactory);
        }
        if (aggregationBuilder instanceof HistogramAggregationBuilder) {
            HistogramAggregationBuilder histo = (HistogramAggregationBuilder)aggregationBuilder;
            Histogram dim = (Histogram)RollupUtils.findMatchingDimension(rollup, histo.field(), Dimension.Type.HISTOGRAM);
            return dim.getRewrittenAggregation(histo, aggFactory);
        }
        if (aggregationBuilder instanceof SumAggregationBuilder) {
            SumAggregationBuilder sum = (SumAggregationBuilder)aggregationBuilder;
            return new SumAggregationBuilder(sum.getName()).field(RollupUtils.findMatchingMetricField(rollup, sum.field(), Sum.class));
        }
        if (aggregationBuilder instanceof AvgAggregationBuilder) {
            AvgAggregationBuilder avg = (AvgAggregationBuilder)aggregationBuilder;
            String avgField = RollupUtils.findMatchingMetricField(rollup, avg.field(), Average.class);
            return new ScriptedMetricAggregationBuilder(avg.getName()).initScript(new Script(ScriptType.INLINE, "painless", "state.sums = 0D; state.counts = 0L;", Collections.emptyMap())).mapScript(new Script(ScriptType.INLINE, "painless", "state.sums += doc[\"" + avgField + ".sum\"].value; state.counts += doc[\"" + avgField + ".value_count\"].value", Collections.emptyMap())).combineScript(new Script(ScriptType.INLINE, "painless", "def d = new org.opensearch.search.aggregations.metrics.ScriptedAvg(state.sums, state.counts); return d", Collections.emptyMap())).reduceScript(new Script(ScriptType.INLINE, "painless", "double sum = 0; double count = 0; for (a in states) { sum += a.getSum(); count += a.getCount(); } return sum/count", Collections.emptyMap()));
        }
        if (aggregationBuilder instanceof MaxAggregationBuilder) {
            MaxAggregationBuilder max = (MaxAggregationBuilder)aggregationBuilder;
            return new MaxAggregationBuilder(max.getName()).field(RollupUtils.findMatchingMetricField(rollup, max.field(), Max.class));
        }
        if (aggregationBuilder instanceof MinAggregationBuilder) {
            MinAggregationBuilder min = (MinAggregationBuilder)aggregationBuilder;
            return new MinAggregationBuilder(min.getName()).field(RollupUtils.findMatchingMetricField(rollup, min.field(), Min.class));
        }
        if (aggregationBuilder instanceof ValueCountAggregationBuilder) {
            ValueCountAggregationBuilder valueCount = (ValueCountAggregationBuilder)aggregationBuilder;
            String vcField = RollupUtils.findMatchingMetricField(rollup, valueCount.field(), ValueCount.class);
            return new ScriptedMetricAggregationBuilder(valueCount.getName()).initScript(new Script(ScriptType.INLINE, "painless", "state.valueCounts = []", Collections.emptyMap())).mapScript(new Script(ScriptType.INLINE, "painless", "state.valueCounts.add(doc[\"" + vcField + "\"].value)", Collections.emptyMap())).combineScript(new Script(ScriptType.INLINE, "painless", "long valueCount = 0; for (vc in state.valueCounts) { valueCount += vc } return valueCount", Collections.emptyMap())).reduceScript(new Script(ScriptType.INLINE, "painless", "long valueCount = 0; for (vc in states) { valueCount += vc } return valueCount", Collections.emptyMap()));
        }
        return aggregationBuilder;
    }

    public static QueryBuilder rewriteQueryBuilder(Rollup rollup, QueryBuilder queryBuilder, Map<String, String> fieldNameMappingTypeMap, String concreteIndexName) throws IOException {
        if (queryBuilder instanceof TermQueryBuilder) {
            TermQueryBuilder term = (TermQueryBuilder)queryBuilder;
            String updatedFieldName = term.fieldName() + "." + Dimension.Type.TERMS.getType();
            TermQueryBuilder updated = new TermQueryBuilder(updatedFieldName, term.value());
            updated.boost(term.boost());
            updated.queryName(term.queryName());
            return updated;
        }
        if (queryBuilder instanceof TermsQueryBuilder) {
            TermsQueryBuilder terms = (TermsQueryBuilder)queryBuilder;
            String updatedFieldName = terms.fieldName() + "." + Dimension.Type.TERMS.getType();
            TermsQueryBuilder updated = new TermsQueryBuilder(updatedFieldName, (Iterable)terms.values());
            updated.boost(terms.boost());
            updated.queryName(terms.queryName());
            return updated;
        }
        if (queryBuilder instanceof RangeQueryBuilder) {
            RangeQueryBuilder range = (RangeQueryBuilder)queryBuilder;
            String updatedFieldName = range.fieldName() + "." + fieldNameMappingTypeMap.get(range.fieldName());
            RangeQueryBuilder updated = new RangeQueryBuilder(updatedFieldName);
            updated.includeLower(range.includeLower());
            updated.includeUpper(range.includeUpper());
            updated.from(range.from());
            updated.to(range.to());
            if (range.timeZone() != null) {
                updated.timeZone(range.timeZone());
            }
            if (range.format() != null) {
                updated.format(range.format());
            }
            if (range.relation() != null && range.relation().getRelationName() != null) {
                updated.relation(range.relation().getRelationName());
            }
            updated.queryName(range.queryName());
            updated.boost(range.boost());
            return updated;
        }
        if (queryBuilder instanceof BoolQueryBuilder) {
            BoolQueryBuilder bool = (BoolQueryBuilder)queryBuilder;
            BoolQueryBuilder newBool = new BoolQueryBuilder();
            if (bool.must() != null) {
                for (QueryBuilder q : bool.must()) {
                    newBool.must(RollupUtils.rewriteQueryBuilder(rollup, q, fieldNameMappingTypeMap, concreteIndexName));
                }
            }
            if (bool.mustNot() != null) {
                for (QueryBuilder q : bool.mustNot()) {
                    newBool.mustNot(RollupUtils.rewriteQueryBuilder(rollup, q, fieldNameMappingTypeMap, concreteIndexName));
                }
            }
            if (bool.should() != null) {
                for (QueryBuilder q : bool.should()) {
                    newBool.should(RollupUtils.rewriteQueryBuilder(rollup, q, fieldNameMappingTypeMap, concreteIndexName));
                }
            }
            if (bool.filter() != null) {
                for (QueryBuilder q : bool.filter()) {
                    newBool.filter(RollupUtils.rewriteQueryBuilder(rollup, q, fieldNameMappingTypeMap, concreteIndexName));
                }
            }
            newBool.minimumShouldMatch(bool.minimumShouldMatch());
            newBool.adjustPureNegative(bool.adjustPureNegative());
            newBool.queryName(bool.queryName());
            newBool.boost(bool.boost());
            return newBool;
        }
        if (queryBuilder instanceof BoostingQueryBuilder) {
            BoostingQueryBuilder boosting = (BoostingQueryBuilder)queryBuilder;
            QueryBuilder newPositive = RollupUtils.rewriteQueryBuilder(rollup, boosting.positiveQuery(), fieldNameMappingTypeMap, concreteIndexName);
            QueryBuilder newNegative = RollupUtils.rewriteQueryBuilder(rollup, boosting.negativeQuery(), fieldNameMappingTypeMap, concreteIndexName);
            BoostingQueryBuilder newBoosting = new BoostingQueryBuilder(newPositive, newNegative);
            if (boosting.negativeBoost() >= 0.0f) {
                newBoosting.negativeBoost(boosting.negativeBoost());
            }
            newBoosting.queryName(boosting.queryName());
            newBoosting.boost(boosting.boost());
            return newBoosting;
        }
        if (queryBuilder instanceof ConstantScoreQueryBuilder) {
            ConstantScoreQueryBuilder constantScore = (ConstantScoreQueryBuilder)queryBuilder;
            QueryBuilder newInner = RollupUtils.rewriteQueryBuilder(rollup, constantScore.innerQuery(), fieldNameMappingTypeMap, concreteIndexName);
            ConstantScoreQueryBuilder newConstantScore = new ConstantScoreQueryBuilder(newInner);
            newConstantScore.boost(constantScore.boost());
            newConstantScore.queryName(constantScore.queryName());
            return newConstantScore;
        }
        if (queryBuilder instanceof DisMaxQueryBuilder) {
            DisMaxQueryBuilder disMax = (DisMaxQueryBuilder)queryBuilder;
            DisMaxQueryBuilder newDisMax = new DisMaxQueryBuilder();
            for (QueryBuilder q : disMax.innerQueries()) {
                newDisMax.add(RollupUtils.rewriteQueryBuilder(rollup, q, fieldNameMappingTypeMap, concreteIndexName));
            }
            newDisMax.tieBreaker(disMax.tieBreaker());
            newDisMax.queryName(disMax.queryName());
            newDisMax.boost(disMax.boost());
            return newDisMax;
        }
        if (queryBuilder instanceof MatchPhraseQueryBuilder) {
            MatchPhraseQueryBuilder matchPhrase = (MatchPhraseQueryBuilder)queryBuilder;
            String newFieldName = matchPhrase.fieldName() + "." + Dimension.Type.TERMS.getType();
            MatchPhraseQueryBuilder newMatchPhrase = new MatchPhraseQueryBuilder(newFieldName, matchPhrase.value());
            newMatchPhrase.queryName(matchPhrase.queryName());
            newMatchPhrase.boost(matchPhrase.boost());
            return newMatchPhrase;
        }
        if (queryBuilder instanceof QueryStringQueryBuilder) {
            return QueryStringQueryUtil.rewriteQueryStringQuery(queryBuilder, concreteIndexName);
        }
        return queryBuilder;
    }

    public static QueryBuilder buildRollupQuery(Set<Rollup> rollups, Map<String, String> fieldNameMappingTypeMap, QueryBuilder oldQuery, String targetIndexName) throws IOException {
        BoolQueryBuilder wrappedQueryBuilder = new BoolQueryBuilder();
        wrappedQueryBuilder.must(rollups.iterator().next().rewriteQueryBuilder(oldQuery, fieldNameMappingTypeMap, targetIndexName));
        wrappedQueryBuilder.should((QueryBuilder)new TermsQueryBuilder("rollup._id", (Iterable)rollups.stream().map(Rollup::getId).collect(Collectors.toList())));
        wrappedQueryBuilder.minimumShouldMatch(1);
        return wrappedQueryBuilder;
    }

    public static Set<RollupFieldMapping> populateFieldMappings(Rollup rollup) {
        HashSet<RollupFieldMapping> fieldMappings = new HashSet<RollupFieldMapping>();
        rollup.getDimensions().forEach(dimension -> fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.FieldType.DIMENSION, dimension.getSourceField(), dimension.getType().getType())));
        rollup.getMetrics().forEach(rollupMetric -> rollupMetric.getMetrics().forEach(metric -> fieldMappings.add(new RollupFieldMapping(RollupFieldMapping.FieldType.METRIC, rollupMetric.getSourceField(), metric.getType().getType()))));
        return fieldMappings;
    }

    public static Map<String, Object> getInitialDocValues(Rollup rollup, long docCount) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("rollup._id", rollup.getId());
        values.put("_doc_count", docCount);
        values.put("rollup._schema_version", rollup.getSchemaVersion());
        return values;
    }

    public static Rollup parseRollup(GetResponse response) throws IOException {
        return RollupUtils.parseRollup(response, NamedXContentRegistry.EMPTY);
    }

    public static Rollup parseRollup(GetResponse response, NamedXContentRegistry xContentRegistry) throws IOException {
        XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)response.getSourceAsBytesRef(), (MediaType)MediaTypeRegistry.JSON);
        return ParseUtils.parseWithType(xcp, response.getId(), response.getSeqNo(), response.getPrimaryTerm(), Rollup::parse);
    }

    public static SearchSourceBuilder rewriteSearchSourceBuilder(SearchSourceBuilder source, Set<Rollup> jobs, Map<String, String> fieldNameMappingTypeMap, String concreteIndexName) throws IOException {
        SearchSourceBuilder ssb = new SearchSourceBuilder();
        if (source.aggregations() != null && source.aggregations().getAggregatorFactories() != null) {
            Rollup firstJob = jobs.iterator().next();
            for (AggregationBuilder agg : source.aggregations().getAggregatorFactories()) {
                ssb.aggregation(RollupUtils.rewriteAggregationBuilder(firstJob, agg));
            }
        }
        if (source.explain() != null) {
            ssb.explain(source.explain());
        }
        if (source.ext() != null) {
            ssb.ext(source.ext());
        }
        ssb.fetchSource(source.fetchSource());
        if (source.docValueFields() != null) {
            for (FieldAndFormat field : source.docValueFields()) {
                ssb.docValueField(field.field, field.format);
            }
        }
        ssb.storedFields(source.storedFields());
        if (source.from() >= 0) {
            ssb.from(source.from());
        }
        ssb.highlighter(source.highlighter());
        if (source.indexBoosts() != null) {
            for (SearchSourceBuilder.IndexBoost boost : source.indexBoosts()) {
                ssb.indexBoost(boost.getIndex(), boost.getBoost());
            }
        }
        if (source.minScore() != null) {
            ssb.minScore(source.minScore().floatValue());
        }
        if (source.postFilter() != null) {
            ssb.postFilter(source.postFilter());
        }
        ssb.profile(source.profile());
        if (source.query() != null) {
            ssb.query(RollupUtils.buildRollupQuery(jobs, fieldNameMappingTypeMap, source.query(), concreteIndexName));
        }
        if (source.rescores() != null) {
            for (RescorerBuilder rescore : source.rescores()) {
                ssb.addRescorer(rescore);
            }
        }
        if (source.scriptFields() != null) {
            for (SearchSourceBuilder.ScriptField scriptField : source.scriptFields()) {
                ssb.scriptField(scriptField.fieldName(), scriptField.script(), scriptField.ignoreFailure());
            }
        }
        if (source.searchAfter() != null) {
            ssb.searchAfter(source.searchAfter());
        }
        if (source.slice() != null) {
            ssb.slice(source.slice());
        }
        if (source.size() >= 0) {
            ssb.size(source.size());
        }
        if (source.sorts() != null) {
            for (SortBuilder sort : source.sorts()) {
                ssb.sort((BaseSortBuilder)sort);
            }
        }
        if (source.stats() != null) {
            ssb.stats(source.stats());
        }
        if (source.suggest() != null) {
            ssb.suggest(source.suggest());
        }
        if (source.terminateAfter() >= 0) {
            ssb.terminateAfter(source.terminateAfter());
        }
        if (source.timeout() != null) {
            ssb.timeout(source.timeout());
        }
        ssb.trackScores(source.trackScores());
        if (source.trackTotalHitsUpTo() != null) {
            ssb.trackTotalHitsUpTo(source.trackTotalHitsUpTo().intValue());
        }
        if (source.version() != null) {
            ssb.version(source.version());
        }
        if (source.seqNoAndPrimaryTerm() != null) {
            ssb.seqNoAndPrimaryTerm(source.seqNoAndPrimaryTerm());
        }
        if (source.collapse() != null) {
            ssb.collapse(source.collapse());
        }
        return ssb;
    }

    public static SearchSourceBuilder rewriteSearchSourceBuilder(SearchSourceBuilder source, Rollup job, Map<String, String> fieldNameMappingTypeMap, String concreteIndexName) throws IOException {
        return RollupUtils.rewriteSearchSourceBuilder(source, Collections.singleton(job), fieldNameMappingTypeMap, concreteIndexName);
    }
}

