/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.snapshotmanagement;

import io.lucenia.indexmanagement.IndexManagementIndices;
import io.lucenia.indexmanagement.snapshotmanagement.SMUtils;
import io.lucenia.indexmanagement.snapshotmanagement.engine.SMStateMachine;
import io.lucenia.indexmanagement.snapshotmanagement.engine.states.CreationTransitions;
import io.lucenia.indexmanagement.snapshotmanagement.engine.states.DeletionTransitions;
import io.lucenia.indexmanagement.snapshotmanagement.engine.states.SMState;
import io.lucenia.indexmanagement.snapshotmanagement.model.SMMetadata;
import io.lucenia.indexmanagement.snapshotmanagement.model.SMPolicy;
import io.lucenia.indexmanagement.util.LockUtils;
import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.bulk.BackoffPolicy;
import io.skylite.core.action.index.IndexResponse;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.health.ClusterHealthStatus;
import io.skylite.core.cluster.health.ClusterStateHealth;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.SkyliteExecutors;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.jobs.JobExecutionContext;
import io.skylite.core.jobs.LockModel;
import io.skylite.core.jobs.ScheduledJobParameter;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.jobs.ScheduledJobRunner;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SMRunner
implements ScheduledJobRunner {
    private static final Logger log = LogManager.getLogger(SMRunner.class);
    public static final SMRunner INSTANCE = new SMRunner();
    private static final int MAX_NUMBER_OF_RETRIES = 3;
    private static final long EXPONENTIAL_BACKOFF_MILLIS = 1000L;
    private final BackoffPolicy backoffPolicy = BackoffPolicy.exponentialBackoff((TimeValue)TimeValue.timeValueMillis((long)1000L), (int)3);
    private ExecutorService executorService;
    private Client client;
    private IndexManagementIndices indicesManager;
    private ClusterService clusterService;
    private ThreadPool threadPool;
    private Settings settings;

    private SMRunner() {
    }

    public SMRunner init(Client client, ThreadPool threadPool, Settings settings, IndexManagementIndices indicesManager, ClusterService clusterService) {
        this.client = client;
        this.threadPool = threadPool;
        this.settings = settings;
        this.indicesManager = indicesManager;
        this.clusterService = clusterService;
        if (this.executorService == null) {
            this.executorService = SkyliteExecutors.newScaling((String)"sm-runner", (int)0, (int)Runtime.getRuntime().availableProcessors(), (long)5L, (TimeUnit)TimeUnit.MINUTES, (ThreadFactory)SkyliteExecutors.daemonThreadFactory((String)"sm-runner"), (ThreadContext)threadPool.getThreadContext());
        }
        return this;
    }

    public void runJob(ScheduledJobParameter job, final JobExecutionContext context) {
        log.debug("Snapshot management running job: {}", (Object)job);
        if (!(job instanceof SMPolicy)) {
            throw new IllegalArgumentException("Received invalid job type [" + job.getClass().getSimpleName() + "] with id [" + context.getJobId() + "].");
        }
        final SMPolicy policy = (SMPolicy)job;
        CompletableFuture.runAsync(() -> {
            final LockModel lock = LockUtils.acquireLockForScheduledJob(policy, context, this.backoffPolicy);
            if (lock == null) {
                log.warn("Cannot acquire lock for snapshot management job " + policy.getPolicyName());
                return;
            }
            if (new ClusterStateHealth(this.clusterService.state()).getStatus() == ClusterHealthStatus.RED) {
                log.warn("Skipping current execution of " + policy.getPolicyName() + " because of red cluster health");
                this.releaseLock(context, lock, policy);
                return;
            }
            SMMetadata metadata = null;
            try {
                metadata = SMUtils.getSMMetadata(this.client, policy.getId());
            }
            catch (Exception e) {
                log.error("Failed to retrieve metadata before running " + policy.getPolicyName(), (Throwable)e);
                this.releaseLock(context, lock, policy);
                return;
            }
            if (metadata == null && (metadata = this.initMetadata(policy)) == null) {
                this.releaseLock(context, lock, policy);
                return;
            }
            SMStateMachine stateMachine = new SMStateMachine(this.client, policy, metadata, this.settings, this.threadPool, this.indicesManager);
            final SMMetadata finalMetadata = metadata;
            try {
                stateMachine.handlePolicyChange(new ActionListener<SMStateMachine>(){

                    public void onResponse(SMStateMachine sm) {
                        if (finalMetadata.getCreation() != null) {
                            sm.currentState(finalMetadata.getCreation().getCurrentState()).next(CreationTransitions.getCreationTransitions(), new ActionListener<SMStateMachine>(){

                                public void onResponse(SMStateMachine sm2) {
                                    if (finalMetadata.getDeletion() != null) {
                                        sm2.currentState(finalMetadata.getDeletion().getCurrentState()).next(DeletionTransitions.getDeletionTransitions(), new ActionListener<SMStateMachine>(){

                                            public void onResponse(SMStateMachine sm3) {
                                                SMRunner.this.releaseLock(context, lock, policy);
                                            }

                                            public void onFailure(Exception e) {
                                                log.error("Deletion workflow failed for " + policy.getPolicyName(), (Throwable)e);
                                                SMRunner.this.releaseLock(context, lock, policy);
                                            }
                                        });
                                    } else {
                                        SMRunner.this.releaseLock(context, lock, policy);
                                    }
                                }

                                public void onFailure(Exception e) {
                                    log.error("Creation workflow failed for " + policy.getPolicyName(), (Throwable)e);
                                    SMRunner.this.releaseLock(context, lock, policy);
                                }
                            });
                        } else if (finalMetadata.getDeletion() != null) {
                            sm.currentState(finalMetadata.getDeletion().getCurrentState()).next(DeletionTransitions.getDeletionTransitions(), new ActionListener<SMStateMachine>(){

                                public void onResponse(SMStateMachine sm2) {
                                    SMRunner.this.releaseLock(context, lock, policy);
                                }

                                public void onFailure(Exception e) {
                                    log.error("Deletion workflow failed for " + policy.getPolicyName(), (Throwable)e);
                                    SMRunner.this.releaseLock(context, lock, policy);
                                }
                            });
                        } else {
                            SMRunner.this.releaseLock(context, lock, policy);
                        }
                    }

                    public void onFailure(Exception e) {
                        log.error("Failed to handle policy change for " + policy.getPolicyName(), (Throwable)e);
                        SMRunner.this.releaseLock(context, lock, policy);
                    }
                });
            }
            catch (Exception e) {
                log.error("Exception while starting state machine for " + policy.getPolicyName(), (Throwable)e);
                this.releaseLock(context, lock, policy);
            }
        }, this.executorService);
    }

    private void releaseLock(JobExecutionContext context, LockModel lock, SMPolicy policy) {
        if (!LockUtils.releaseLockForScheduledJob(context, lock)) {
            log.error("Could not release lock [" + lock.getLockId() + "] for " + policy.getId() + ".");
        }
    }

    private SMMetadata initMetadata(SMPolicy job) {
        SMMetadata initMetadata = this.getInitialMetadata(job);
        log.info("Initializing metadata [" + String.valueOf(initMetadata) + "] for [" + job.getPolicyName() + "].");
        try {
            IndexResponse res = SMUtils.indexMetadata(this.client, initMetadata, job.getId(), -2L, 0L, true);
            if (res.status() != RestStatus.CREATED) {
                log.error("Metadata initialization response status is " + String.valueOf(res.status()) + ", expecting CREATED 201.");
                return null;
            }
        }
        catch (Exception e) {
            log.error("Caught exception while initializing SM metadata.", (Throwable)e);
            return null;
        }
        return initMetadata;
    }

    private SMMetadata getInitialMetadata(SMPolicy job) {
        Instant now = Instant.now();
        SMMetadata.WorkflowMetadata creation = null;
        if (job.getCreation() != null) {
            creation = new SMMetadata.WorkflowMetadata(SMState.CREATION_START, new SMMetadata.Trigger(job.getCreation().getSchedule().getNextExecutionTime(now)), null, null, null);
        }
        SMMetadata.WorkflowMetadata deletion = null;
        if (job.getDeletion() != null) {
            deletion = new SMMetadata.WorkflowMetadata(SMState.DELETION_START, new SMMetadata.Trigger(job.getDeletion().getSchedule().getNextExecutionTime(now)), null, null, null);
        }
        return new SMMetadata(job.getSeqNo(), job.getPrimaryTerm(), creation, deletion, SMUtils.smPolicyNameToMetadataDocId(SMUtils.smDocIdToPolicyName(job.getId())), -2L, 0L);
    }
}

