/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.snapshotmanagement;

import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.lucenia.indexmanagement.snapshotmanagement.SnapshotManagementException;
import io.lucenia.indexmanagement.snapshotmanagement.engine.states.SMResult;
import io.lucenia.indexmanagement.snapshotmanagement.engine.states.WorkflowType;
import io.lucenia.indexmanagement.snapshotmanagement.model.NotificationConfig;
import io.lucenia.indexmanagement.snapshotmanagement.model.SMMetadata;
import io.lucenia.indexmanagement.snapshotmanagement.model.SMPolicy;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.Randomness;
import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.common.xcontent.XContentFactory;
import io.skylite.core.action.admin.cluster.snapshots.get.GetSnapshotsRequest;
import io.skylite.core.action.get.GetRequest;
import io.skylite.core.action.get.GetResponse;
import io.skylite.core.action.index.IndexRequest;
import io.skylite.core.action.index.IndexResponse;
import io.skylite.core.client.Client;
import io.skylite.core.common.regex.Regex;
import io.skylite.core.common.time.DateFormatter;
import io.skylite.core.jobs.schedule.Schedule;
import io.skylite.core.security.auth.User;
import io.skylite.core.snapshots.SnapshotInfo;
import io.skylite.core.snapshots.SnapshotMissingException;
import io.skylite.core.transport.RemoteTransportException;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.ToXContent;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;

public class SMUtils {
    private static final int RANDOM_STRING_LENGTH = 8;

    public static String smMetadataDocIdToPolicyName(String docId) {
        return docId.substring(0, docId.lastIndexOf("-sm-metadata"));
    }

    public static String generateSnapshotName(SMPolicy policy) {
        Object timezoneObj;
        Object result = policy.getPolicyName();
        String dateFormat = (String)policy.getSnapshotConfig().get("date_format");
        if (dateFormat == null) {
            dateFormat = "yyyy-MM-dd'T'HH:mm:ss";
        }
        String dateValue = (timezoneObj = policy.getSnapshotConfig().get("date_format_timezone")) != null ? SMUtils.generateFormatDate(dateFormat, ZoneId.of((String)timezoneObj)) : SMUtils.generateFormatDate(dateFormat, ZoneId.of("UTC"));
        result = (String)result + "-" + dateValue.toLowerCase(Locale.ROOT);
        return (String)result + "-" + SMUtils.getRandomString(8);
    }

    private static String generateFormatDate(String dateFormat, ZoneId timezone) {
        DateFormatter dateFormatter = DateFormatter.forPattern((String)dateFormat).withZone(timezone);
        return dateFormatter.format((TemporalAccessor)Instant.now());
    }

    public static String getRandomString(int length) {
        String allowedChars = "abcdefghijklmnopqrstuvwxyz0123456789";
        StringBuilder result = new StringBuilder(length);
        Random random = Randomness.get();
        for (int i = 0; i < length; ++i) {
            result.append(allowedChars.charAt(random.nextInt(allowedChars.length())));
        }
        return result.toString();
    }

    public static Map<String, Object> addSMPolicyInSnapshotMetadata(Map<String, Object> snapshotConfig, String policyName) {
        HashMap<String, String> snapshotMetadata = (HashMap<String, String>)snapshotConfig.get("metadata");
        snapshotMetadata = snapshotMetadata == null ? new HashMap<String, String>() : new HashMap(snapshotMetadata);
        snapshotMetadata.put("sm_policy", policyName);
        HashMap<String, Object> snapshotConfigWithSMPolicyMetadata = new HashMap<String, Object>(snapshotConfig);
        snapshotConfigWithSMPolicyMetadata.put("metadata", snapshotMetadata);
        return snapshotConfigWithSMPolicyMetadata;
    }

    public static void getSnapshots(Client client, SMPolicy job, String name, SMMetadata.Builder metadataBuilder, Logger log, String snapshotMissingMsg, String exceptionMsg, ActionListener<GetSnapshotsResult> listener) {
        try {
            String[] patterns = (String[])Arrays.stream(name.split(",")).map(String::trim).toArray(String[]::new);
            GetSnapshotsRequest req = new GetSnapshotsRequest().snapshots(patterns).repository((String)job.getSnapshotConfig().get("repository"));
            client.admin().cluster().getSnapshots(req, ActionListener.wrap(res -> {
                ArrayList snapshots = new ArrayList(res.getSnapshots());
                List<String> patternList = Arrays.asList(patterns);
                String policyNamePattern = job.getPolicyName() + "*";
                List otherPatternSnapshots = snapshots.stream().filter(snapshot -> patternList.stream().anyMatch(pattern -> !pattern.equals(policyNamePattern) && Regex.simpleMatch((String)pattern, (String)snapshot.snapshotId().getName()))).collect(Collectors.toList());
                List policySnapshots = snapshots.stream().filter(s -> {
                    Map metadata = s.userMetadata();
                    return metadata != null && job.getPolicyName().equals(metadata.get("sm_policy"));
                }).collect(Collectors.toList());
                ArrayList<SnapshotInfo> combinedSnapshots = new ArrayList<SnapshotInfo>(policySnapshots);
                combinedSnapshots.addAll(otherPatternSnapshots);
                listener.onResponse((Object)new GetSnapshotsResult(false, combinedSnapshots, metadataBuilder));
            }, ex -> {
                Exception unwrappedException;
                Exception exception = unwrappedException = ex instanceof RemoteTransportException ? (Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)ex) : ex;
                if (unwrappedException instanceof SnapshotMissingException) {
                    if (snapshotMissingMsg != null) {
                        log.warn(snapshotMissingMsg);
                    }
                    listener.onResponse((Object)new GetSnapshotsResult(false, new ArrayList<SnapshotInfo>(), metadataBuilder));
                } else {
                    log.error(exceptionMsg, (Throwable)unwrappedException);
                    metadataBuilder.setLatestExecution(SMMetadata.LatestExecution.Status.RETRYING, true, exceptionMsg, true, unwrappedException, null);
                    listener.onResponse((Object)new GetSnapshotsResult(true, new ArrayList<SnapshotInfo>(), metadataBuilder));
                }
            }));
        }
        catch (Exception ex2) {
            log.error(exceptionMsg, (Throwable)ex2);
            metadataBuilder.setLatestExecution(SMMetadata.LatestExecution.Status.RETRYING, true, exceptionMsg, true, ex2, null);
            listener.onResponse((Object)new GetSnapshotsResult(true, new ArrayList<SnapshotInfo>(), metadataBuilder));
        }
    }

    public static UpdateNextExecutionTimeResult tryUpdatingNextExecutionTime(SMMetadata.Builder metadataBuilder, Instant nextTime, Schedule schedule, WorkflowType workflowType, Logger log) {
        Instant now = Instant.now();
        if (!now.isBefore(nextTime)) {
            log.info("Current time [" + String.valueOf(now) + "] has passed nextExecutionTime [" + String.valueOf(nextTime) + "].");
            Instant newNextTime = schedule.getNextExecutionTime(now);
            if (workflowType == WorkflowType.CREATION) {
                metadataBuilder.setNextCreationTime(newNextTime);
            } else if (workflowType == WorkflowType.DELETION) {
                metadataBuilder.setNextDeletionTime(newNextTime);
            }
            return new UpdateNextExecutionTimeResult(true, metadataBuilder);
        }
        log.debug("Current time [" + String.valueOf(now) + "] has not passed nextExecutionTime [" + String.valueOf(nextTime) + "]");
        return new UpdateNextExecutionTimeResult(false, metadataBuilder);
    }

    public static boolean isExceed(TimeValue timeValue, Instant startTime) {
        if (startTime == null) {
            return false;
        }
        return Instant.now().toEpochMilli() - startTime.toEpochMilli() > timeValue.millis();
    }

    public static SMResult timeLimitExceeded(TimeValue timeLimit, SMMetadata.Builder metadataBuilder, WorkflowType workflow, Logger log) {
        String message = SMUtils.getTimeLimitExceededMessage(timeLimit, workflow);
        log.warn(message);
        metadataBuilder.setLatestExecution(SMMetadata.LatestExecution.Status.TIME_LIMIT_EXCEEDED, true, message, true, (Exception)((Object)new SnapshotManagementException(message)), Instant.now());
        return new SMResult.Fail(metadataBuilder, workflow, true);
    }

    private static String getTimeLimitExceededMessage(TimeValue timeLimit, WorkflowType workflow) {
        String workflowStr = workflow == WorkflowType.CREATION ? "creation" : "deletion";
        return "Time limit " + String.valueOf(timeLimit) + " exceeded during snapshot " + workflowStr + " step";
    }

    public static void indexMetadata(Client client, SMMetadata metadata, String id, long seqNo, long primaryTerm, boolean create, ActionListener<IndexResponse> listener) {
        try {
            String metadataId = SMUtils.smPolicyNameToMetadataDocId(SMUtils.smDocIdToPolicyName(id));
            IndexRequest indexReq = new IndexRequest(".opendistro-ism-config").create(create).id(metadataId).source(metadata.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS)).setIfSeqNo(seqNo).setIfPrimaryTerm(primaryTerm).routing(id);
            client.index(indexReq, listener);
        }
        catch (Exception ex) {
            listener.onFailure(ex);
        }
    }

    public static String smPolicyNameToMetadataDocId(String policyName) {
        return policyName + "-sm-metadata";
    }

    public static String smDocIdToPolicyName(String docId) {
        return docId.substring(0, docId.lastIndexOf("-sm-policy"));
    }

    public static String smPolicyNameToDocId(String policyName) {
        return policyName + "-sm-policy";
    }

    public static void sendCreationNotification(NotificationConfig notificationConfig, Client client, String policyName, String message, User user, Logger log) {
        if (notificationConfig != null) {
            notificationConfig.sendCreationNotification(client, policyName, message, user, log);
        }
    }

    public static void sendDeletionNotification(NotificationConfig notificationConfig, Client client, String policyName, String message, User user, Logger log) {
        if (notificationConfig != null) {
            notificationConfig.sendDeletionNotification(client, policyName, message, user, log);
        }
    }

    public static void sendFailureNotification(NotificationConfig notificationConfig, Client client, String policyName, String message, User user, Logger log) {
        if (notificationConfig != null) {
            notificationConfig.sendFailureNotification(client, policyName, message, user, log);
        }
    }

    public static void sendTimeLimitExceededNotification(NotificationConfig notificationConfig, Client client, String policyName, String message, User user, Logger log) {
        if (notificationConfig != null) {
            notificationConfig.sendTimeLimitExceededNotification(client, policyName, message, user, log);
        }
    }

    public static SMMetadata getSMMetadata(Client client, String jobId) throws Exception {
        final CompletableFuture future = new CompletableFuture();
        String metadataDocId = SMUtils.smPolicyNameToMetadataDocId(SMUtils.smDocIdToPolicyName(jobId));
        GetRequest getRequest = new GetRequest(".opendistro-ism-config", metadataDocId);
        client.get(getRequest, (ActionListener)new ActionListener<GetResponse>(){

            public void onResponse(GetResponse response) {
                if (!response.isExists() || response.isSourceEmpty()) {
                    future.complete(null);
                    return;
                }
                try {
                    SMMetadata metadata = LuceniaExtensions.parseFromGetResponse(response, NamedXContentRegistry.EMPTY, SMMetadata::parse);
                    future.complete(metadata);
                }
                catch (Exception e) {
                    future.completeExceptionally(e);
                }
            }

            public void onFailure(Exception e) {
                future.completeExceptionally(e);
            }
        });
        try {
            return (SMMetadata)future.get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw e;
        }
    }

    public static IndexResponse indexMetadata(Client client, SMMetadata metadata, String id, long seqNo, long primaryTerm, boolean create) throws Exception {
        final CompletableFuture future = new CompletableFuture();
        SMUtils.indexMetadata(client, metadata, id, seqNo, primaryTerm, create, new ActionListener<IndexResponse>(){

            public void onResponse(IndexResponse response) {
                future.complete(response);
            }

            public void onFailure(Exception e) {
                future.completeExceptionally(e);
            }
        });
        try {
            return (IndexResponse)future.get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw e;
        }
    }

    public static String validateDateFormat(String dateFormat) {
        try {
            ZoneId timeZone = ZoneId.systemDefault();
            DateFormatter dateFormatter = DateFormatter.forPattern((String)dateFormat).withZone(timeZone);
            Instant instant = dateFormatter.toDateMathParser().parse("now/s", System::currentTimeMillis, false, timeZone);
            dateFormatter.format((TemporalAccessor)instant);
            return null;
        }
        catch (Exception e) {
            return e.getMessage() != null ? e.getMessage() : "Invalid date format.";
        }
    }

    public static String preFixTimeStamp(String msg) {
        DateTimeFormatter formatter = DateTimeFormatter.ISO_INSTANT;
        return "[" + formatter.format(Instant.now().truncatedTo(ChronoUnit.SECONDS)) + "]: " + msg;
    }

    private SMUtils() {
    }

    public static class GetSnapshotsResult {
        private final boolean failed;
        private final List<SnapshotInfo> snapshots;
        private final SMMetadata.Builder metadataBuilder;

        public GetSnapshotsResult(boolean failed, List<SnapshotInfo> snapshots, SMMetadata.Builder metadataBuilder) {
            this.failed = failed;
            this.snapshots = snapshots;
            this.metadataBuilder = metadataBuilder;
        }

        public boolean isFailed() {
            return this.failed;
        }

        public List<SnapshotInfo> getSnapshots() {
            return this.snapshots;
        }

        public SMMetadata.Builder getMetadataBuilder() {
            return this.metadataBuilder;
        }
    }

    public static class UpdateNextExecutionTimeResult {
        private final boolean updated;
        private final SMMetadata.Builder metadataBuilder;

        public UpdateNextExecutionTimeResult(boolean updated, SMMetadata.Builder metadataBuilder) {
            this.updated = updated;
            this.metadataBuilder = metadataBuilder;
        }

        public boolean isUpdated() {
            return this.updated;
        }

        public SMMetadata.Builder getMetadataBuilder() {
            return this.metadataBuilder;
        }
    }
}

