/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.snapshotmanagement.api.resthandler;

import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.lucenia.indexmanagement.snapshotmanagement.SMUtils;
import io.lucenia.indexmanagement.snapshotmanagement.api.transport.SMActions;
import io.lucenia.indexmanagement.snapshotmanagement.api.transport.index.IndexSMPolicyRequest;
import io.lucenia.indexmanagement.snapshotmanagement.api.transport.index.IndexSMPolicyResponse;
import io.lucenia.indexmanagement.snapshotmanagement.model.SMPolicy;
import io.lucenia.indexmanagement.snapshotmanagement.util.RestHandlerUtils;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.WriteRequest;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestResponse;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.xcontent.ToXContent;
import java.io.IOException;
import java.time.Instant;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.action.RestResponseListener;

public abstract class RestBaseIndexSMPolicyHandler
extends BaseRestHandler {
    protected RestBaseIndexSMPolicyHandler() {
    }

    protected BaseRestHandler.RestChannelConsumer prepareIndexRequest(RestRequest request, NodeClient client, boolean create) throws IOException {
        String policyName = RestHandlerUtils.getValidSMPolicyName(request);
        long seqNo = request.paramAsLong("if_seq_no", -2L);
        long primaryTerm = request.paramAsLong("if_primary_term", 0L);
        SMPolicy parsedPolicy = LuceniaExtensions.parseWithType(request.contentParser(), SMUtils.smPolicyNameToDocId(policyName), seqNo, primaryTerm, SMPolicy::parse);
        SMPolicy policy = new SMPolicy.Builder(parsedPolicy).lastUpdateTime(Instant.now()).build();
        WriteRequest.RefreshPolicy refreshPolicy = request.hasParam("refresh") ? WriteRequest.RefreshPolicy.parse((String)request.param("refresh")) : WriteRequest.RefreshPolicy.IMMEDIATE;
        IndexSMPolicyRequest indexRequest = new IndexSMPolicyRequest(policy, create, refreshPolicy);
        return channel -> client.execute(SMActions.INDEX_SM_POLICY_ACTION_TYPE, (ActionRequest)indexRequest, (ActionListener)new RestResponseListener<IndexSMPolicyResponse>(this, channel){

            public RestResponse buildResponse(IndexSMPolicyResponse response) throws Exception {
                BytesRestResponse restResponse = new BytesRestResponse(response.getStatus(), response.toXContent(this.channel.newBuilder(), ToXContent.EMPTY_PARAMS));
                if (response.getStatus() == RestStatus.CREATED || response.getStatus() == RestStatus.OK) {
                    String location = "/_plugins/_sm/policies/" + response.getPolicy().getPolicyName();
                    restResponse.addHeader("Location", location);
                }
                return restResponse;
            }
        });
    }
}

