/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.snapshotmanagement.api.resthandler;

import io.lucenia.indexmanagement.snapshotmanagement.SMUtils;
import io.lucenia.indexmanagement.snapshotmanagement.api.transport.SMActions;
import io.lucenia.indexmanagement.snapshotmanagement.api.transport.delete.DeleteSMPolicyRequest;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.WriteRequest;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import java.io.IOException;
import java.util.List;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestDeleteSMPolicyHandler
extends BaseRestHandler {
    public String getName() {
        return "snapshot_management_delete_policy_rest_handler";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.DELETE, "/_plugins/_sm/policies/{policyName}"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String policyName = request.param("policyName", "");
        if (policyName.isEmpty()) {
            throw new IllegalArgumentException("Missing policy name");
        }
        WriteRequest.RefreshPolicy refreshPolicy = request.hasParam("refresh") ? WriteRequest.RefreshPolicy.parse((String)request.param("refresh")) : WriteRequest.RefreshPolicy.IMMEDIATE;
        DeleteSMPolicyRequest deleteRequest = new DeleteSMPolicyRequest(SMUtils.smPolicyNameToDocId(policyName));
        deleteRequest.setRefreshPolicy(refreshPolicy);
        return channel -> client.execute(SMActions.DELETE_SM_POLICY_ACTION_TYPE, (ActionRequest)deleteRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

