/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.snapshotmanagement.api.resthandler;

import io.lucenia.indexmanagement.snapshotmanagement.api.transport.SMActions;
import io.lucenia.indexmanagement.snapshotmanagement.api.transport.explain.ExplainSMPolicyRequest;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.common.Strings;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestExplainSMPolicyHandler
extends BaseRestHandler {
    private final Logger log = LogManager.getLogger(RestExplainSMPolicyHandler.class);

    public String getName() {
        return "snapshot_management_explain_policy_rest_handler";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_sm/policies/{policyName}/_explain"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        Object[] policyNames = Strings.splitStringByCommaToArray((String)request.param("policyName", ""));
        if (policyNames.length == 0) {
            policyNames = new String[]{"*"};
        }
        this.log.debug("Explain snapshot management policy request received with policy name(s) {}", (Object)Arrays.toString(policyNames));
        ExplainSMPolicyRequest explainRequest = new ExplainSMPolicyRequest((String[])policyNames);
        return channel -> client.execute(SMActions.EXPLAIN_SM_POLICY_ACTION_TYPE, (ActionRequest)explainRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

