/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.snapshotmanagement.api.resthandler;

import io.lucenia.indexmanagement.common.model.rest.SearchParams;
import io.lucenia.indexmanagement.snapshotmanagement.SMUtils;
import io.lucenia.indexmanagement.snapshotmanagement.api.transport.SMActions;
import io.lucenia.indexmanagement.snapshotmanagement.api.transport.get.GetSMPoliciesRequest;
import io.lucenia.indexmanagement.snapshotmanagement.api.transport.get.GetSMPolicyRequest;
import io.lucenia.indexmanagement.util.RestHandlerUtils;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import java.io.IOException;
import java.util.List;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestGetSMPolicyHandler
extends BaseRestHandler {
    public String getName() {
        return "snapshot_management_get_policy_rest_handler";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_sm/policies/{policyName}"), new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_sm/policies/"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String policyName = request.param("policyName", "");
        if (policyName.isEmpty()) {
            return this.getAllPolicies(request, client);
        }
        return this.getSMPolicyByName(client, policyName);
    }

    private BaseRestHandler.RestChannelConsumer getSMPolicyByName(NodeClient client, String policyName) {
        GetSMPolicyRequest getRequest = new GetSMPolicyRequest(SMUtils.smPolicyNameToDocId(policyName));
        return channel -> client.execute(SMActions.GET_SM_POLICY_ACTION_TYPE, (ActionRequest)getRequest, (ActionListener)new RestToXContentListener(channel));
    }

    private BaseRestHandler.RestChannelConsumer getAllPolicies(RestRequest request, NodeClient client) {
        SearchParams searchParams = RestHandlerUtils.getSearchParams(request, "sm_policy.name");
        GetSMPoliciesRequest getRequest = new GetSMPoliciesRequest(searchParams);
        return channel -> client.execute(SMActions.GET_SM_POLICIES_ACTION_TYPE, (ActionRequest)getRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

