/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.snapshotmanagement.api.resthandler;

import io.lucenia.indexmanagement.snapshotmanagement.SMUtils;
import io.lucenia.indexmanagement.snapshotmanagement.api.transport.SMActions;
import io.lucenia.indexmanagement.snapshotmanagement.api.transport.start.StartSMRequest;
import io.lucenia.indexmanagement.snapshotmanagement.util.RestHandlerUtils;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.client.node.NodeClient;
import io.skylite.core.rest.RestHandler;
import io.skylite.core.rest.RestRequest;
import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.action.RestToXContentListener;

public class RestStartSMPolicyHandler
extends BaseRestHandler {
    private final Logger log = LogManager.getLogger(RestStartSMPolicyHandler.class);

    public String getName() {
        return "snapshot_management_start_policy_rest_handler";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.POST, "/_plugins/_sm/policies/{policyName}/_start"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String policyName = RestHandlerUtils.getValidSMPolicyName(request);
        this.log.debug("Start snapshot management policy request received with policy name [{}]", (Object)policyName);
        StartSMRequest startRequest = new StartSMRequest(SMUtils.smPolicyNameToDocId(policyName));
        return channel -> client.execute(SMActions.START_SM_POLICY_ACTION_TYPE, (ActionRequest)startRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

