/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.snapshotmanagement.api.transport;

import io.lucenia.indexmanagement.util.IndexManagementException;
import io.lucenia.indexmanagement.util.SecurityUtils;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionRequest;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.action.support.HandledTransportAction;
import io.skylite.core.client.Client;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.index.engine.VersionConflictEngineException;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.security.auth.User;
import io.skylite.core.tasks.Task;
import io.skylite.core.transport.TransportService;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BaseTransportAction<Request extends ActionRequest, Response extends ActionResponse>
extends HandledTransportAction<Request, Response> {
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    protected final Client client;

    public BaseTransportAction(String name, TransportService transportService, Client client, ActionFilters actionFilters, Writeable.Reader<Request> requestReader) {
        super(name, transportService, actionFilters, requestReader);
        this.client = client;
    }

    protected void doExecute(Task task, Request request, ActionListener<Response> listener) {
        this.log.debug("user and roles string from thread context: " + String.valueOf(this.client.threadPool().getThreadContext().getTransient("_opendistro_security_user_info")));
        User user = SecurityUtils.buildUser(this.client.threadPool().getThreadContext());
        CompletableFuture.runAsync(() -> {
            try (ThreadContext.StoredContext threadContext = this.client.threadPool().getThreadContext().stashContext();){
                Response response = this.executeRequest(request, user, threadContext);
                listener.onResponse(response);
            }
            catch (IndexManagementException ex) {
                listener.onFailure((Exception)((Object)ex));
            }
            catch (VersionConflictEngineException ex) {
                listener.onFailure((Exception)((Object)ex));
            }
            catch (SkyliteStatusException ex) {
                listener.onFailure((Exception)((Object)ex));
            }
            catch (Exception ex) {
                this.log.error("Uncaught exception:", (Throwable)ex);
                listener.onFailure((Exception)((Object)new SkyliteStatusException(ex.getMessage(), RestStatus.INTERNAL_SERVER_ERROR, new Object[0])));
            }
        }, this.client.threadPool().executor("management"));
    }

    protected abstract Response executeRequest(Request var1, User var2, ThreadContext.StoredContext var3) throws Exception;
}

