/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.snapshotmanagement.api.transport.delete;

import io.lucenia.indexmanagement.snapshotmanagement.api.transport.BaseTransportAction;
import io.lucenia.indexmanagement.snapshotmanagement.api.transport.delete.DeleteSMPolicyRequest;
import io.lucenia.indexmanagement.snapshotmanagement.model.SMPolicy;
import io.lucenia.indexmanagement.snapshotmanagement.settings.SnapshotManagementSettings;
import io.lucenia.indexmanagement.snapshotmanagement.util.RestHandlerUtils;
import io.lucenia.indexmanagement.util.SecurityUtils;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.delete.DeleteRequest;
import io.skylite.core.action.delete.DeleteResponse;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.index.engine.VersionConflictEngineException;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.security.auth.User;
import io.skylite.core.settings.Settings;
import io.skylite.core.transport.TransportService;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportDeleteSMPolicyAction
extends BaseTransportAction<DeleteSMPolicyRequest, DeleteResponse> {
    private static final String CONFLICT_EXCEPTION_MESSAGE = "Failed while trying to delete SM Policy due to a concurrent update, please try again";
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final ClusterService clusterService;
    private final Settings settings;
    private volatile boolean filterByEnabled;

    @Inject
    public TransportDeleteSMPolicyAction(Client client, TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, Settings settings) {
        super("cluster:admin/lucenia/snapshot_management/policy/delete", transportService, client, actionFilters, DeleteSMPolicyRequest::new);
        this.clusterService = clusterService;
        this.settings = settings;
        this.filterByEnabled = (Boolean)SnapshotManagementSettings.FILTER_BY_BACKEND_ROLES.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SnapshotManagementSettings.FILTER_BY_BACKEND_ROLES, it -> {
            this.filterByEnabled = it;
        });
    }

    @Override
    protected DeleteResponse executeRequest(DeleteSMPolicyRequest request, User user, ThreadContext.StoredContext threadContext) throws Exception {
        SMPolicy smPolicy;
        final CompletableFuture future = new CompletableFuture();
        RestHandlerUtils.getSMPolicy(this.client, request.id(), new ActionListener<SMPolicy>(){

            public void onResponse(SMPolicy policy) {
                future.complete(policy);
            }

            public void onFailure(Exception e) {
                future.completeExceptionally(e);
            }
        });
        try {
            smPolicy = (SMPolicy)future.get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SkyliteStatusException) {
                throw (SkyliteStatusException)cause;
            }
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw new RuntimeException(cause);
        }
        SecurityUtils.verifyUserHasPermissionForResource(user, smPolicy.getUser(), this.filterByEnabled, "snapshot management policy", smPolicy.getPolicyName());
        DeleteSMPolicyRequest deleteReq = (DeleteSMPolicyRequest)request.index(".opendistro-ism-config");
        final AtomicReference responseRef = new AtomicReference();
        final AtomicReference exceptionRef = new AtomicReference();
        this.client.delete((DeleteRequest)deleteReq, (ActionListener)new ActionListener<DeleteResponse>(){

            public void onResponse(DeleteResponse deleteResponse) {
                responseRef.set(deleteResponse);
            }

            public void onFailure(Exception e) {
                exceptionRef.set(e);
            }
        });
        while (responseRef.get() == null && exceptionRef.get() == null) {
            Thread.sleep(10L);
        }
        if (exceptionRef.get() != null) {
            Exception e = (Exception)exceptionRef.get();
            if (e instanceof VersionConflictEngineException) {
                this.log.error("VersionConflictEngineException while trying to delete snapshot management policy id [" + deleteReq.id() + "]: " + String.valueOf(e));
                throw new SkyliteStatusException(CONFLICT_EXCEPTION_MESSAGE, RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
            }
            this.log.error("Failed trying to delete snapshot management policy id [" + deleteReq.id() + "]: " + String.valueOf(e));
            throw new SkyliteStatusException("Failed while trying to delete SM Policy", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
        }
        return (DeleteResponse)responseRef.get();
    }
}

