/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.snapshotmanagement.api.transport.explain;

import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.lucenia.indexmanagement.snapshotmanagement.api.transport.BaseTransportAction;
import io.lucenia.indexmanagement.snapshotmanagement.api.transport.explain.ExplainSMPolicyRequest;
import io.lucenia.indexmanagement.snapshotmanagement.api.transport.explain.ExplainSMPolicyResponse;
import io.lucenia.indexmanagement.snapshotmanagement.model.ExplainSMPolicy;
import io.lucenia.indexmanagement.snapshotmanagement.model.SMMetadata;
import io.lucenia.indexmanagement.snapshotmanagement.settings.SnapshotManagementSettings;
import io.lucenia.indexmanagement.snapshotmanagement.util.RestHandlerUtils;
import io.lucenia.indexmanagement.util.SecurityUtils;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.index.query.BoolQueryBuilder;
import io.skylite.core.index.query.ExistsQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.TermQueryBuilder;
import io.skylite.core.index.query.WildcardQueryBuilder;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.search.SearchHit;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.search.fetch.subphase.FetchSourceContext;
import io.skylite.core.security.auth.User;
import io.skylite.core.settings.Settings;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportExplainSMAction
extends BaseTransportAction<ExplainSMPolicyRequest, ExplainSMPolicyResponse> {
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final ClusterService clusterService;
    private final Settings settings;
    private volatile boolean filterByEnabled;

    @Inject
    public TransportExplainSMAction(Client client, TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, Settings settings) {
        super("cluster:admin/lucenia/snapshot_management/policy/explain", transportService, client, actionFilters, ExplainSMPolicyRequest::new);
        this.clusterService = clusterService;
        this.settings = settings;
        this.filterByEnabled = (Boolean)SnapshotManagementSettings.FILTER_BY_BACKEND_ROLES.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SnapshotManagementSettings.FILTER_BY_BACKEND_ROLES, it -> {
            this.filterByEnabled = it;
        });
    }

    @Override
    protected ExplainSMPolicyResponse executeRequest(ExplainSMPolicyRequest request, User user, ThreadContext.StoredContext threadContext) throws Exception {
        HashSet<String> policyNames = new HashSet<String>();
        for (String name : request.getPolicyNames()) {
            policyNames.add(name);
        }
        Map<String, Boolean> namesToEnabled = this.getPolicyEnabledStatus(policyNames, user);
        Map<String, SMMetadata> namesToMetadata = this.getSMMetadata(namesToEnabled.keySet());
        return this.buildExplainResponse(namesToEnabled, namesToMetadata);
    }

    private Map<String, Boolean> getPolicyEnabledStatus(Set<String> policyNames, User user) throws Exception {
        SearchRequest searchRequest = this.getPolicyEnabledSearchRequest(policyNames, user);
        final AtomicReference responseRef = new AtomicReference();
        final AtomicReference exceptionRef = new AtomicReference();
        this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse searchResponse) {
                responseRef.set(searchResponse);
            }

            public void onFailure(Exception e) {
                exceptionRef.set(e);
            }
        });
        while (responseRef.get() == null && exceptionRef.get() == null) {
            Thread.sleep(10L);
        }
        if (exceptionRef.get() != null) {
            Exception e = (Exception)exceptionRef.get();
            if (e instanceof IndexNotFoundException) {
                throw new SkyliteStatusException("Snapshot management config index not found", RestStatus.NOT_FOUND, new Object[0]);
            }
            this.log.error("Failed to search for snapshot management policy", (Throwable)e);
            throw new SkyliteStatusException("Failed to search for snapshot management policy", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
        }
        SearchResponse searchResponse = (SearchResponse)responseRef.get();
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        try {
            for (SearchHit hit : searchResponse.getHits().getHits()) {
                XContentParser parser = LuceniaExtensions.contentParser(hit.getSourceRef());
                Map.Entry<String, Boolean> entry = this.parseNameToEnabled(parser);
                result.put(entry.getKey(), entry.getValue());
            }
        }
        catch (Exception e) {
            this.log.error("Failed to parse snapshot management policy in search response", (Throwable)e);
            throw new SkyliteStatusException("Failed to parse snapshot management policy", RestStatus.NOT_FOUND, new Object[0]);
        }
        return result;
    }

    private SearchRequest getPolicyEnabledSearchRequest(Set<String> policyNames, User user) {
        BoolQueryBuilder queryBuilder = this.getPolicyQuery(policyNames);
        SecurityUtils.addUserFilter(user, queryBuilder, this.filterByEnabled, "sm_policy.user");
        String[] includes = new String[]{"sm_policy.name", "sm_policy.enabled"};
        FetchSourceContext fetchSourceContext = new FetchSourceContext(true, includes, new String[0]);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().size(10000).query((QueryBuilder)queryBuilder).fetchSource(fetchSourceContext);
        return new SearchRequest(new String[]{".opendistro-ism-config"}).source(searchSourceBuilder);
    }

    private BoolQueryBuilder getPolicyQuery(Set<String> policyNames) {
        BoolQueryBuilder queryBuilder = new BoolQueryBuilder().filter((QueryBuilder)new ExistsQueryBuilder("sm_policy"));
        queryBuilder.minimumShouldMatch(1);
        for (String policyName : policyNames) {
            if (policyName.contains("*") || policyName.contains("?")) {
                queryBuilder.should((QueryBuilder)new WildcardQueryBuilder("sm_policy.name", policyName));
                continue;
            }
            queryBuilder.should((QueryBuilder)new TermQueryBuilder("sm_policy.name", policyName));
        }
        return queryBuilder;
    }

    private Map<String, SMMetadata> getSMMetadata(Set<String> policyNames) throws Exception {
        SearchRequest searchRequest = this.getSMMetadataSearchRequest(policyNames);
        final AtomicReference responseRef = new AtomicReference();
        final AtomicReference exceptionRef = new AtomicReference();
        this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse searchResponse) {
                responseRef.set(searchResponse);
            }

            public void onFailure(Exception e) {
                exceptionRef.set(e);
            }
        });
        while (responseRef.get() == null && exceptionRef.get() == null) {
            Thread.sleep(10L);
        }
        if (exceptionRef.get() != null) {
            Exception e = (Exception)exceptionRef.get();
            if (e instanceof IndexNotFoundException) {
                throw new SkyliteStatusException("Snapshot management config index not found", RestStatus.NOT_FOUND, new Object[0]);
            }
            throw e;
        }
        SearchResponse searchResponse = (SearchResponse)responseRef.get();
        HashMap<String, SMMetadata> result = new HashMap<String, SMMetadata>();
        try {
            for (SearchHit hit : searchResponse.getHits().getHits()) {
                SMMetadata smMetadata = LuceniaExtensions.parseWithType(LuceniaExtensions.contentParser(hit.getSourceRef()), hit.getId(), hit.getSeqNo(), hit.getPrimaryTerm(), SMMetadata::parse);
                result.put(RestHandlerUtils.smMetadataDocIdToPolicyName(smMetadata.getId()), smMetadata);
            }
        }
        catch (Exception e) {
            this.log.error("Failed to parse snapshot management metadata in search response", (Throwable)e);
            throw new SkyliteStatusException("Failed to parse snapshot management metadata", RestStatus.NOT_FOUND, new Object[0]);
        }
        return result;
    }

    private SearchRequest getSMMetadataSearchRequest(Set<String> policyNames) {
        BoolQueryBuilder queryBuilder = new BoolQueryBuilder().filter((QueryBuilder)new ExistsQueryBuilder("sm_metadata"));
        queryBuilder.minimumShouldMatch(1);
        for (String policyName : policyNames) {
            queryBuilder.should((QueryBuilder)new TermQueryBuilder("sm_metadata.name", policyName));
        }
        return new SearchRequest(new String[]{".opendistro-ism-config"}).source(new SearchSourceBuilder().size(10000).query((QueryBuilder)queryBuilder));
    }

    private Map.Entry<String, Boolean> parseNameToEnabled(XContentParser xcp) throws Exception {
        AtomicReference<String> name = new AtomicReference<String>();
        AtomicReference<Boolean> enabled = new AtomicReference<Boolean>();
        if (xcp.currentToken() == null) {
            xcp.nextToken();
        }
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            if ("name".equals(fieldName)) {
                name.set(xcp.text());
                continue;
            }
            if (!"enabled".equals(fieldName)) continue;
            enabled.set(xcp.booleanValue());
        }
        if (name.get() == null) {
            throw new IllegalArgumentException("The name field of SMPolicy must not be null.");
        }
        if (enabled.get() == null) {
            throw new IllegalArgumentException("The enabled field of SMPolicy must not be null.");
        }
        return new AbstractMap.SimpleEntry<String, Boolean>((String)name.get(), (Boolean)enabled.get());
    }

    private ExplainSMPolicyResponse buildExplainResponse(Map<String, Boolean> namesToEnabled, Map<String, SMMetadata> namesToMetadata) {
        HashMap<String, ExplainSMPolicy> policiesToExplain = new HashMap<String, ExplainSMPolicy>();
        for (Map.Entry<String, Boolean> entry : namesToEnabled.entrySet()) {
            String policyName = entry.getKey();
            Boolean enabled = entry.getValue();
            policiesToExplain.put(policyName, new ExplainSMPolicy(namesToMetadata.get(policyName), enabled));
        }
        this.log.debug("Explain response: " + String.valueOf(policiesToExplain));
        return new ExplainSMPolicyResponse(policiesToExplain);
    }
}

