/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.snapshotmanagement.api.transport.get;

import io.lucenia.indexmanagement.indexstatemanagement.util.RestHandlerUtils;
import io.lucenia.indexmanagement.snapshotmanagement.model.SMPolicy;
import io.skylite.core.action.ActionResponse;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.List;

public class GetSMPoliciesResponse
extends ActionResponse
implements ToXContentObject {
    private final List<SMPolicy> policies;
    private final long totalPolicies;

    public GetSMPoliciesResponse(List<SMPolicy> policies, long totalPolicies) {
        this.policies = policies;
        this.totalPolicies = totalPolicies;
    }

    public GetSMPoliciesResponse(StreamInput sin) throws IOException {
        super(sin);
        this.policies = sin.readList(SMPolicy::new);
        this.totalPolicies = sin.readLong();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.policies);
        out.writeLong(this.totalPolicies);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray("policies");
        for (SMPolicy policy : this.policies) {
            builder.startObject();
            builder.field("_id", policy.getId());
            builder.field("_seq_no", policy.getSeqNo());
            builder.field("_primary_term", policy.getPrimaryTerm());
            builder.field("sm_policy", (ToXContent)policy, (ToXContent.Params)RestHandlerUtils.XCONTENT_WITHOUT_TYPE_AND_USER);
            builder.endObject();
        }
        builder.endArray();
        builder.field("total_policies", this.totalPolicies);
        builder.endObject();
        return builder;
    }

    public List<SMPolicy> getPolicies() {
        return this.policies;
    }

    public long getTotalPolicies() {
        return this.totalPolicies;
    }
}

