/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.snapshotmanagement.api.transport.get;

import io.lucenia.indexmanagement.common.model.rest.SearchParams;
import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.lucenia.indexmanagement.snapshotmanagement.api.transport.BaseTransportAction;
import io.lucenia.indexmanagement.snapshotmanagement.api.transport.get.GetSMPoliciesRequest;
import io.lucenia.indexmanagement.snapshotmanagement.api.transport.get.GetSMPoliciesResponse;
import io.lucenia.indexmanagement.snapshotmanagement.model.SMPolicy;
import io.lucenia.indexmanagement.snapshotmanagement.settings.SnapshotManagementSettings;
import io.lucenia.indexmanagement.util.SecurityUtils;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.search.SearchResponse;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.index.query.BoolQueryBuilder;
import io.skylite.core.index.query.ExistsQueryBuilder;
import io.skylite.core.index.query.Operator;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.search.SearchHit;
import io.skylite.core.search.SearchRequest;
import io.skylite.core.search.builder.SearchSourceBuilder;
import io.skylite.core.search.sort.BaseSortBuilder;
import io.skylite.core.security.auth.User;
import io.skylite.core.settings.Settings;
import io.skylite.core.transport.TransportService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.index.query.QueryBuilders;

public class TransportGetSMPoliciesAction
extends BaseTransportAction<GetSMPoliciesRequest, GetSMPoliciesResponse> {
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final ClusterService clusterService;
    private final Settings settings;
    private volatile boolean filterByEnabled;

    @Inject
    public TransportGetSMPoliciesAction(Client client, TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, Settings settings) {
        super("cluster:admin/lucenia/snapshot_management/policy/search", transportService, client, actionFilters, GetSMPoliciesRequest::new);
        this.clusterService = clusterService;
        this.settings = settings;
        this.filterByEnabled = (Boolean)SnapshotManagementSettings.FILTER_BY_BACKEND_ROLES.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SnapshotManagementSettings.FILTER_BY_BACKEND_ROLES, it -> {
            this.filterByEnabled = it;
        });
    }

    @Override
    protected GetSMPoliciesResponse executeRequest(GetSMPoliciesRequest request, User user, ThreadContext.StoredContext threadContext) throws Exception {
        SearchParams searchParams = request.getSearchParams();
        PolicyResult result = this.getAllPolicies(searchParams, user);
        return new GetSMPoliciesResponse(result.policies, result.totalPoliciesCount);
    }

    private PolicyResult getAllPolicies(SearchParams searchParams, User user) throws Exception {
        SearchRequest searchRequest = this.getAllPoliciesRequest(searchParams, user);
        final AtomicReference responseRef = new AtomicReference();
        final AtomicReference exceptionRef = new AtomicReference();
        this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse searchResponse) {
                responseRef.set(searchResponse);
            }

            public void onFailure(Exception e) {
                exceptionRef.set(e);
            }
        });
        while (responseRef.get() == null && exceptionRef.get() == null) {
            Thread.sleep(10L);
        }
        if (exceptionRef.get() != null) {
            Exception e = (Exception)exceptionRef.get();
            Exception unwrappedException = (Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)e);
            if (unwrappedException instanceof IndexNotFoundException) {
                return new PolicyResult(new ArrayList<SMPolicy>(), 0L);
            }
            throw unwrappedException;
        }
        SearchResponse searchResponse = (SearchResponse)responseRef.get();
        return this.parseGetAllPoliciesResponse(searchResponse);
    }

    private SearchRequest getAllPoliciesRequest(SearchParams searchParams, User user) {
        BoolQueryBuilder queryBuilder = new BoolQueryBuilder().filter((QueryBuilder)new ExistsQueryBuilder("sm_policy")).must((QueryBuilder)QueryBuilders.queryStringQuery((String)searchParams.getQueryString()).defaultOperator(Operator.AND).field("sm_policy.name"));
        SecurityUtils.addUserFilter(user, queryBuilder, this.filterByEnabled, "sm_policy.user");
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().size(searchParams.getSize()).from(searchParams.getFrom()).sort((BaseSortBuilder)searchParams.getSortBuilder()).query((QueryBuilder)queryBuilder).seqNoAndPrimaryTerm(Boolean.valueOf(true));
        return new SearchRequest(new String[]{".opendistro-ism-config"}).source(searchSourceBuilder);
    }

    private PolicyResult parseGetAllPoliciesResponse(SearchResponse searchResponse) throws Exception {
        try {
            long totalPolicies = searchResponse.getHits().getTotalHits() != null ? searchResponse.getHits().getTotalHits().value() : 0L;
            ArrayList<SMPolicy> policies = new ArrayList<SMPolicy>();
            for (SearchHit hit : searchResponse.getHits().getHits()) {
                SMPolicy policy = LuceniaExtensions.parseWithType(LuceniaExtensions.contentParser(hit.getSourceRef()), hit.getId(), hit.getSeqNo(), hit.getPrimaryTerm(), SMPolicy::parse);
                policies.add(policy);
            }
            return new PolicyResult(policies, totalPolicies);
        }
        catch (Exception e) {
            this.log.error("Failed to parse snapshot management policy in search response", (Throwable)e);
            throw new SkyliteStatusException("Failed to parse snapshot management policy", RestStatus.NOT_FOUND, new Object[0]);
        }
    }

    private static class PolicyResult {
        final List<SMPolicy> policies;
        final long totalPoliciesCount;

        PolicyResult(List<SMPolicy> policies, long totalPoliciesCount) {
            this.policies = policies;
            this.totalPoliciesCount = totalPoliciesCount;
        }
    }
}

