/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.snapshotmanagement.api.transport.get;

import io.lucenia.indexmanagement.snapshotmanagement.api.transport.BaseTransportAction;
import io.lucenia.indexmanagement.snapshotmanagement.api.transport.get.GetSMPolicyRequest;
import io.lucenia.indexmanagement.snapshotmanagement.api.transport.get.GetSMPolicyResponse;
import io.lucenia.indexmanagement.snapshotmanagement.model.SMPolicy;
import io.lucenia.indexmanagement.snapshotmanagement.settings.SnapshotManagementSettings;
import io.lucenia.indexmanagement.snapshotmanagement.util.RestHandlerUtils;
import io.lucenia.indexmanagement.util.SecurityUtils;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.get.GetRequest;
import io.skylite.core.action.get.GetResponse;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.security.auth.User;
import io.skylite.core.settings.Settings;
import io.skylite.core.transport.TransportService;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportGetSMPolicyAction
extends BaseTransportAction<GetSMPolicyRequest, GetSMPolicyResponse> {
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final ClusterService clusterService;
    private final Settings settings;
    private volatile boolean filterByEnabled;

    @Inject
    public TransportGetSMPolicyAction(Client client, TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, Settings settings) {
        super("cluster:admin/lucenia/snapshot_management/policy/get", transportService, client, actionFilters, GetSMPolicyRequest::new);
        this.clusterService = clusterService;
        this.settings = settings;
        this.filterByEnabled = (Boolean)SnapshotManagementSettings.FILTER_BY_BACKEND_ROLES.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SnapshotManagementSettings.FILTER_BY_BACKEND_ROLES, it -> {
            this.filterByEnabled = it;
        });
    }

    @Override
    protected GetSMPolicyResponse executeRequest(GetSMPolicyRequest request, User user, ThreadContext.StoredContext threadContext) throws Exception {
        SMPolicy smPolicy;
        GetRequest getRequest = new GetRequest(".opendistro-ism-config", request.getPolicyID());
        final AtomicReference responseRef = new AtomicReference();
        final AtomicReference exceptionRef = new AtomicReference();
        this.client.get(getRequest, (ActionListener)new ActionListener<GetResponse>(){

            public void onResponse(GetResponse getResponse) {
                responseRef.set(getResponse);
            }

            public void onFailure(Exception e) {
                exceptionRef.set(e);
            }
        });
        while (responseRef.get() == null && exceptionRef.get() == null) {
            Thread.sleep(10L);
        }
        if (exceptionRef.get() != null) {
            Exception e = (Exception)exceptionRef.get();
            if (e instanceof IndexNotFoundException) {
                throw new SkyliteStatusException("Snapshot management config index not found", RestStatus.NOT_FOUND, new Object[0]);
            }
            throw e;
        }
        GetResponse getResponse = (GetResponse)responseRef.get();
        if (!getResponse.isExists()) {
            throw new SkyliteStatusException("Snapshot management policy not found", RestStatus.NOT_FOUND, new Object[0]);
        }
        try {
            smPolicy = RestHandlerUtils.parseSMPolicy(getResponse);
        }
        catch (IllegalArgumentException e) {
            this.log.error("Error while parsing snapshot management policy " + request.getPolicyID(), (Throwable)e);
            throw new SkyliteStatusException("Snapshot management policy not found", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
        }
        SecurityUtils.verifyUserHasPermissionForResource(user, smPolicy.getUser(), this.filterByEnabled, "snapshot management policy", smPolicy.getPolicyName());
        this.log.debug("Get SM policy: " + String.valueOf(smPolicy));
        return new GetSMPolicyResponse(getResponse.getId(), getResponse.getVersion(), getResponse.getSeqNo(), getResponse.getPrimaryTerm(), smPolicy);
    }
}

