/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.snapshotmanagement.api.transport.index;

import io.lucenia.indexmanagement.snapshotmanagement.model.SMPolicy;
import io.skylite.common.action.ActionRequestValidationException;
import io.skylite.common.action.ValidateActions;
import io.skylite.core.action.DocWriteRequest;
import io.skylite.core.action.WriteRequest;
import io.skylite.core.action.index.IndexRequest;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import java.io.IOException;
import java.time.Instant;

public class IndexSMPolicyRequest
extends IndexRequest {
    private static final String SEQ_NUM_PRIMARY_TERM_UPDATE_ERROR = "Sequence number and primary term must be provided when updating a snapshot management policy";
    private SMPolicy policy;

    public IndexSMPolicyRequest(SMPolicy policy, boolean create, WriteRequest.RefreshPolicy refreshPolicy) {
        this.policy = policy;
        this.create(create);
        if (policy.getSeqNo() != -2L && policy.getPrimaryTerm() != 0L) {
            this.setIfSeqNo(policy.getSeqNo()).setIfPrimaryTerm(policy.getPrimaryTerm());
            this.policy = new SMPolicy.Builder(policy).lastUpdateTime(Instant.now()).build();
        }
        this.setRefreshPolicy(refreshPolicy);
    }

    public IndexSMPolicyRequest(StreamInput sin) throws IOException {
        super(sin);
        this.policy = new SMPolicy(sin);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.policy.writeTo(out);
    }

    public ActionRequestValidationException validate() {
        boolean invalidSeqNumPrimaryTerm;
        ActionRequestValidationException validationException = null;
        boolean bl = invalidSeqNumPrimaryTerm = this.ifSeqNo() == -2L || this.ifPrimaryTerm() == 0L;
        if (this.opType() != DocWriteRequest.OpType.CREATE && invalidSeqNumPrimaryTerm) {
            validationException = ValidateActions.addValidationError((String)SEQ_NUM_PRIMARY_TERM_UPDATE_ERROR, validationException);
        }
        return validationException;
    }

    public SMPolicy getPolicy() {
        return this.policy;
    }

    public void setPolicy(SMPolicy policy) {
        this.policy = policy;
    }
}

