/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.snapshotmanagement.api.transport.index;

import io.lucenia.indexmanagement.IndexManagementIndices;
import io.lucenia.indexmanagement.snapshotmanagement.api.transport.BaseTransportAction;
import io.lucenia.indexmanagement.snapshotmanagement.api.transport.index.IndexSMPolicyRequest;
import io.lucenia.indexmanagement.snapshotmanagement.api.transport.index.IndexSMPolicyResponse;
import io.lucenia.indexmanagement.snapshotmanagement.model.SMPolicy;
import io.lucenia.indexmanagement.snapshotmanagement.settings.SnapshotManagementSettings;
import io.lucenia.indexmanagement.util.IndexUtils;
import io.lucenia.indexmanagement.util.SecurityUtils;
import io.skylite.common.action.ActionListener;
import io.skylite.common.xcontent.XContentFactory;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.index.IndexRequest;
import io.skylite.core.action.index.IndexResponse;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.security.auth.User;
import io.skylite.core.settings.Settings;
import io.skylite.core.transport.TransportService;
import io.skylite.core.xcontent.ToXContent;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportIndexSMPolicyAction
extends BaseTransportAction<IndexSMPolicyRequest, IndexSMPolicyResponse> {
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final IndexManagementIndices indexManagementIndices;
    private final ClusterService clusterService;
    private final Settings settings;
    private volatile boolean filterByEnabled;

    @Inject
    public TransportIndexSMPolicyAction(Client client, TransportService transportService, IndexManagementIndices indexManagementIndices, ActionFilters actionFilters, ClusterService clusterService, Settings settings) {
        super("cluster:admin/lucenia/snapshot_management/policy/write", transportService, client, actionFilters, IndexSMPolicyRequest::new);
        this.indexManagementIndices = indexManagementIndices;
        this.clusterService = clusterService;
        this.settings = settings;
        this.filterByEnabled = (Boolean)SnapshotManagementSettings.FILTER_BY_BACKEND_ROLES.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SnapshotManagementSettings.FILTER_BY_BACKEND_ROLES, it -> {
            this.filterByEnabled = it;
        });
    }

    @Override
    protected IndexSMPolicyResponse executeRequest(IndexSMPolicyRequest request, User user, ThreadContext.StoredContext threadContext) throws Exception {
        SecurityUtils.validateUserConfiguration(user, this.filterByEnabled);
        if (this.indexManagementIndices.checkAndUpdateIMConfigIndex(this.log).get().booleanValue()) {
            this.log.info("Successfully created or updated .opendistro-ism-config with newest mappings.");
        }
        return this.indexSMPolicy(request, user);
    }

    private IndexSMPolicyResponse indexSMPolicy(IndexSMPolicyRequest request, User user) throws Exception {
        SMPolicy policy = new SMPolicy.Builder(request.getPolicy()).schemaVersion(IndexUtils.getIndexManagementConfigSchemaVersion()).user(user).build();
        IndexSMPolicyRequest indexReq = (IndexSMPolicyRequest)((IndexRequest)request.index(".opendistro-ism-config")).source(policy.toXContent(XContentFactory.jsonBuilder(), ToXContent.EMPTY_PARAMS)).id(policy.getId()).routing(policy.getId());
        final AtomicReference responseRef = new AtomicReference();
        final AtomicReference exceptionRef = new AtomicReference();
        this.client.index((IndexRequest)indexReq, (ActionListener)new ActionListener<IndexResponse>(){

            public void onResponse(IndexResponse indexResponse) {
                responseRef.set(indexResponse);
            }

            public void onFailure(Exception e) {
                exceptionRef.set(e);
            }
        });
        while (responseRef.get() == null && exceptionRef.get() == null) {
            Thread.sleep(10L);
        }
        if (exceptionRef.get() != null) {
            throw (Exception)exceptionRef.get();
        }
        IndexResponse indexRes = (IndexResponse)responseRef.get();
        return new IndexSMPolicyResponse(indexRes.getId(), indexRes.getVersion(), indexRes.getSeqNo(), indexRes.getPrimaryTerm(), policy, indexRes.status());
    }
}

