/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.snapshotmanagement.api.transport.stop;

import io.lucenia.indexmanagement.snapshotmanagement.api.transport.BaseTransportAction;
import io.lucenia.indexmanagement.snapshotmanagement.api.transport.stop.StopSMRequest;
import io.lucenia.indexmanagement.snapshotmanagement.model.SMPolicy;
import io.lucenia.indexmanagement.snapshotmanagement.settings.SnapshotManagementSettings;
import io.lucenia.indexmanagement.snapshotmanagement.util.RestHandlerUtils;
import io.lucenia.indexmanagement.util.SecurityUtils;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.DocWriteResponse;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.action.update.UpdateRequest;
import io.skylite.core.action.update.UpdateResponse;
import io.skylite.core.client.Client;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.index.engine.VersionConflictEngineException;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.security.auth.User;
import io.skylite.core.settings.Settings;
import io.skylite.core.transport.TransportService;
import java.time.Instant;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransportStopSMAction
extends BaseTransportAction<StopSMRequest, AcknowledgedResponse> {
    private static final String CONFLICT_EXCEPTION_MESSAGE = "Failed while trying to disable SM Policy due to a concurrent update, please try again";
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final ClusterService clusterService;
    private final Settings settings;
    private volatile boolean filterByEnabled;

    @Inject
    public TransportStopSMAction(Client client, TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, Settings settings) {
        super("cluster:admin/lucenia/snapshot_management/policy/stop", transportService, client, actionFilters, StopSMRequest::new);
        this.clusterService = clusterService;
        this.settings = settings;
        this.filterByEnabled = (Boolean)SnapshotManagementSettings.FILTER_BY_BACKEND_ROLES.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SnapshotManagementSettings.FILTER_BY_BACKEND_ROLES, it -> {
            this.filterByEnabled = it;
        });
    }

    @Override
    protected AcknowledgedResponse executeRequest(StopSMRequest request, User user, ThreadContext.StoredContext threadContext) throws Exception {
        SMPolicy smPolicy;
        final CompletableFuture future = new CompletableFuture();
        RestHandlerUtils.getSMPolicy(this.client, request.getId(), new ActionListener<SMPolicy>(){

            public void onResponse(SMPolicy policy) {
                future.complete(policy);
            }

            public void onFailure(Exception e) {
                future.completeExceptionally(e);
            }
        });
        try {
            smPolicy = (SMPolicy)future.get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SkyliteStatusException) {
                throw (SkyliteStatusException)cause;
            }
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw new RuntimeException(cause);
        }
        SecurityUtils.verifyUserHasPermissionForResource(user, smPolicy.getUser(), this.filterByEnabled, "snapshot management policy", smPolicy.getPolicyName());
        if (!smPolicy.isEnabled()) {
            this.log.debug("Snapshot management policy is already disabled");
            return new AcknowledgedResponse(true);
        }
        return new AcknowledgedResponse(this.disableSMPolicy(request));
    }

    private boolean disableSMPolicy(StopSMRequest updateRequest) throws Exception {
        long now = Instant.now().toEpochMilli();
        UpdateRequest updateReq = new UpdateRequest(".opendistro-ism-config", updateRequest.getId());
        HashMap<String, Comparable<Boolean>> disabledFields = new HashMap<String, Comparable<Boolean>>();
        disabledFields.put("enabled", Boolean.valueOf(false));
        disabledFields.put("enabled_time", null);
        disabledFields.put("last_updated_time", Long.valueOf(now));
        HashMap<String, HashMap<String, Comparable<Boolean>>> doc = new HashMap<String, HashMap<String, Comparable<Boolean>>>();
        doc.put("sm_policy", disabledFields);
        updateReq.doc(doc);
        final AtomicReference responseRef = new AtomicReference();
        final AtomicReference exceptionRef = new AtomicReference();
        this.client.update(updateReq, (ActionListener)new ActionListener<UpdateResponse>(){

            public void onResponse(UpdateResponse updateResponse) {
                responseRef.set(updateResponse);
            }

            public void onFailure(Exception e) {
                exceptionRef.set(e);
            }
        });
        while (responseRef.get() == null && exceptionRef.get() == null) {
            Thread.sleep(10L);
        }
        if (exceptionRef.get() != null) {
            Exception e = (Exception)exceptionRef.get();
            if (e instanceof VersionConflictEngineException) {
                this.log.error("VersionConflictEngineException while trying to disable snapshot management policy id [" + updateRequest.getId() + "]: " + String.valueOf(e));
                throw new SkyliteStatusException(CONFLICT_EXCEPTION_MESSAGE, RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
            }
            this.log.error("Failed trying to disable snapshot management policy id [" + updateRequest.getId() + "]: " + String.valueOf(e));
            throw new SkyliteStatusException("Failed while trying to disable SM Policy", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]);
        }
        UpdateResponse updateResponse = (UpdateResponse)responseRef.get();
        return updateResponse.getResult() == DocWriteResponse.Result.UPDATED;
    }
}

