/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.snapshotmanagement.engine;

import io.lucenia.indexmanagement.IndexManagementIndices;
import io.lucenia.indexmanagement.common.retry.RetryUtils;
import io.lucenia.indexmanagement.luceniaapi.IndexManagementSecurityContext;
import io.lucenia.indexmanagement.snapshotmanagement.SMUtils;
import io.lucenia.indexmanagement.snapshotmanagement.SnapshotManagementException;
import io.lucenia.indexmanagement.snapshotmanagement.engine.states.SMResult;
import io.lucenia.indexmanagement.snapshotmanagement.engine.states.SMState;
import io.lucenia.indexmanagement.snapshotmanagement.engine.states.State;
import io.lucenia.indexmanagement.snapshotmanagement.engine.states.WorkflowType;
import io.lucenia.indexmanagement.snapshotmanagement.model.SMMetadata;
import io.lucenia.indexmanagement.snapshotmanagement.model.SMPolicy;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.bulk.BackoffPolicy;
import io.skylite.core.action.clustermanager.AcknowledgedResponse;
import io.skylite.core.action.index.IndexResponse;
import io.skylite.core.client.Client;
import io.skylite.core.index.engine.VersionConflictEngineException;
import io.skylite.core.settings.Settings;
import io.skylite.core.threadpool.ThreadPool;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SMStateMachine {
    private static final int MAX_NUMBER_OF_RETRIES = 3;
    private static final long EXPONENTIAL_BACKOFF_MILLIS = 250L;
    private final Logger log = LogManager.getLogger(this.getClass());
    private final Client client;
    private final SMPolicy job;
    private SMMetadata metadata;
    private final Settings settings;
    private final ThreadPool threadPool;
    private final IndexManagementIndices indicesManager;
    private SMState currentState;
    private long metadataSeqNo;
    private long metadataPrimaryTerm;
    private final BackoffPolicy updateMetaDataRetryPolicy = BackoffPolicy.exponentialBackoff((TimeValue)TimeValue.timeValueMillis((long)250L), (int)3);

    public SMStateMachine(Client client, SMPolicy job, SMMetadata metadata, Settings settings, ThreadPool threadPool, IndexManagementIndices indicesManager) {
        this.client = client;
        this.job = job;
        this.metadata = metadata;
        this.settings = settings;
        this.threadPool = threadPool;
        this.indicesManager = indicesManager;
        this.metadataSeqNo = metadata.getSeqNo();
        this.metadataPrimaryTerm = metadata.getPrimaryTerm();
    }

    public SMStateMachine currentState(SMState currentState) {
        this.currentState = currentState;
        return this;
    }

    public void next(Map<SMState, List<SMState>> transitions, ActionListener<SMStateMachine> listener) {
        try {
            this.processNextState(transitions, listener, this.currentState);
        }
        catch (Exception ex) {
            this.handleUncaughtException(ex, listener);
        }
    }

    private void processNextState(Map<SMState, List<SMState>> transitions, ActionListener<SMStateMachine> listener, SMState currentStateToProcess) {
        List<SMState> nextStates = transitions.get((Object)currentStateToProcess);
        if (nextStates == null) {
            this.log.error("No next states for current state [" + String.valueOf((Object)currentStateToProcess) + "].");
            listener.onResponse((Object)this);
            return;
        }
        SMState prevState = this.currentState;
        this.processStateList(transitions, listener, nextStates, 0, prevState, null);
    }

    private void processStateList(Map<SMState, List<SMState>> transitions, ActionListener<SMStateMachine> listener, List<SMState> nextStates, int index, SMState prevState, SMResult lastResult) {
        SMState nextState;
        if (index >= nextStates.size()) {
            if (lastResult instanceof SMResult.Next && this.currentState.getInstance().isContinuous()) {
                this.processNextState(transitions, listener, this.currentState);
            } else {
                listener.onResponse((Object)this);
            }
            return;
        }
        this.currentState = nextState = nextStates.get(index);
        this.log.debug("Start executing " + String.valueOf((Object)this.currentState) + ".");
        this.log.debug("User and roles string from thread context: " + String.valueOf(this.threadPool.getThreadContext().getTransient("_opendistro_security_user_info")));
        try (IndexManagementSecurityContext context = new IndexManagementSecurityContext(this.job.getId(), this.settings, this.threadPool.getThreadContext(), this.job.getUser());){
            this.log.debug("User and roles string from thread context: " + String.valueOf(this.threadPool.getThreadContext().getTransient("_opendistro_security_user_info")));
            this.currentState.getInstance().execute(this, (ActionListener<State.Result>)ActionListener.wrap(result -> {
                this.log.debug("User and roles string from thread context: " + String.valueOf(this.threadPool.getThreadContext().getTransient("_opendistro_security_user_info")));
                this.handleStateResult(transitions, listener, nextStates, index, prevState, (SMResult)result);
            }, ex -> {
                this.log.error("Error executing state " + String.valueOf((Object)this.currentState), (Throwable)ex);
                this.handleUncaughtException((Exception)ex, listener);
            }));
        }
        catch (Exception ex2) {
            this.handleUncaughtException(ex2, listener);
        }
    }

    private void handleStateResult(Map<SMState, List<SMState>> transitions, ActionListener<SMStateMachine> listener, List<SMState> nextStates, int index, SMState prevState, SMResult result) {
        if (result instanceof SMResult.Next) {
            SMResult.Next nextResult = (SMResult.Next)result;
            this.log.info("State [" + String.valueOf((Object)this.currentState) + "] has finished.");
            this.updateMetadata(nextResult.getMetadataToSave().setCurrentState(this.currentState).resetRetry().build(), (ActionListener<Void>)ActionListener.wrap(v -> {
                if (this.currentState.getInstance().isContinuous()) {
                    this.processNextState(transitions, listener, this.currentState);
                } else {
                    listener.onResponse((Object)this);
                }
            }, ex -> this.handleUncaughtException((Exception)ex, listener)));
        } else if (result instanceof SMResult.Stay) {
            SMResult.Stay stayResult = (SMResult.Stay)result;
            this.log.debug("State [" + String.valueOf((Object)this.currentState) + "] has not finished.");
            this.updateMetadata(stayResult.getMetadataToSave().setCurrentState(prevState).resetRetry().build(), (ActionListener<Void>)ActionListener.wrap(v -> this.processStateList(transitions, listener, nextStates, index + 1, prevState, result), ex -> this.handleUncaughtException((Exception)ex, listener)));
        } else if (result instanceof SMResult.Fail) {
            SMResult.Fail failResult = (SMResult.Fail)result;
            this.handleFailureNotification(failResult);
            SMMetadata.Builder metadataBuilder = Boolean.TRUE.equals(failResult.getForceReset()) ? failResult.getMetadataToSave().resetWorkflow() : this.handleRetry(failResult, prevState);
            this.updateMetadata(metadataBuilder.build(), (ActionListener<Void>)ActionListener.wrap(v -> listener.onResponse((Object)this), ex -> this.handleUncaughtException((Exception)ex, listener)));
        } else {
            listener.onResponse((Object)this);
        }
    }

    private void handleFailureNotification(SMResult.Fail result) {
        SMMetadata.WorkflowMetadata workflowMetadata = result.getMetadataToSave().getWorkflowMetadata();
        if (workflowMetadata != null && workflowMetadata.getLatestExecution() != null) {
            String message;
            String string = message = workflowMetadata.getLatestExecution().getInfo() != null ? workflowMetadata.getLatestExecution().getInfo().getMessage() : null;
            if (message != null) {
                if (workflowMetadata.getLatestExecution().getStatus() == SMMetadata.LatestExecution.Status.TIME_LIMIT_EXCEEDED) {
                    SMUtils.sendTimeLimitExceededNotification(this.job.getNotificationConfig(), this.client, this.job.getPolicyName(), message, this.job.getUser(), this.log);
                } else {
                    SMUtils.sendFailureNotification(this.job.getNotificationConfig(), this.client, this.job.getPolicyName(), message, this.job.getUser(), this.log);
                }
            }
        }
    }

    private SMMetadata.Builder handleRetry(SMResult.Fail result, SMState prevState) {
        SMMetadata.Builder metadataBuilder = result.getMetadataToSave().setCurrentState(prevState);
        SMMetadata md = result.getMetadataToSave().build();
        SMMetadata.Retry retry = null;
        if (result.getWorkflowType() == WorkflowType.CREATION && md.getCreation() != null) {
            retry = md.getCreation().getRetry();
        } else if (result.getWorkflowType() == WorkflowType.DELETION && md.getDeletion() != null) {
            retry = md.getDeletion().getRetry();
        }
        if (retry == null) {
            this.log.warn("Starting to retry state [" + String.valueOf((Object)this.currentState) + "], remaining count 3.");
            metadataBuilder.setRetry(3);
        } else {
            int retryCount = retry.getCount() - 1;
            if (retryCount > 0) {
                this.log.warn("Retrying state [" + String.valueOf((Object)this.currentState) + "], remaining count " + retryCount + ".");
                metadataBuilder.setRetry(retryCount);
            } else {
                String errorMessage = "Retry count exhausted for state [" + String.valueOf((Object)this.currentState) + "], reset workflow " + String.valueOf((Object)result.getWorkflowType()) + ".";
                this.log.warn(errorMessage);
                metadataBuilder.setLatestExecution(SMMetadata.LatestExecution.Status.FAILED, false, null, false, null, Instant.now()).resetWorkflow();
            }
        }
        return metadataBuilder;
    }

    public void updateMetadata(SMMetadata md, ActionListener<Void> listener) {
        this.indicesManager.checkAndUpdateIMConfigIndex((ActionListener<AcknowledgedResponse>)ActionListener.wrap(v -> {
            try {
                this.log.debug("Update metadata: " + String.valueOf(md));
                if (md.equals(this.metadata)) {
                    this.log.debug("Metadata not changed, so don't need to update");
                    listener.onResponse(null);
                    return;
                }
                AtomicReference<Long> newSeqNo = new AtomicReference<Long>(this.metadataSeqNo);
                AtomicReference<Long> newPrimaryTerm = new AtomicReference<Long>(this.metadataPrimaryTerm);
                RetryUtils.retry(this.log, this.updateMetaDataRetryPolicy, retryListener -> SMUtils.indexMetadata(this.client, md, this.job.getId(), (Long)newSeqNo.get(), (Long)newPrimaryTerm.get(), false, (ActionListener<IndexResponse>)ActionListener.wrap(res -> {
                    newSeqNo.set(res.getSeqNo());
                    newPrimaryTerm.set(res.getPrimaryTerm());
                    retryListener.onResponse(res);
                }, arg_0 -> ((ActionListener)retryListener).onFailure(arg_0))), ActionListener.wrap(res -> {
                    this.metadataSeqNo = (Long)newSeqNo.get();
                    this.metadataPrimaryTerm = (Long)newPrimaryTerm.get();
                    this.metadata = md;
                    listener.onResponse(null);
                }, ex -> {
                    Exception unwrappedException = (Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)ex);
                    if (unwrappedException instanceof VersionConflictEngineException) {
                        this.log.error("Version conflict exception while updating metadata.", (Throwable)ex);
                        listener.onResponse(null);
                        return;
                    }
                    SnapshotManagementException smEx = new SnapshotManagementException(SnapshotManagementException.ExceptionKey.METADATA_INDEXING_FAILURE, (Exception)ex);
                    this.log.error(smEx.getMessage(), (Throwable)ex);
                    listener.onFailure((Exception)((Object)smEx));
                }));
            }
            catch (Exception ex2) {
                this.log.error("Error updating metadata", (Throwable)ex2);
                listener.onFailure(ex2);
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    public void handlePolicyChange(ActionListener<SMStateMachine> listener) {
        if (this.job.getSeqNo() > this.metadata.getPolicySeqNo() || this.job.getPrimaryTerm() > this.metadata.getPolicyPrimaryTerm()) {
            SMPolicy.Deletion deletion;
            Instant now = Instant.now();
            SMMetadata.Builder metadataToSave = new SMMetadata.Builder(this.metadata).setSeqNoPrimaryTerm(this.job.getSeqNo(), this.job.getPrimaryTerm());
            SMPolicy.Creation creation = this.job.getCreation();
            if (creation != null) {
                metadataToSave.setNextCreationTime(creation.getSchedule().getNextExecutionTime(now));
            }
            if ((deletion = this.job.getDeletion()) != null) {
                metadataToSave.setNextDeletionTime(deletion.getSchedule().getNextExecutionTime(now));
            }
            this.updateMetadata(metadataToSave.build(), (ActionListener<Void>)ActionListener.wrap(v -> listener.onResponse((Object)this), arg_0 -> listener.onFailure(arg_0)));
        } else {
            listener.onResponse((Object)this);
        }
    }

    private void handleUncaughtException(Exception ex, ActionListener<SMStateMachine> listener) {
        String message = "There was an exception at " + String.valueOf(Instant.now()) + " while executing Snapshot Management policy " + this.job.getPolicyName() + ", please check logs.";
        SMUtils.sendFailureNotification(this.job.getNotificationConfig(), this.client, this.job.getPolicyName(), message, this.job.getUser(), this.log);
        if (ex instanceof SnapshotManagementException && ((SnapshotManagementException)((Object)ex)).getExKey() == SnapshotManagementException.ExceptionKey.METADATA_INDEXING_FAILURE) {
            listener.onResponse((Object)this);
            return;
        }
        this.log.error("Uncaught snapshot management runtime exception.", (Throwable)ex);
        listener.onResponse((Object)this);
    }

    public Client getClient() {
        return this.client;
    }

    public SMPolicy getJob() {
        return this.job;
    }

    public SMMetadata getMetadata() {
        return this.metadata;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public IndexManagementIndices getIndicesManager() {
        return this.indicesManager;
    }

    public Logger getLog() {
        return this.log;
    }

    public SMState getCurrentState() {
        return this.currentState;
    }
}

