/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.snapshotmanagement.engine.states;

import io.lucenia.indexmanagement.snapshotmanagement.engine.states.State;
import io.lucenia.indexmanagement.snapshotmanagement.engine.states.creation.CreatingState;
import io.lucenia.indexmanagement.snapshotmanagement.engine.states.creation.CreationConditionMetState;
import io.lucenia.indexmanagement.snapshotmanagement.engine.states.creation.CreationFinishedState;
import io.lucenia.indexmanagement.snapshotmanagement.engine.states.creation.CreationStartState;
import io.lucenia.indexmanagement.snapshotmanagement.engine.states.deletion.DeletingState;
import io.lucenia.indexmanagement.snapshotmanagement.engine.states.deletion.DeletionConditionMetState;
import io.lucenia.indexmanagement.snapshotmanagement.engine.states.deletion.DeletionFinishedState;
import io.lucenia.indexmanagement.snapshotmanagement.engine.states.deletion.DeletionStartState;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum SMState {
    CREATION_START(CreationStartState.INSTANCE),
    CREATION_CONDITION_MET(CreationConditionMetState.INSTANCE),
    CREATING(CreatingState.INSTANCE),
    CREATION_FINISHED(CreationFinishedState.INSTANCE),
    DELETION_START(DeletionStartState.INSTANCE),
    DELETION_CONDITION_MET(DeletionConditionMetState.INSTANCE),
    DELETING(DeletingState.INSTANCE),
    DELETION_FINISHED(DeletionFinishedState.INSTANCE);

    private final State instance;
    public static final Map<SMState, List<SMState>> CREATION_TRANSITIONS;
    public static final Map<SMState, List<SMState>> DELETION_TRANSITIONS;

    private SMState(State instance) {
        this.instance = instance;
    }

    public State getInstance() {
        return this.instance;
    }

    static {
        HashMap<SMState, List<SMState>> creationTransitions = new HashMap<SMState, List<SMState>>();
        creationTransitions.put(CREATION_START, Collections.singletonList(CREATION_CONDITION_MET));
        creationTransitions.put(CREATION_CONDITION_MET, Collections.singletonList(CREATING));
        creationTransitions.put(CREATING, Collections.singletonList(CREATION_FINISHED));
        creationTransitions.put(CREATION_FINISHED, Collections.singletonList(CREATION_START));
        CREATION_TRANSITIONS = Collections.unmodifiableMap(creationTransitions);
        HashMap<SMState, List<SMState>> deletionTransitions = new HashMap<SMState, List<SMState>>();
        deletionTransitions.put(DELETION_START, Collections.singletonList(DELETION_CONDITION_MET));
        deletionTransitions.put(DELETION_CONDITION_MET, Collections.singletonList(DELETING));
        deletionTransitions.put(DELETING, Collections.singletonList(DELETION_FINISHED));
        deletionTransitions.put(DELETION_FINISHED, Collections.singletonList(DELETION_START));
        DELETION_TRANSITIONS = Collections.unmodifiableMap(deletionTransitions);
    }
}

