/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.snapshotmanagement.engine.states.creation;

import io.lucenia.indexmanagement.snapshotmanagement.SMUtils;
import io.lucenia.indexmanagement.snapshotmanagement.engine.SMStateMachine;
import io.lucenia.indexmanagement.snapshotmanagement.engine.states.SMResult;
import io.lucenia.indexmanagement.snapshotmanagement.engine.states.State;
import io.lucenia.indexmanagement.snapshotmanagement.engine.states.WorkflowType;
import io.lucenia.indexmanagement.snapshotmanagement.model.SMMetadata;
import io.lucenia.indexmanagement.snapshotmanagement.model.SMPolicy;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.admin.cluster.snapshots.create.CreateSnapshotRequest;
import io.skylite.core.client.Client;
import io.skylite.core.snapshots.ConcurrentSnapshotExecutionException;
import io.skylite.core.snapshots.SnapshotInfo;
import io.skylite.core.transport.RemoteTransportException;
import java.time.Instant;
import java.util.List;
import org.apache.logging.log4j.Logger;

public class CreatingState
implements State {
    public static final CreatingState INSTANCE = new CreatingState();
    public static final String CONCURRENT_SNAPSHOT_MESSAGE = "Concurrent snapshot exception happened, retrying...";

    private CreatingState() {
    }

    @Override
    public boolean isContinuous() {
        return false;
    }

    @Override
    public void execute(SMStateMachine context, ActionListener<State.Result> listener) {
        String snapshotName;
        Client client = context.getClient();
        SMPolicy job = context.getJob();
        SMMetadata metadata = context.getMetadata();
        Logger log = context.getLog();
        SMMetadata.Builder metadataBuilder = new SMMetadata.Builder(metadata).workflow(WorkflowType.CREATION);
        if (job.getCreation() == null) {
            log.warn("Policy creation config becomes null before trying to create snapshot. Reset.");
            listener.onResponse((Object)new SMResult.Fail(metadataBuilder.resetCreation(), WorkflowType.CREATION, true));
            return;
        }
        String string = snapshotName = metadata.getCreation() != null && metadata.getCreation().getStarted() != null ? metadata.getCreation().getStarted().get(0) : null;
        if (snapshotName == null) {
            SMUtils.getSnapshots(client, job, job.getPolicyName() + "*", metadataBuilder, log, null, "Caught exception while getting snapshots to decide if snapshot has been created in previous execution period.", (ActionListener<SMUtils.GetSnapshotsResult>)ActionListener.wrap(getSnapshotsResult -> {
                String existingSnapshotName;
                SMMetadata.Builder updatedMetadataBuilder = getSnapshotsResult.getMetadataBuilder();
                if (getSnapshotsResult.isFailed()) {
                    listener.onResponse((Object)new SMResult.Fail(updatedMetadataBuilder, WorkflowType.CREATION));
                    return;
                }
                List<SnapshotInfo> getSnapshots = getSnapshotsResult.getSnapshots();
                Instant latestExecutionStartTime = (Instant)job.getCreation().getSchedule().getPeriodStartingAt(null).v1();
                String string = existingSnapshotName = latestExecutionStartTime != null ? this.checkCreatedSnapshots(latestExecutionStartTime, getSnapshots) : null;
                if (existingSnapshotName != null) {
                    log.info("Already created snapshot [" + existingSnapshotName + "] during this execution period starting at " + String.valueOf(latestExecutionStartTime) + ".");
                    updatedMetadataBuilder.setLatestExecution(SMMetadata.LatestExecution.Status.IN_PROGRESS, false, null, false, null, null).setCreationStarted(existingSnapshotName);
                    listener.onResponse((Object)new SMResult.Next(updatedMetadataBuilder));
                    return;
                }
                this.createSnapshot(client, job, updatedMetadataBuilder, log, listener);
            }, arg_0 -> listener.onFailure(arg_0)));
        } else {
            this.createSnapshot(client, job, metadataBuilder, log, listener);
        }
    }

    private void createSnapshot(Client client, SMPolicy job, SMMetadata.Builder metadataBuilder, Logger log, ActionListener<State.Result> listener) {
        String snapshotName = SMUtils.generateSnapshotName(job);
        try {
            CreateSnapshotRequest req = new CreateSnapshotRequest((String)job.getSnapshotConfig().get("repository"), snapshotName).source(SMUtils.addSMPolicyInSnapshotMetadata(job.getSnapshotConfig(), job.getPolicyName())).waitForCompletion(false);
            client.admin().cluster().createSnapshot(req, ActionListener.wrap(response -> {
                metadataBuilder.setLatestExecution(SMMetadata.LatestExecution.Status.IN_PROGRESS, true, this.getSnapshotCreationStartedMessage(snapshotName), false, null, null).setCreationStarted(snapshotName);
                listener.onResponse((Object)new SMResult.Next(metadataBuilder));
            }, ex -> {
                Exception unwrappedException = ex instanceof RemoteTransportException ? (Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)ex) : ex;
                listener.onResponse((Object)this.handleException(unwrappedException, snapshotName, metadataBuilder, log));
            }));
        }
        catch (Exception ex2) {
            listener.onResponse((Object)this.handleException(ex2, snapshotName, metadataBuilder, log));
        }
    }

    private SMResult handleException(Exception ex, String snapshotName, SMMetadata.Builder metadataBuilder, Logger log) {
        if (ex instanceof ConcurrentSnapshotExecutionException) {
            log.error(CONCURRENT_SNAPSHOT_MESSAGE, (Throwable)ex);
            metadataBuilder.setLatestExecution(SMMetadata.LatestExecution.Status.RETRYING, true, CONCURRENT_SNAPSHOT_MESSAGE, false, null, null);
            return new SMResult.Stay(metadataBuilder);
        }
        log.error(this.getCreateSnapshotErrorMessage(snapshotName), (Throwable)ex);
        metadataBuilder.setLatestExecution(SMMetadata.LatestExecution.Status.RETRYING, true, this.getCreateSnapshotErrorMessage(snapshotName), true, ex, null);
        return new SMResult.Fail(metadataBuilder, WorkflowType.CREATION);
    }

    private String getSnapshotCreationStartedMessage(String snapshotName) {
        return "Snapshot " + snapshotName + " creation has been started and waiting for completion.";
    }

    private String getCreateSnapshotErrorMessage(String snapshotName) {
        return "Caught exception while creating snapshot " + snapshotName + ".";
    }

    private String checkCreatedSnapshots(Instant lastExecutionTime, List<SnapshotInfo> snapshots) {
        if (snapshots.isEmpty()) {
            return null;
        }
        snapshots.sort((a, b) -> Long.compare(a.startTime(), b.startTime()));
        int i = snapshots.size() - 1;
        if (i >= 0) {
            if (!Instant.ofEpochMilli(snapshots.get(i).startTime()).isBefore(lastExecutionTime)) {
                return snapshots.get(i).snapshotId().getName();
            }
            return null;
        }
        return null;
    }
}

