/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.snapshotmanagement.engine.states.creation;

import io.lucenia.indexmanagement.snapshotmanagement.SMUtils;
import io.lucenia.indexmanagement.snapshotmanagement.engine.SMStateMachine;
import io.lucenia.indexmanagement.snapshotmanagement.engine.states.SMResult;
import io.lucenia.indexmanagement.snapshotmanagement.engine.states.State;
import io.lucenia.indexmanagement.snapshotmanagement.engine.states.WorkflowType;
import io.lucenia.indexmanagement.snapshotmanagement.model.SMMetadata;
import io.lucenia.indexmanagement.snapshotmanagement.model.SMPolicy;
import io.skylite.common.action.ActionListener;
import io.skylite.core.jobs.schedule.Schedule;
import java.time.Instant;
import org.apache.logging.log4j.Logger;

public class CreationConditionMetState
implements State {
    public static final CreationConditionMetState INSTANCE = new CreationConditionMetState();

    private CreationConditionMetState() {
    }

    @Override
    public boolean isContinuous() {
        return true;
    }

    @Override
    public void execute(SMStateMachine context, ActionListener<State.Result> listener) {
        Instant nextCreationTime;
        SMPolicy job = context.getJob();
        SMMetadata metadata = context.getMetadata();
        Logger log = context.getLog();
        SMMetadata.Builder metadataBuilder = new SMMetadata.Builder(metadata).workflow(WorkflowType.CREATION);
        if (job.getCreation() == null) {
            log.warn("Policy creation config becomes null before trying to create snapshot. Reset.");
            listener.onResponse((Object)new SMResult.Fail(metadataBuilder.resetCreation(), WorkflowType.CREATION, true));
            return;
        }
        if (metadata.getCreation() == null) {
            Instant nextTime = job.getCreation().getSchedule().getNextExecutionTime(Instant.now());
            if (nextTime != null) {
                metadataBuilder.setNextCreationTime(nextTime);
            }
            nextCreationTime = nextTime;
        } else {
            nextCreationTime = metadata.getCreation().getTrigger().getTime();
        }
        if (nextCreationTime != null) {
            Schedule schedule = job.getCreation().getSchedule();
            SMUtils.UpdateNextExecutionTimeResult updateNextTimeResult = SMUtils.tryUpdatingNextExecutionTime(metadataBuilder, nextCreationTime, schedule, WorkflowType.CREATION, log);
            if (!updateNextTimeResult.isUpdated()) {
                listener.onResponse((Object)new SMResult.Stay(metadataBuilder));
                return;
            }
            metadataBuilder = updateNextTimeResult.getMetadataBuilder();
        }
        listener.onResponse((Object)new SMResult.Next(metadataBuilder));
    }
}

