/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.snapshotmanagement.engine.states.creation;

import io.lucenia.indexmanagement.snapshotmanagement.SMUtils;
import io.lucenia.indexmanagement.snapshotmanagement.SnapshotManagementException;
import io.lucenia.indexmanagement.snapshotmanagement.engine.SMStateMachine;
import io.lucenia.indexmanagement.snapshotmanagement.engine.states.SMResult;
import io.lucenia.indexmanagement.snapshotmanagement.engine.states.State;
import io.lucenia.indexmanagement.snapshotmanagement.engine.states.WorkflowType;
import io.lucenia.indexmanagement.snapshotmanagement.model.SMMetadata;
import io.lucenia.indexmanagement.snapshotmanagement.model.SMPolicy;
import io.skylite.common.action.ActionListener;
import io.skylite.core.client.Client;
import io.skylite.core.snapshots.SnapshotInfo;
import io.skylite.core.snapshots.SnapshotState;
import java.time.Instant;
import java.util.List;
import org.apache.logging.log4j.Logger;

public class CreationFinishedState
implements State {
    public static final CreationFinishedState INSTANCE = new CreationFinishedState();

    private CreationFinishedState() {
    }

    @Override
    public boolean isContinuous() {
        return true;
    }

    @Override
    public void execute(SMStateMachine context, ActionListener<State.Result> listener) {
        Client client = context.getClient();
        SMPolicy job = context.getJob();
        SMMetadata metadata = context.getMetadata();
        Logger log = context.getLog();
        SMMetadata.Builder metadataBuilder = new SMMetadata.Builder(metadata).workflow(WorkflowType.CREATION);
        if (metadata.getCreation() == null || metadata.getCreation().getStarted() == null || metadata.getCreation().getStarted().isEmpty()) {
            listener.onResponse((Object)new SMResult.Next(metadataBuilder));
            return;
        }
        String snapshotName = metadata.getCreation().getStarted().get(0);
        if (metadata.getCreation().getLatestExecution() == null) {
            log.error("latest_execution is null while checking if snapshot [" + snapshotName + "] creation has finished. Reset.");
            metadataBuilder.resetWorkflow();
            listener.onResponse((Object)new SMResult.Next(metadataBuilder));
            return;
        }
        SMUtils.getSnapshots(client, job, snapshotName, metadataBuilder, log, this.getSnapshotMissingMessageInCreationWorkflow(snapshotName), this.getSnapshotExceptionInCreationWorkflow(snapshotName), (ActionListener<SMUtils.GetSnapshotsResult>)ActionListener.wrap(getSnapshotsResult -> {
            SMMetadata.Builder updatedMetadataBuilder = getSnapshotsResult.getMetadataBuilder();
            if (getSnapshotsResult.isFailed()) {
                listener.onResponse((Object)new SMResult.Fail(updatedMetadataBuilder, WorkflowType.CREATION));
                return;
            }
            List<SnapshotInfo> getSnapshots = getSnapshotsResult.getSnapshots();
            if (getSnapshots.isEmpty()) {
                updatedMetadataBuilder.setLatestExecution(SMMetadata.LatestExecution.Status.SUCCESS, true, this.getSnapshotMissingMessageInCreationWorkflow(snapshotName), false, null, Instant.now()).resetWorkflow();
                listener.onResponse((Object)new SMResult.Next(updatedMetadataBuilder));
                return;
            }
            SnapshotInfo snapshot = getSnapshots.get(0);
            SnapshotState state = snapshot.state();
            if (state == SnapshotState.SUCCESS) {
                String creationMessage = this.getSnapshotCreationSucceedMessage(snapshotName);
                updatedMetadataBuilder.setLatestExecution(SMMetadata.LatestExecution.Status.SUCCESS, true, creationMessage, false, null, Instant.now()).setCreationStarted(null);
                SMUtils.sendCreationNotification(job.getNotificationConfig(), client, job.getPolicyName(), creationMessage, job.getUser(), log);
                this.checkAndUpdateNextCreationTime(job, metadata, updatedMetadataBuilder, log);
                listener.onResponse((Object)new SMResult.Next(updatedMetadataBuilder));
            } else if (state == SnapshotState.IN_PROGRESS) {
                if (job.getCreation() != null && job.getCreation().getTimeLimit() != null && SMUtils.isExceed(job.getCreation().getTimeLimit(), metadata.getCreation().getLatestExecution().getStartTime())) {
                    listener.onResponse((Object)SMUtils.timeLimitExceeded(job.getCreation().getTimeLimit(), updatedMetadataBuilder, WorkflowType.CREATION, log));
                    return;
                }
                this.checkAndUpdateNextCreationTime(job, metadata, updatedMetadataBuilder, log);
                listener.onResponse((Object)new SMResult.Stay(updatedMetadataBuilder));
            } else {
                String currentState = state != null ? state.name() : "UNKNOWN";
                String reason = snapshot.reason();
                updatedMetadataBuilder.setLatestExecution(SMMetadata.LatestExecution.Status.FAILED, true, "Snapshot " + snapshotName + " creation failed as the snapshot is in the " + currentState + " state.", reason != null, (Exception)((Object)(reason != null ? new SnapshotManagementException(reason) : null)), Instant.now()).setCreationStarted(null);
                listener.onResponse((Object)new SMResult.Fail(updatedMetadataBuilder, WorkflowType.CREATION, true));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void checkAndUpdateNextCreationTime(SMPolicy job, SMMetadata metadata, SMMetadata.Builder metadataBuilder, Logger log) {
        if (metadata.getCreation() != null && metadata.getCreation().getTrigger() != null && metadata.getCreation().getTrigger().getTime() != null) {
            SMUtils.UpdateNextExecutionTimeResult result;
            Instant triggerTime = metadata.getCreation().getTrigger().getTime();
            if (job.getCreation() == null || job.getCreation().getSchedule() == null || (result = SMUtils.tryUpdatingNextExecutionTime(metadataBuilder, triggerTime, job.getCreation().getSchedule(), WorkflowType.CREATION, log)).isUpdated()) {
                // empty if block
            }
        }
    }

    private String getSnapshotCreationSucceedMessage(String snapshotName) {
        return "Snapshot " + snapshotName + " creation has finished successfully.";
    }

    private String getSnapshotMissingMessageInCreationWorkflow(String snapshotName) {
        return "Snapshot " + snapshotName + " not found while checking if it has been created.";
    }

    private String getSnapshotExceptionInCreationWorkflow(String snapshotName) {
        return "Caught exception while getting started creation snapshot [" + snapshotName + "].";
    }
}

