/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.snapshotmanagement.engine.states.deletion;

import io.lucenia.indexmanagement.snapshotmanagement.SMUtils;
import io.lucenia.indexmanagement.snapshotmanagement.engine.SMStateMachine;
import io.lucenia.indexmanagement.snapshotmanagement.engine.states.SMResult;
import io.lucenia.indexmanagement.snapshotmanagement.engine.states.State;
import io.lucenia.indexmanagement.snapshotmanagement.engine.states.WorkflowType;
import io.lucenia.indexmanagement.snapshotmanagement.model.SMMetadata;
import io.lucenia.indexmanagement.snapshotmanagement.model.SMPolicy;
import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.admin.cluster.snapshots.delete.DeleteSnapshotRequest;
import io.skylite.core.client.Client;
import io.skylite.core.snapshots.ConcurrentSnapshotExecutionException;
import io.skylite.core.snapshots.SnapshotInfo;
import io.skylite.core.snapshots.SnapshotState;
import io.skylite.core.transport.RemoteTransportException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;

public class DeletingState
implements State {
    public static final DeletingState INSTANCE = new DeletingState();

    private DeletingState() {
    }

    @Override
    public boolean isContinuous() {
        return false;
    }

    @Override
    public void execute(SMStateMachine context, ActionListener<State.Result> listener) {
        Client client = context.getClient();
        SMPolicy job = context.getJob();
        SMMetadata metadata = context.getMetadata();
        Logger log = context.getLog();
        SMMetadata.Builder metadataBuilder = new SMMetadata.Builder(metadata).workflow(WorkflowType.DELETION);
        if (job.getDeletion() == null) {
            log.warn("Policy deletion config becomes null before trying to delete old snapshots. Reset.");
            listener.onResponse((Object)new SMResult.Fail(metadataBuilder.resetDeletion(), WorkflowType.DELETION, true));
            return;
        }
        String snapshotPattern = job.getPolicyName() + "*";
        if (job.getDeletion().getSnapshotPattern() != null) {
            snapshotPattern = snapshotPattern + "," + job.getDeletion().getSnapshotPattern();
        }
        SMUtils.getSnapshots(client, job, snapshotPattern, metadataBuilder, log, this.getSnapshotsMissingMessage(), this.getSnapshotsErrorMessage(), (ActionListener<SMUtils.GetSnapshotsResult>)ActionListener.wrap(getSnapshotsRes -> {
            SMMetadata.Builder updatedMetadataBuilder = getSnapshotsRes.getMetadataBuilder();
            if (getSnapshotsRes.isFailed()) {
                listener.onResponse((Object)new SMResult.Fail(updatedMetadataBuilder, WorkflowType.DELETION));
                return;
            }
            List<SnapshotInfo> snapshots = getSnapshotsRes.getSnapshots().stream().collect(Collectors.groupingBy(s -> s.snapshotId().getName())).values().stream().map(list -> (SnapshotInfo)list.get(0)).filter(s -> s.state() != SnapshotState.IN_PROGRESS).collect(Collectors.toList());
            List<String> snapshotsToDelete = this.filterByDeleteCondition(snapshots, job.getDeletion().getCondition(), log);
            if (!snapshotsToDelete.isEmpty()) {
                try {
                    DeleteSnapshotRequest req = new DeleteSnapshotRequest((String)job.getSnapshotConfig().get("repository"), snapshotsToDelete.toArray(new String[0]));
                    client.admin().cluster().deleteSnapshot(req, ActionListener.wrap(response -> {
                        updatedMetadataBuilder.setLatestExecution(SMMetadata.LatestExecution.Status.IN_PROGRESS, true, this.getSnapshotDeletionStartedMessage(snapshotsToDelete), false, null, null).setDeletionStarted(snapshotsToDelete);
                        listener.onResponse((Object)new SMResult.Next(updatedMetadataBuilder));
                    }, ex -> {
                        Exception unwrappedException = ex instanceof RemoteTransportException ? (Exception)SkyliteExceptionsHelper.unwrapCause((Throwable)ex) : ex;
                        listener.onResponse((Object)this.handleException(unwrappedException, snapshotsToDelete, updatedMetadataBuilder, log));
                    }));
                }
                catch (Exception ex2) {
                    listener.onResponse((Object)this.handleException(ex2, snapshotsToDelete, updatedMetadataBuilder, log));
                }
            } else {
                listener.onResponse((Object)new SMResult.Next(updatedMetadataBuilder));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private SMResult handleException(Exception ex, List<String> snapshotsToDelete, SMMetadata.Builder metadataBuilder, Logger log) {
        if (ex instanceof ConcurrentSnapshotExecutionException) {
            log.error("Concurrent snapshot exception happened, retrying...", (Throwable)ex);
            metadataBuilder.setLatestExecution(SMMetadata.LatestExecution.Status.RETRYING, true, "Concurrent snapshot exception happened, retrying...", false, null, null);
            return new SMResult.Stay(metadataBuilder);
        }
        log.error(this.getDeleteSnapshotErrorMessage(snapshotsToDelete), (Throwable)ex);
        metadataBuilder.setLatestExecution(SMMetadata.LatestExecution.Status.RETRYING, true, this.getDeleteSnapshotErrorMessage(snapshotsToDelete), true, ex, null);
        return new SMResult.Fail(metadataBuilder, WorkflowType.CREATION);
    }

    private String getSnapshotDeletionStartedMessage(List<String> snapshotNames) {
        return "Snapshots " + String.valueOf(snapshotNames) + " deletion has been started and waiting for completion.";
    }

    private String getSnapshotsMissingMessage() {
        return "No snapshots found under policy while getting snapshots to decide which snapshots to delete.";
    }

    private String getSnapshotsErrorMessage() {
        return "Caught exception while getting snapshots to decide which snapshots to delete.";
    }

    private String getDeleteSnapshotErrorMessage(List<String> snapshotNames) {
        return "Caught exception while deleting snapshot " + String.valueOf(snapshotNames) + ".";
    }

    private List<String> filterByDeleteCondition(List<SnapshotInfo> snapshots, SMPolicy.DeleteCondition deleteCondition, Logger log) {
        log.debug("Filter by delete condition: snapshotInfos " + String.valueOf(snapshots));
        ArrayList<SnapshotInfo> snapshotInfos = new ArrayList<SnapshotInfo>(snapshots);
        snapshotInfos.sort((a, b) -> Long.compare(a.startTime(), b.startTime()));
        log.debug("snapshotInfos sorted " + String.valueOf(snapshotInfos));
        int thresholdCount = 0;
        if (deleteCondition.getMaxAge() != null) {
            Instant timeThreshold = Instant.now().minusSeconds(deleteCondition.getMaxAge().seconds());
            log.debug("Time threshold: " + String.valueOf(timeThreshold));
            SnapshotInfo thresholdSnapshot = null;
            for (int i = snapshotInfos.size() - 1; i >= 0; --i) {
                if (!Instant.ofEpochMilli(((SnapshotInfo)snapshotInfos.get(i)).startTime()).isBefore(timeThreshold)) continue;
                thresholdSnapshot = (SnapshotInfo)snapshotInfos.get(i);
                break;
            }
            log.debug("ThresholdSnapshot: " + String.valueOf(thresholdSnapshot));
            thresholdCount = thresholdSnapshot != null ? snapshotInfos.indexOf(thresholdSnapshot) + 1 : 0;
            log.debug("ThresholdCount: " + thresholdCount);
            int minCount = deleteCondition.getMinCount();
            if (snapshotInfos.size() - thresholdCount < minCount) {
                thresholdCount = this.offsetThresholdCount(snapshotInfos.size() - minCount);
            }
        }
        if (deleteCondition.getMaxCount() != null && snapshotInfos.size() - thresholdCount > deleteCondition.getMaxCount()) {
            thresholdCount = snapshotInfos.size() - deleteCondition.getMaxCount();
        }
        return snapshotInfos.subList(0, thresholdCount).stream().map(s -> s.snapshotId().getName()).collect(Collectors.toList());
    }

    private int offsetThresholdCount(int count) {
        if (count < 0) {
            return 0;
        }
        return count;
    }
}

