/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.snapshotmanagement.engine.states.deletion;

import io.lucenia.indexmanagement.snapshotmanagement.SMUtils;
import io.lucenia.indexmanagement.snapshotmanagement.engine.SMStateMachine;
import io.lucenia.indexmanagement.snapshotmanagement.engine.states.SMResult;
import io.lucenia.indexmanagement.snapshotmanagement.engine.states.State;
import io.lucenia.indexmanagement.snapshotmanagement.engine.states.WorkflowType;
import io.lucenia.indexmanagement.snapshotmanagement.model.SMMetadata;
import io.lucenia.indexmanagement.snapshotmanagement.model.SMPolicy;
import io.skylite.common.action.ActionListener;
import java.time.Instant;
import org.apache.logging.log4j.Logger;

public class DeletionConditionMetState
implements State {
    public static final DeletionConditionMetState INSTANCE = new DeletionConditionMetState();

    private DeletionConditionMetState() {
    }

    @Override
    public boolean isContinuous() {
        return true;
    }

    @Override
    public void execute(SMStateMachine context, ActionListener<State.Result> listener) {
        Instant nextDeletionTime;
        SMPolicy job = context.getJob();
        SMMetadata metadata = context.getMetadata();
        Logger log = context.getLog();
        SMMetadata.Builder metadataBuilder = new SMMetadata.Builder(metadata).workflow(WorkflowType.DELETION);
        if (job.getDeletion() == null) {
            log.warn("Policy deletion config becomes null before checking if delete schedule met. Reset.");
            listener.onResponse((Object)new SMResult.Fail(metadataBuilder.resetDeletion(), WorkflowType.DELETION, true));
            return;
        }
        if (metadata.getDeletion() == null) {
            Instant nextTime = job.getDeletion().getSchedule().getNextExecutionTime(Instant.now());
            metadataBuilder.setNextDeletionTime(nextTime);
            nextDeletionTime = nextTime;
        } else {
            nextDeletionTime = metadata.getDeletion().getTrigger().getTime();
        }
        SMUtils.UpdateNextExecutionTimeResult updateNextTimeResult = SMUtils.tryUpdatingNextExecutionTime(metadataBuilder, nextDeletionTime, job.getDeletion().getSchedule(), WorkflowType.DELETION, log);
        if (!updateNextTimeResult.isUpdated()) {
            listener.onResponse((Object)new SMResult.Stay(metadataBuilder));
            return;
        }
        metadataBuilder = updateNextTimeResult.getMetadataBuilder();
        listener.onResponse((Object)new SMResult.Next(metadataBuilder));
    }
}

