/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.snapshotmanagement.engine.states.deletion;

import io.lucenia.indexmanagement.snapshotmanagement.SMUtils;
import io.lucenia.indexmanagement.snapshotmanagement.engine.SMStateMachine;
import io.lucenia.indexmanagement.snapshotmanagement.engine.states.SMResult;
import io.lucenia.indexmanagement.snapshotmanagement.engine.states.State;
import io.lucenia.indexmanagement.snapshotmanagement.engine.states.WorkflowType;
import io.lucenia.indexmanagement.snapshotmanagement.model.SMMetadata;
import io.lucenia.indexmanagement.snapshotmanagement.model.SMPolicy;
import io.skylite.common.action.ActionListener;
import io.skylite.core.client.Client;
import io.skylite.core.snapshots.SnapshotInfo;
import java.time.Instant;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;

public class DeletionFinishedState
implements State {
    public static final DeletionFinishedState INSTANCE = new DeletionFinishedState();

    private DeletionFinishedState() {
    }

    @Override
    public boolean isContinuous() {
        return true;
    }

    @Override
    public void execute(SMStateMachine context, ActionListener<State.Result> listener) {
        Client client = context.getClient();
        SMPolicy job = context.getJob();
        SMMetadata metadata = context.getMetadata();
        Logger log = context.getLog();
        SMMetadata.Builder metadataBuilder = new SMMetadata.Builder(metadata).workflow(WorkflowType.DELETION);
        if (metadata.getDeletion() == null || metadata.getDeletion().getStarted() == null) {
            listener.onResponse((Object)new SMResult.Next(metadataBuilder));
            return;
        }
        List<String> snapshotsStartedDeletion = metadata.getDeletion().getStarted();
        if (metadata.getDeletion().getLatestExecution() == null) {
            log.error("latest_execution is null while checking if snapshots [" + String.valueOf(snapshotsStartedDeletion) + "] deletion has finished. Reset.");
            metadataBuilder.resetWorkflow();
            listener.onResponse((Object)new SMResult.Next(metadataBuilder));
            return;
        }
        String snapshotPattern = job.getPolicyName() + "*";
        if (job.getDeletion() != null && job.getDeletion().getSnapshotPattern() != null) {
            snapshotPattern = snapshotPattern + "," + job.getDeletion().getSnapshotPattern();
        }
        SMUtils.getSnapshots(client, job, snapshotPattern, metadataBuilder, log, this.getSnapshotMissingMessageInDeletionWorkflow(), this.getSnapshotExceptionInDeletionWorkflow(snapshotsStartedDeletion), (ActionListener<SMUtils.GetSnapshotsResult>)ActionListener.wrap(getSnapshotsRes -> {
            SMMetadata.Builder updatedMetadataBuilder = getSnapshotsRes.getMetadataBuilder();
            if (getSnapshotsRes.isFailed()) {
                listener.onResponse((Object)new SMResult.Fail(updatedMetadataBuilder, WorkflowType.DELETION));
                return;
            }
            List snapshots = getSnapshotsRes.getSnapshots().stream().collect(Collectors.groupingBy(s -> s.snapshotId().getName())).values().stream().map(list -> (SnapshotInfo)list.get(0)).collect(Collectors.toList());
            Set existingSnapshotsNameSet = snapshots.stream().map(s -> s.snapshotId().getName()).collect(Collectors.toSet());
            HashSet remainingSnapshotsName = new HashSet(snapshotsStartedDeletion);
            remainingSnapshotsName.retainAll(existingSnapshotsNameSet);
            if (remainingSnapshotsName.isEmpty()) {
                String deletionMessage = "Snapshot(s) " + String.valueOf(snapshotsStartedDeletion) + " deletion has finished.";
                SMUtils.sendDeletionNotification(job.getNotificationConfig(), client, job.getPolicyName(), deletionMessage, job.getUser(), log);
                updatedMetadataBuilder.setLatestExecution(SMMetadata.LatestExecution.Status.SUCCESS, true, deletionMessage, false, null, Instant.now()).setDeletionStarted(null);
                this.checkAndUpdateNextDeletionTime(job, metadata, updatedMetadataBuilder, log);
                listener.onResponse((Object)new SMResult.Next(updatedMetadataBuilder));
            } else {
                if (job.getDeletion() != null && job.getDeletion().getTimeLimit() != null && SMUtils.isExceed(job.getDeletion().getTimeLimit(), metadata.getDeletion().getLatestExecution().getStartTime())) {
                    listener.onResponse((Object)SMUtils.timeLimitExceeded(job.getDeletion().getTimeLimit(), updatedMetadataBuilder, WorkflowType.DELETION, log));
                    return;
                }
                log.info("Retention snapshots haven't been deleted: " + String.valueOf(remainingSnapshotsName) + ".");
                this.checkAndUpdateNextDeletionTime(job, metadata, updatedMetadataBuilder, log);
                listener.onResponse((Object)new SMResult.Stay(updatedMetadataBuilder));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void checkAndUpdateNextDeletionTime(SMPolicy job, SMMetadata metadata, SMMetadata.Builder metadataBuilder, Logger log) {
        SMUtils.UpdateNextExecutionTimeResult result;
        if (job.getDeletion() == null || metadata.getDeletion() == null || metadata.getDeletion().getTrigger() == null || (result = SMUtils.tryUpdatingNextExecutionTime(metadataBuilder, metadata.getDeletion().getTrigger().getTime(), job.getDeletion().getSchedule(), WorkflowType.DELETION, log)).isUpdated()) {
            // empty if block
        }
    }

    private String getSnapshotMissingMessageInDeletionWorkflow() {
        return "No snapshots found under policy while getting snapshots to decide if snapshots has been deleted.";
    }

    private String getSnapshotExceptionInDeletionWorkflow(List<String> startedDeleteSnapshots) {
        return "Caught exception while getting snapshots to decide if snapshots [" + String.valueOf(startedDeleteSnapshots) + "] has been deleted.";
    }
}

