/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.snapshotmanagement.model;

import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.lucenia.indexmanagement.snapshotmanagement.model.SMMetadata;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Objects;

public class ExplainSMPolicy
implements ToXContentFragment,
Writeable {
    private final SMMetadata metadata;
    private final Boolean enabled;

    public ExplainSMPolicy(SMMetadata metadata, Boolean enabled) {
        this.metadata = metadata;
        this.enabled = enabled;
    }

    public ExplainSMPolicy(StreamInput sin) throws IOException {
        this(sin.readBoolean() ? new SMMetadata(sin) : null, sin.readOptionalBoolean());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.metadata != null);
        if (this.metadata != null) {
            this.metadata.writeTo(out);
        }
        out.writeOptionalBoolean(this.enabled);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.metadata != null) {
            builder.field("creation", (ToXContent)this.metadata.getCreation());
            LuceniaExtensions.optionalField(builder, "deletion", this.metadata.getDeletion());
            builder.field("policy_seq_no", this.metadata.getPolicySeqNo());
            builder.field("policy_primary_term", this.metadata.getPolicyPrimaryTerm());
        }
        return builder.field("enabled", this.enabled);
    }

    public SMMetadata getMetadata() {
        return this.metadata;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExplainSMPolicy that = (ExplainSMPolicy)o;
        return Objects.equals(this.metadata, that.metadata) && Objects.equals(this.enabled, that.enabled);
    }

    public int hashCode() {
        return Objects.hash(this.metadata, this.enabled);
    }
}

