/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.snapshotmanagement.model;

import io.lucenia.indexmanagement.common.model.notification.Channel;
import io.skylite.core.client.Client;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.notifications.model.EventSource;
import io.skylite.core.notifications.model.SeverityType;
import io.skylite.core.security.auth.User;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.Objects;
import org.apache.logging.log4j.Logger;

public class NotificationConfig
implements ToXContentObject,
Writeable {
    public static final String CHANNEL_FIELD = "channel";
    public static final String CONDITIONS_FIELD = "conditions";
    public static final String CREATION_TITLE = "Snapshot Management - Snapshot Creation Notification";
    public static final String DELETION_TITLE = "Snapshot Management - Snapshot Deletion Notification";
    public static final String FAILURE_TITLE = "Snapshot Management - Snapshot Failure Notification";
    public static final String TIME_LIMIT_EXCEEDED_TITLE = "Snapshot Management - Snapshot Time Limit Notification";
    private final Channel channel;
    private final Conditions conditions;

    public NotificationConfig(Channel channel, Conditions conditions) {
        this.channel = channel;
        this.conditions = conditions;
    }

    public NotificationConfig(StreamInput sin) throws IOException {
        this(new Channel(sin), new Conditions(sin));
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.channel.writeTo(out);
        this.conditions.writeTo(out);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field(CHANNEL_FIELD, (ToXContent)this.channel).field(CONDITIONS_FIELD, (ToXContent)this.conditions).endObject();
    }

    public void sendCreationNotification(Client client, String policyName, String message, User user, Logger log) {
        if (this.conditions.creation) {
            try {
                EventSource eventSource = new EventSource(CREATION_TITLE, policyName, SeverityType.INFO, null);
                this.channel.sendNotification(client, eventSource, message, user);
            }
            catch (Exception e) {
                log.error("Failed to send snapshot management creation notification for [" + policyName + "]", (Throwable)e);
            }
        }
    }

    public void sendDeletionNotification(Client client, String policyName, String message, User user, Logger log) {
        if (this.conditions.deletion) {
            try {
                EventSource eventSource = new EventSource(DELETION_TITLE, policyName, SeverityType.INFO, null);
                this.channel.sendNotification(client, eventSource, message, user);
            }
            catch (Exception e) {
                log.error("Failed to send snapshot management deletion notification for [" + policyName + "]", (Throwable)e);
            }
        }
    }

    public void sendTimeLimitExceededNotification(Client client, String policyName, String message, User user, Logger log) {
        if (this.conditions.timeLimitExceeded) {
            try {
                EventSource eventSource = new EventSource(TIME_LIMIT_EXCEEDED_TITLE, policyName, SeverityType.INFO, null);
                this.channel.sendNotification(client, eventSource, message, user);
            }
            catch (Exception e) {
                log.error("Failed to send snapshot management time limit exceeded notification for [" + policyName + "]", (Throwable)e);
            }
        }
    }

    public void sendFailureNotification(Client client, String policyName, String message, User user, Logger log) {
        if (this.conditions.failure) {
            try {
                EventSource eventSource = new EventSource(FAILURE_TITLE, policyName, SeverityType.INFO, null);
                this.channel.sendNotification(client, eventSource, message, user);
            }
            catch (Exception e) {
                log.error("Failed to send snapshot management failure notification for [" + policyName + "]", (Throwable)e);
            }
        }
    }

    public static NotificationConfig parse(XContentParser xcp) throws IOException {
        Channel channel = null;
        Conditions conditions = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block8: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "channel": {
                    channel = Channel.parse(xcp);
                    continue block8;
                }
                case "conditions": {
                    conditions = Conditions.parse(xcp);
                    continue block8;
                }
            }
            throw new IllegalArgumentException("Invalid field: [" + fieldName + "] found in Snapshot Management notification config.");
        }
        if (channel == null) {
            throw new IllegalArgumentException("Snapshot Management notification channel must not be null");
        }
        if (conditions == null) {
            conditions = new Conditions(true, false, false, false);
        }
        return new NotificationConfig(channel, conditions);
    }

    public Channel getChannel() {
        return this.channel;
    }

    public Conditions getConditions() {
        return this.conditions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationConfig that = (NotificationConfig)o;
        return Objects.equals(this.channel, that.channel) && Objects.equals(this.conditions, that.conditions);
    }

    public int hashCode() {
        return Objects.hash(this.channel, this.conditions);
    }

    public static class Conditions
    implements Writeable,
    ToXContent {
        public static final String CREATION_FIELD = "creation";
        public static final String DELETION_FIELD = "deletion";
        public static final String FAILURE_FIELD = "failure";
        public static final String TIME_LIMIT_EXCEEDED_FIELD = "time_limit_exceeded";
        private final boolean creation;
        private final boolean deletion;
        private final boolean failure;
        private final boolean timeLimitExceeded;

        public Conditions(boolean creation, boolean deletion, boolean failure, boolean timeLimitExceeded) {
            this.creation = creation;
            this.deletion = deletion;
            this.failure = failure;
            this.timeLimitExceeded = timeLimitExceeded;
        }

        public Conditions(StreamInput sin) throws IOException {
            this(sin.readBoolean(), sin.readBoolean(), sin.readBoolean(), sin.readBoolean());
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(this.creation);
            out.writeBoolean(this.deletion);
            out.writeBoolean(this.failure);
            out.writeBoolean(this.timeLimitExceeded);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().field(CREATION_FIELD, this.creation).field(DELETION_FIELD, this.deletion).field(FAILURE_FIELD, this.failure).field(TIME_LIMIT_EXCEEDED_FIELD, this.timeLimitExceeded).endObject();
        }

        public static Conditions parse(XContentParser xcp) throws IOException {
            boolean creation = true;
            boolean deletion = false;
            boolean failure = false;
            boolean timeLimitExceeded = false;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            block12: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = xcp.currentName();
                xcp.nextToken();
                switch (fieldName) {
                    case "creation": {
                        creation = xcp.booleanValue();
                        continue block12;
                    }
                    case "deletion": {
                        deletion = xcp.booleanValue();
                        continue block12;
                    }
                    case "failure": {
                        failure = xcp.booleanValue();
                        continue block12;
                    }
                    case "time_limit_exceeded": {
                        timeLimitExceeded = xcp.booleanValue();
                        continue block12;
                    }
                }
                throw new IllegalArgumentException("Invalid field: [" + fieldName + "] found in conditions.");
            }
            return new Conditions(creation, deletion, failure, timeLimitExceeded);
        }

        public boolean getCreation() {
            return this.creation;
        }

        public boolean getDeletion() {
            return this.deletion;
        }

        public boolean getFailure() {
            return this.failure;
        }

        public boolean getTimeLimitExceeded() {
            return this.timeLimitExceeded;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Conditions that = (Conditions)o;
            return this.creation == that.creation && this.deletion == that.deletion && this.failure == that.failure && this.timeLimitExceeded == that.timeLimitExceeded;
        }

        public int hashCode() {
            return Objects.hash(this.creation, this.deletion, this.failure, this.timeLimitExceeded);
        }
    }
}

