/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.snapshotmanagement.model;

import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.lucenia.indexmanagement.snapshotmanagement.SMUtils;
import io.lucenia.indexmanagement.snapshotmanagement.SnapshotManagementException;
import io.lucenia.indexmanagement.snapshotmanagement.engine.states.SMState;
import io.lucenia.indexmanagement.snapshotmanagement.engine.states.WorkflowType;
import io.skylite.LuceniaVersion;
import io.skylite.Version;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class SMMetadata
implements Writeable,
ToXContentObject {
    public static final String SM_METADATA_TYPE = "sm_metadata";
    public static final String POLICY_SEQ_NO_FIELD = "policy_seq_no";
    public static final String POLICY_PRIMARY_TERM_FIELD = "policy_primary_term";
    public static final String CREATION_FIELD = "creation";
    public static final String DELETION_FIELD = "deletion";
    private final long policySeqNo;
    private final long policyPrimaryTerm;
    private final WorkflowMetadata creation;
    private final WorkflowMetadata deletion;
    private final String id;
    private final long seqNo;
    private final long primaryTerm;

    public SMMetadata(long policySeqNo, long policyPrimaryTerm, WorkflowMetadata creation, WorkflowMetadata deletion, String id, long seqNo, long primaryTerm) {
        this.policySeqNo = policySeqNo;
        this.policyPrimaryTerm = policyPrimaryTerm;
        this.creation = creation;
        this.deletion = deletion;
        this.id = id;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
    }

    public SMMetadata(StreamInput sin) throws IOException {
        this.policySeqNo = sin.readLong();
        this.policyPrimaryTerm = sin.readLong();
        this.creation = sin.getVersion().onOrAfter((Version)LuceniaVersion.V_0_9_0) ? (WorkflowMetadata)sin.readOptionalWriteable(WorkflowMetadata::new) : new WorkflowMetadata(sin);
        this.deletion = (WorkflowMetadata)sin.readOptionalWriteable(WorkflowMetadata::new);
        this.id = sin.readString();
        this.seqNo = sin.readLong();
        this.primaryTerm = sin.readLong();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.policySeqNo);
        out.writeLong(this.policyPrimaryTerm);
        if (out.getVersion().onOrAfter((Version)LuceniaVersion.V_0_9_0)) {
            out.writeOptionalWriteable((Writeable)this.creation);
        } else {
            if (this.creation == null) {
                throw new IllegalStateException("creation must not be null for versions before 3.2.0");
            }
            this.creation.writeTo(out);
        }
        out.writeOptionalWriteable((Writeable)this.deletion);
        out.writeString(this.id);
        out.writeLong(this.seqNo);
        out.writeLong(this.primaryTerm);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (params.paramAsBoolean("with_type", true)) {
            builder.startObject(SM_METADATA_TYPE);
        }
        builder.field("name", SMUtils.smMetadataDocIdToPolicyName(this.id)).field(POLICY_SEQ_NO_FIELD, this.policySeqNo).field(POLICY_PRIMARY_TERM_FIELD, this.policyPrimaryTerm);
        LuceniaExtensions.optionalField(builder, CREATION_FIELD, this.creation);
        LuceniaExtensions.optionalField(builder, DELETION_FIELD, this.deletion);
        if (params.paramAsBoolean("with_type", true)) {
            builder.endObject();
        }
        return builder.endObject();
    }

    public static SMMetadata parse(XContentParser xcp, String id, long seqNo, long primaryTerm) throws IOException {
        Long policySeqNo = null;
        Long policyPrimaryTerm = null;
        WorkflowMetadata creation = null;
        WorkflowMetadata deletion = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "name": {
                    if (xcp.text() != null) break;
                    throw new IllegalArgumentException("The name field of SMPolicy must not be null.");
                }
                case "policy_seq_no": {
                    policySeqNo = xcp.longValue();
                    break;
                }
                case "policy_primary_term": {
                    policyPrimaryTerm = xcp.longValue();
                    break;
                }
                case "creation": {
                    creation = WorkflowMetadata.parse(xcp);
                    break;
                }
                case "deletion": {
                    deletion = WorkflowMetadata.parse(xcp);
                }
            }
        }
        if (policySeqNo == null) {
            throw new IllegalArgumentException("policy_seq_no field must not be null");
        }
        if (policyPrimaryTerm == null) {
            throw new IllegalArgumentException("policy_primary_term field must not be null");
        }
        return new SMMetadata(policySeqNo, policyPrimaryTerm, creation, deletion, id, seqNo, primaryTerm);
    }

    public static SMMetadata parse(XContentParser xcp) throws IOException {
        return SMMetadata.parse(xcp, "", -2L, 0L);
    }

    public static Map<String, Object> upsert(Map<String, Object> info, String key, String value) {
        HashMap<String, Object> result = info != null ? new HashMap<String, Object>(info) : new HashMap();
        result.put(key, value);
        return result;
    }

    public static Map<String, Object> remove(Map<String, Object> info, String key) {
        if (info == null) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(info);
        result.remove(key);
        return result;
    }

    public long getPolicySeqNo() {
        return this.policySeqNo;
    }

    public long getPolicyPrimaryTerm() {
        return this.policyPrimaryTerm;
    }

    public WorkflowMetadata getCreation() {
        return this.creation;
    }

    public WorkflowMetadata getDeletion() {
        return this.deletion;
    }

    public String getId() {
        return this.id;
    }

    public long getSeqNo() {
        return this.seqNo;
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SMMetadata that = (SMMetadata)o;
        return this.policySeqNo == that.policySeqNo && this.policyPrimaryTerm == that.policyPrimaryTerm && this.seqNo == that.seqNo && this.primaryTerm == that.primaryTerm && Objects.equals(this.creation, that.creation) && Objects.equals(this.deletion, that.deletion) && Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.policySeqNo, this.policyPrimaryTerm, this.creation, this.deletion, this.id, this.seqNo, this.primaryTerm);
    }

    public static class WorkflowMetadata
    implements Writeable,
    ToXContentObject {
        public static final String CURRENT_STATE_FIELD = "current_state";
        public static final String TRIGGER_FIELD = "trigger";
        public static final String STARTED_FIELD = "started";
        public static final String LAST_EXECUTION_FIELD = "latest_execution";
        private final SMState currentState;
        private final Trigger trigger;
        private final List<String> started;
        private final LatestExecution latestExecution;
        private final Retry retry;

        public WorkflowMetadata(SMState currentState, Trigger trigger, List<String> started, LatestExecution latestExecution, Retry retry) {
            this.currentState = currentState;
            this.trigger = trigger;
            this.started = started;
            this.latestExecution = latestExecution;
            this.retry = retry;
        }

        public WorkflowMetadata(StreamInput sin) throws IOException {
            this.currentState = (SMState)sin.readEnum(SMState.class);
            this.trigger = new Trigger(sin);
            this.started = sin.readOptionalStringList();
            this.latestExecution = (LatestExecution)sin.readOptionalWriteable(LatestExecution::new);
            this.retry = (Retry)sin.readOptionalWriteable(Retry::new);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeEnum((Enum)this.currentState);
            this.trigger.writeTo(out);
            out.writeOptionalStringCollection(this.started);
            out.writeOptionalWriteable((Writeable)this.latestExecution);
            out.writeOptionalWriteable((Writeable)this.retry);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject().field(CURRENT_STATE_FIELD, this.currentState.toString()).field(TRIGGER_FIELD, (ToXContent)this.trigger);
            LuceniaExtensions.optionalField(builder, STARTED_FIELD, this.started);
            LuceniaExtensions.optionalField(builder, LAST_EXECUTION_FIELD, this.latestExecution);
            LuceniaExtensions.optionalField(builder, "retry", this.retry);
            return builder.endObject();
        }

        public static WorkflowMetadata parse(XContentParser xcp) throws IOException {
            SMState currentState = null;
            Trigger trigger = null;
            List started = null;
            LatestExecution latestExecution = null;
            Retry retry = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = xcp.currentName();
                xcp.nextToken();
                switch (fieldName) {
                    case "current_state": {
                        currentState = SMState.valueOf(xcp.text());
                        break;
                    }
                    case "trigger": {
                        trigger = Trigger.parse(xcp);
                        break;
                    }
                    case "started": {
                        started = (List)LuceniaExtensions.nullValueHandler(xcp, p -> p.list().stream().map(Object::toString).collect(Collectors.toList()));
                        break;
                    }
                    case "latest_execution": {
                        latestExecution = (LatestExecution)LuceniaExtensions.nullValueHandler(xcp, LatestExecution::parse);
                        break;
                    }
                    case "retry": {
                        retry = (Retry)LuceniaExtensions.nullValueHandler(xcp, Retry::parse);
                    }
                }
            }
            if (currentState == null) {
                throw new IllegalArgumentException("current_state field must not be null");
            }
            if (trigger == null) {
                throw new IllegalArgumentException("trigger field must not be null.");
            }
            return new WorkflowMetadata(currentState, trigger, started, latestExecution, retry);
        }

        public SMState getCurrentState() {
            return this.currentState;
        }

        public Trigger getTrigger() {
            return this.trigger;
        }

        public List<String> getStarted() {
            return this.started;
        }

        public LatestExecution getLatestExecution() {
            return this.latestExecution;
        }

        public Retry getRetry() {
            return this.retry;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WorkflowMetadata that = (WorkflowMetadata)o;
            return this.currentState == that.currentState && Objects.equals(this.trigger, that.trigger) && Objects.equals(this.started, that.started) && Objects.equals(this.latestExecution, that.latestExecution) && Objects.equals(this.retry, that.retry);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.currentState, this.trigger, this.started, this.latestExecution, this.retry});
        }
    }

    public static class Builder {
        private SMMetadata metadata;
        private WorkflowType workflowType;

        public Builder(SMMetadata metadata) {
            this.metadata = metadata;
        }

        public SMMetadata build() {
            return this.metadata;
        }

        public Builder workflow(WorkflowType workflowType) {
            this.workflowType = workflowType;
            return this;
        }

        public Builder setCurrentState(SMState state) {
            switch (this.workflowType) {
                case CREATION: {
                    if (this.metadata.creation == null) break;
                    this.metadata = new SMMetadata(this.metadata.policySeqNo, this.metadata.policyPrimaryTerm, new WorkflowMetadata(state, this.metadata.creation.trigger, this.metadata.creation.started, this.metadata.creation.latestExecution, this.metadata.creation.retry), this.metadata.deletion, this.metadata.id, this.metadata.seqNo, this.metadata.primaryTerm);
                    break;
                }
                case DELETION: {
                    if (this.metadata.deletion == null) break;
                    this.metadata = new SMMetadata(this.metadata.policySeqNo, this.metadata.policyPrimaryTerm, this.metadata.creation, new WorkflowMetadata(state, this.metadata.deletion.trigger, this.metadata.deletion.started, this.metadata.deletion.latestExecution, this.metadata.deletion.retry), this.metadata.id, this.metadata.seqNo, this.metadata.primaryTerm);
                }
            }
            return this;
        }

        public Builder resetWorkflow() {
            SMState creationCurrentState = this.metadata.creation != null ? this.metadata.creation.currentState : null;
            List<String> startedCreation = this.metadata.creation != null ? this.metadata.creation.started : null;
            Retry creationRetry = this.metadata.creation != null ? this.metadata.creation.retry : null;
            SMState deletionCurrentState = this.metadata.deletion != null ? this.metadata.deletion.currentState : null;
            List<String> startedDeletion = this.metadata.deletion != null ? this.metadata.deletion.started : null;
            Retry deletionRetry = this.metadata.deletion != null ? this.metadata.deletion.retry : null;
            switch (this.workflowType) {
                case CREATION: {
                    creationCurrentState = SMState.CREATION_START;
                    startedCreation = null;
                    creationRetry = null;
                    break;
                }
                case DELETION: {
                    deletionCurrentState = SMState.DELETION_START;
                    startedDeletion = null;
                    deletionRetry = null;
                }
            }
            WorkflowMetadata newCreation = this.metadata.creation != null && creationCurrentState != null ? new WorkflowMetadata(creationCurrentState, this.metadata.creation.trigger, startedCreation, this.metadata.creation.latestExecution, creationRetry) : null;
            WorkflowMetadata newDeletion = this.metadata.deletion != null && deletionCurrentState != null ? new WorkflowMetadata(deletionCurrentState, this.metadata.deletion.trigger, startedDeletion, this.metadata.deletion.latestExecution, deletionRetry) : null;
            this.metadata = new SMMetadata(this.metadata.policySeqNo, this.metadata.policyPrimaryTerm, newCreation, newDeletion, this.metadata.id, this.metadata.seqNo, this.metadata.primaryTerm);
            return this;
        }

        public Builder resetDeletion() {
            this.metadata = new SMMetadata(this.metadata.policySeqNo, this.metadata.policyPrimaryTerm, this.metadata.creation, null, this.metadata.id, this.metadata.seqNo, this.metadata.primaryTerm);
            return this;
        }

        public Builder resetCreation() {
            this.metadata = new SMMetadata(this.metadata.policySeqNo, this.metadata.policyPrimaryTerm, null, this.metadata.deletion, this.metadata.id, this.metadata.seqNo, this.metadata.primaryTerm);
            return this;
        }

        public Builder setLatestExecution(LatestExecution.Status status, boolean updateMessage, String message, boolean updateCause, Exception cause, Instant endTime) {
            WorkflowMetadata updatedWorkflowMetadata;
            String messageWithTime = message != null ? SMUtils.preFixTimeStamp(message) : null;
            String causeWithTime = cause != null ? SMUtils.preFixTimeStamp(SnapshotManagementException.getUserErrorMessage(cause).getMessage()) : null;
            WorkflowMetadata workflowMetadata = this.getWorkflowMetadata();
            if (workflowMetadata == null) {
                return this;
            }
            if (workflowMetadata.started == null) {
                updatedWorkflowMetadata = new WorkflowMetadata(workflowMetadata.currentState, workflowMetadata.trigger, workflowMetadata.started, LatestExecution.init(status, new Info(messageWithTime, causeWithTime)), workflowMetadata.retry);
            } else {
                String finalMessage;
                String string = updateMessage ? messageWithTime : (this.metadata.creation != null && this.metadata.creation.latestExecution != null ? (this.metadata.creation.latestExecution.info != null ? this.metadata.creation.latestExecution.info.message : null) : (finalMessage = null));
                String finalCause = updateCause ? causeWithTime : (this.metadata.creation != null && this.metadata.creation.latestExecution != null ? (this.metadata.creation.latestExecution.info != null ? this.metadata.creation.latestExecution.info.cause : null) : null);
                updatedWorkflowMetadata = new WorkflowMetadata(workflowMetadata.currentState, workflowMetadata.trigger, workflowMetadata.started, new LatestExecution(status, workflowMetadata.latestExecution.startTime, endTime, new Info(finalMessage, finalCause)), workflowMetadata.retry);
            }
            switch (this.workflowType) {
                case CREATION: {
                    this.metadata = new SMMetadata(this.metadata.policySeqNo, this.metadata.policyPrimaryTerm, updatedWorkflowMetadata, this.metadata.deletion, this.metadata.id, this.metadata.seqNo, this.metadata.primaryTerm);
                    break;
                }
                case DELETION: {
                    this.metadata = new SMMetadata(this.metadata.policySeqNo, this.metadata.policyPrimaryTerm, this.metadata.creation, updatedWorkflowMetadata, this.metadata.id, this.metadata.seqNo, this.metadata.primaryTerm);
                }
            }
            return this;
        }

        public WorkflowMetadata getWorkflowMetadata() {
            switch (this.workflowType) {
                case CREATION: {
                    return this.metadata.creation;
                }
                case DELETION: {
                    return this.metadata.deletion;
                }
            }
            return null;
        }

        public WorkflowType getWorkflowType() {
            return this.workflowType;
        }

        public List<String> getStartedSnapshots() {
            switch (this.workflowType) {
                case CREATION: {
                    return this.metadata.creation != null ? this.metadata.creation.started : null;
                }
                case DELETION: {
                    return this.metadata.deletion != null ? this.metadata.deletion.started : null;
                }
            }
            return null;
        }

        public Builder setRetry(int count) {
            switch (this.workflowType) {
                case CREATION: {
                    if (this.metadata.creation == null) break;
                    this.metadata = new SMMetadata(this.metadata.policySeqNo, this.metadata.policyPrimaryTerm, new WorkflowMetadata(this.metadata.creation.currentState, this.metadata.creation.trigger, this.metadata.creation.started, this.metadata.creation.latestExecution, new Retry(count)), this.metadata.deletion, this.metadata.id, this.metadata.seqNo, this.metadata.primaryTerm);
                    break;
                }
                case DELETION: {
                    if (this.metadata.deletion == null) break;
                    this.metadata = new SMMetadata(this.metadata.policySeqNo, this.metadata.policyPrimaryTerm, this.metadata.creation, new WorkflowMetadata(this.metadata.deletion.currentState, this.metadata.deletion.trigger, this.metadata.deletion.started, this.metadata.deletion.latestExecution, new Retry(count)), this.metadata.id, this.metadata.seqNo, this.metadata.primaryTerm);
                }
            }
            return this;
        }

        public Builder resetRetry() {
            switch (this.workflowType) {
                case CREATION: {
                    if (this.metadata.creation == null || this.metadata.creation.retry == null) break;
                    this.metadata = new SMMetadata(this.metadata.policySeqNo, this.metadata.policyPrimaryTerm, new WorkflowMetadata(this.metadata.creation.currentState, this.metadata.creation.trigger, this.metadata.creation.started, this.metadata.creation.latestExecution, null), this.metadata.deletion, this.metadata.id, this.metadata.seqNo, this.metadata.primaryTerm);
                    break;
                }
                case DELETION: {
                    if (this.metadata.deletion == null || this.metadata.deletion.retry == null) break;
                    this.metadata = new SMMetadata(this.metadata.policySeqNo, this.metadata.policyPrimaryTerm, this.metadata.creation, new WorkflowMetadata(this.metadata.deletion.currentState, this.metadata.deletion.trigger, this.metadata.deletion.started, this.metadata.deletion.latestExecution, null), this.metadata.id, this.metadata.seqNo, this.metadata.primaryTerm);
                }
            }
            return this;
        }

        public Builder setSeqNoPrimaryTerm(long seqNo, long primaryTerm) {
            this.metadata = new SMMetadata(seqNo, primaryTerm, this.metadata.creation, this.metadata.deletion, this.metadata.id, this.metadata.seqNo, this.metadata.primaryTerm);
            return this;
        }

        public Builder setNextCreationTime(Instant time) {
            WorkflowMetadata creation = this.metadata.creation;
            this.metadata = creation != null ? new SMMetadata(this.metadata.policySeqNo, this.metadata.policyPrimaryTerm, new WorkflowMetadata(creation.currentState, new Trigger(time), creation.started, creation.latestExecution, creation.retry), this.metadata.deletion, this.metadata.id, this.metadata.seqNo, this.metadata.primaryTerm) : new SMMetadata(this.metadata.policySeqNo, this.metadata.policyPrimaryTerm, new WorkflowMetadata(SMState.CREATION_START, new Trigger(time), null, null, null), this.metadata.deletion, this.metadata.id, this.metadata.seqNo, this.metadata.primaryTerm);
            return this;
        }

        public Builder setCreationStarted(String snapshot) {
            if (this.metadata.creation != null) {
                this.metadata = new SMMetadata(this.metadata.policySeqNo, this.metadata.policyPrimaryTerm, new WorkflowMetadata(this.metadata.creation.currentState, this.metadata.creation.trigger, snapshot == null ? null : Collections.singletonList(snapshot), this.metadata.creation.latestExecution, this.metadata.creation.retry), this.metadata.deletion, this.metadata.id, this.metadata.seqNo, this.metadata.primaryTerm);
            }
            return this;
        }

        public Builder setNextDeletionTime(Instant time) {
            WorkflowMetadata deletion = this.metadata.deletion;
            this.metadata = deletion != null ? new SMMetadata(this.metadata.policySeqNo, this.metadata.policyPrimaryTerm, this.metadata.creation, new WorkflowMetadata(deletion.currentState, new Trigger(time), deletion.started, deletion.latestExecution, deletion.retry), this.metadata.id, this.metadata.seqNo, this.metadata.primaryTerm) : new SMMetadata(this.metadata.policySeqNo, this.metadata.policyPrimaryTerm, this.metadata.creation, new WorkflowMetadata(SMState.DELETION_START, new Trigger(time), null, null, null), this.metadata.id, this.metadata.seqNo, this.metadata.primaryTerm);
            return this;
        }

        public Builder setDeletionStarted(List<String> snapshots) {
            if (this.metadata.deletion != null) {
                this.metadata = new SMMetadata(this.metadata.policySeqNo, this.metadata.policyPrimaryTerm, this.metadata.creation, new WorkflowMetadata(this.metadata.deletion.currentState, this.metadata.deletion.trigger, snapshots, this.metadata.deletion.latestExecution, this.metadata.deletion.retry), this.metadata.id, this.metadata.seqNo, this.metadata.primaryTerm);
            }
            return this;
        }
    }

    public static class Retry
    implements Writeable,
    ToXContentObject {
        public static final String RETRY_FIELD = "retry";
        public static final String COUNT_FIELD = "count";
        private final int count;

        public Retry(int count) {
            this.count = count;
        }

        public Retry(StreamInput sin) throws IOException {
            this.count = sin.readInt();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeInt(this.count);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().field(COUNT_FIELD, this.count).endObject();
        }

        public static Retry parse(XContentParser xcp) throws IOException {
            Integer count = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = xcp.currentName();
                xcp.nextToken();
                if (!COUNT_FIELD.equals(fieldName)) continue;
                count = xcp.intValue();
            }
            if (count == null) {
                throw new IllegalArgumentException("count field in Retry must not be null.");
            }
            return new Retry(count);
        }

        public int getCount() {
            return this.count;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Retry retry = (Retry)o;
            return this.count == retry.count;
        }

        public int hashCode() {
            return Objects.hash(this.count);
        }
    }

    public static class Trigger
    implements Writeable,
    ToXContentObject {
        public static final String TIME_FIELD = "time";
        private final Instant time;

        public Trigger(Instant time) {
            this.time = time;
        }

        public Trigger(StreamInput sin) throws IOException {
            this.time = sin.readInstant();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeInstant(this.time);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            LuceniaExtensions.optionalTimeField(builder, TIME_FIELD, this.time);
            return builder.endObject();
        }

        public static Trigger parse(XContentParser xcp) throws IOException {
            Instant nextExecutionTime = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = xcp.currentName();
                xcp.nextToken();
                if (!TIME_FIELD.equals(fieldName)) continue;
                nextExecutionTime = LuceniaExtensions.instant(xcp);
            }
            if (nextExecutionTime == null) {
                throw new IllegalArgumentException("trigger time field must not be null.");
            }
            return new Trigger(nextExecutionTime);
        }

        public Instant getTime() {
            return this.time;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Trigger trigger = (Trigger)o;
            return Objects.equals(this.time, trigger.time);
        }

        public int hashCode() {
            return Objects.hash(this.time);
        }
    }

    public static class Info
    implements Writeable,
    ToXContentObject {
        public static final String MESSAGE_FIELD = "message";
        public static final String CAUSE_FIELD = "cause";
        private final String message;
        private final String cause;

        public Info(String message, String cause) {
            this.message = message;
            this.cause = cause;
        }

        public Info(StreamInput sin) throws IOException {
            this.message = sin.readOptionalString();
            this.cause = sin.readOptionalString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.message);
            out.writeOptionalString(this.cause);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            LuceniaExtensions.optionalField(builder, MESSAGE_FIELD, this.message);
            LuceniaExtensions.optionalField(builder, CAUSE_FIELD, this.cause);
            return builder.endObject();
        }

        public static Info parse(XContentParser xcp) throws IOException {
            String message = null;
            String cause = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = xcp.currentName();
                xcp.nextToken();
                switch (fieldName) {
                    case "message": {
                        message = xcp.text();
                        break;
                    }
                    case "cause": {
                        cause = xcp.text();
                    }
                }
            }
            return new Info(message, cause);
        }

        public String getMessage() {
            return this.message;
        }

        public String getCause() {
            return this.cause;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Info info = (Info)o;
            return Objects.equals(this.message, info.message) && Objects.equals(this.cause, info.cause);
        }

        public int hashCode() {
            return Objects.hash(this.message, this.cause);
        }
    }

    public static class LatestExecution
    implements Writeable,
    ToXContentObject {
        public static final String STATUS_FIELD = "status";
        public static final String START_TIME_FIELD = "start_time";
        public static final String END_TIME_FIELD = "end_time";
        public static final String INFO_FIELD = "info";
        private final Status status;
        private final Instant startTime;
        private final Instant endTime;
        private final Info info;

        public LatestExecution(Status status, Instant startTime, Instant endTime, Info info) {
            this.status = status;
            this.startTime = startTime;
            this.endTime = endTime;
            this.info = info;
        }

        public LatestExecution(StreamInput sin) throws IOException {
            this.status = (Status)sin.readEnum(Status.class);
            this.startTime = sin.readInstant();
            this.endTime = sin.readOptionalInstant();
            this.info = (Info)sin.readOptionalWriteable(Info::new);
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeEnum((Enum)this.status);
            out.writeInstant(this.startTime);
            out.writeOptionalInstant(this.endTime);
            out.writeOptionalWriteable((Writeable)this.info);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject().field(STATUS_FIELD, this.status.toString());
            LuceniaExtensions.optionalTimeField(builder, START_TIME_FIELD, this.startTime);
            LuceniaExtensions.optionalTimeField(builder, END_TIME_FIELD, this.endTime);
            LuceniaExtensions.optionalInfoField(builder, INFO_FIELD, this.info);
            return builder.endObject();
        }

        public static LatestExecution parse(XContentParser xcp) throws IOException {
            Status status = null;
            Instant startTime = null;
            Instant endTime = null;
            Info info = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = xcp.currentName();
                xcp.nextToken();
                switch (fieldName) {
                    case "status": {
                        status = Status.valueOf(xcp.text());
                        break;
                    }
                    case "start_time": {
                        startTime = LuceniaExtensions.instant(xcp);
                        break;
                    }
                    case "end_time": {
                        endTime = LuceniaExtensions.instant(xcp);
                        break;
                    }
                    case "info": {
                        info = Info.parse(xcp);
                    }
                }
            }
            if (status == null) {
                throw new IllegalArgumentException("last_execution.status must not be null");
            }
            if (startTime == null) {
                throw new IllegalArgumentException("last_execution.start_time must not be null");
            }
            return new LatestExecution(status, startTime, endTime, info);
        }

        public static LatestExecution init(Status status, Info info) {
            return new LatestExecution(status, Instant.now(), null, info);
        }

        public Status getStatus() {
            return this.status;
        }

        public Instant getStartTime() {
            return this.startTime;
        }

        public Instant getEndTime() {
            return this.endTime;
        }

        public Info getInfo() {
            return this.info;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LatestExecution that = (LatestExecution)o;
            return this.status == that.status && Objects.equals(this.startTime, that.startTime) && Objects.equals(this.endTime, that.endTime) && Objects.equals(this.info, that.info);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.status, this.startTime, this.endTime, this.info});
        }

        public static enum Status {
            IN_PROGRESS,
            RETRYING,
            SUCCESS,
            FAILED,
            TIME_LIMIT_EXCEEDED;

        }
    }
}

