/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.snapshotmanagement.model;

import io.lucenia.indexmanagement.luceniaapi.LuceniaExtensions;
import io.lucenia.indexmanagement.snapshotmanagement.SMUtils;
import io.lucenia.indexmanagement.snapshotmanagement.model.NotificationConfig;
import io.skylite.LuceniaVersion;
import io.skylite.Version;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.jobs.ScheduledJobParameter;
import io.skylite.core.jobs.schedule.Schedule;
import io.skylite.core.security.auth.User;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentParserUtils;
import io.skylite.jobs.schedule.CronSchedule;
import io.skylite.jobs.schedule.IntervalSchedule;
import io.skylite.jobs.schedule.ScheduleParser;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Map;
import java.util.Objects;

public class SMPolicy
implements ScheduledJobParameter,
Writeable {
    public static final String SM_TYPE = "sm_policy";
    public static final String SM_DOC_ID_SUFFIX = "-sm-policy";
    public static final String SM_METADATA_ID_SUFFIX = "-sm-metadata";
    public static final String NAME_FIELD = "name";
    public static final String DESCRIPTION_FIELD = "description";
    public static final String SCHEMA_VERSION_FIELD = "schema_version";
    public static final String CREATION_FIELD = "creation";
    public static final String DELETION_FIELD = "deletion";
    public static final String SNAPSHOT_CONFIG_FIELD = "snapshot_config";
    public static final String DATE_FORMAT_FIELD = "date_format";
    public static final String DATE_FORMAT_TIMEZONE_FIELD = "date_format_timezone";
    public static final String ENABLED_FIELD = "enabled";
    public static final String LAST_UPDATED_TIME_FIELD = "last_updated_time";
    public static final String ENABLED_TIME_FIELD = "enabled_time";
    public static final String SCHEDULE_FIELD = "schedule";
    public static final String NOTIFICATION_FIELD = "notification";
    public static final String USER_FIELD = "user";
    public static final String TIME_LIMIT_FIELD = "time_limit";
    private final String id;
    private final String description;
    private final long schemaVersion;
    private final Creation creation;
    private final Deletion deletion;
    private final Map<String, Object> snapshotConfig;
    private final boolean jobEnabled;
    private final Instant jobLastUpdateTime;
    private final Instant jobEnabledTime;
    private final Schedule jobSchedule;
    private final long seqNo;
    private final long primaryTerm;
    private final NotificationConfig notificationConfig;
    private final User user;

    public SMPolicy(String id, String description, long schemaVersion, Creation creation, Deletion deletion, Map<String, Object> snapshotConfig, boolean jobEnabled, Instant jobLastUpdateTime, Instant jobEnabledTime, Schedule jobSchedule, long seqNo, long primaryTerm, NotificationConfig notificationConfig, User user) {
        if (creation == null && deletion == null) {
            throw new IllegalArgumentException("Must provide either creation or deletion configuration.");
        }
        if (snapshotConfig.get("repository") == null || snapshotConfig.get("repository").equals("")) {
            throw new IllegalArgumentException("Must provide the repository in snapshot config.");
        }
        if (creation != null && creation.schedule.getNextExecutionTime(Instant.now()) == null) {
            throw new IllegalArgumentException("Next execution time from the creation schedule is null, please provide a valid cron expression.");
        }
        if (deletion != null && deletion.schedule.getNextExecutionTime(Instant.now()) == null) {
            throw new IllegalArgumentException("Next execution time from the deletion schedule is null, please provide a valid cron expression.");
        }
        this.id = id;
        this.description = description;
        this.schemaVersion = schemaVersion;
        this.creation = creation;
        this.deletion = deletion;
        this.snapshotConfig = snapshotConfig;
        this.jobEnabled = jobEnabled;
        this.jobLastUpdateTime = jobLastUpdateTime;
        this.jobEnabledTime = jobEnabledTime;
        this.jobSchedule = jobSchedule;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
        this.notificationConfig = notificationConfig;
        this.user = user;
    }

    public SMPolicy(StreamInput sin) throws IOException {
        this.description = sin.readOptionalString();
        this.schemaVersion = sin.readLong();
        this.creation = sin.getVersion().onOrAfter((Version)LuceniaVersion.V_0_9_0) ? (Creation)sin.readOptionalWriteable(Creation::new) : new Creation(sin);
        this.deletion = (Deletion)sin.readOptionalWriteable(Deletion::new);
        this.snapshotConfig = sin.readMap();
        this.jobLastUpdateTime = sin.readInstant();
        this.jobEnabledTime = sin.readOptionalInstant();
        this.jobSchedule = new IntervalSchedule(sin);
        this.jobEnabled = sin.readBoolean();
        this.id = sin.readString();
        this.seqNo = sin.readLong();
        this.primaryTerm = sin.readLong();
        this.notificationConfig = (NotificationConfig)sin.readOptionalWriteable(NotificationConfig::new);
        this.user = (User)sin.readOptionalWriteable(User::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalString(this.description);
        out.writeLong(this.schemaVersion);
        if (out.getVersion().onOrAfter((Version)LuceniaVersion.V_0_9_0)) {
            out.writeOptionalWriteable((Writeable)this.creation);
        } else {
            if (this.creation == null) {
                throw new IllegalStateException("Creation cannot be null for versions before V_3_3_0");
            }
            this.creation.writeTo(out);
        }
        out.writeOptionalWriteable((Writeable)this.deletion);
        out.writeMap(this.snapshotConfig);
        out.writeInstant(this.jobLastUpdateTime);
        out.writeOptionalInstant(this.jobEnabledTime);
        this.jobSchedule.writeTo(out);
        out.writeBoolean(this.jobEnabled);
        out.writeString(this.id);
        out.writeLong(this.seqNo);
        out.writeLong(this.primaryTerm);
        out.writeOptionalWriteable((Writeable)this.notificationConfig);
        out.writeOptionalWriteable((Writeable)this.user);
    }

    public String getName() {
        return this.id;
    }

    public String getPolicyName() {
        return SMUtils.smDocIdToPolicyName(this.id);
    }

    public String getMetadataID() {
        return SMUtils.smPolicyNameToMetadataDocId(SMUtils.smDocIdToPolicyName(this.id));
    }

    public Instant getLastUpdateTime() {
        return this.jobLastUpdateTime;
    }

    public Instant getEnabledTime() {
        return this.jobEnabledTime;
    }

    public Schedule getSchedule() {
        return this.jobSchedule;
    }

    public boolean isEnabled() {
        return this.jobEnabled;
    }

    public Long getLockDurationSeconds() {
        return 1800L;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (params.paramAsBoolean("with_type", true)) {
            builder.startObject(SM_TYPE);
        }
        builder.field(NAME_FIELD, SMUtils.smDocIdToPolicyName(this.id));
        LuceniaExtensions.optionalField(builder, DESCRIPTION_FIELD, this.description);
        builder.field(SCHEMA_VERSION_FIELD, this.schemaVersion);
        LuceniaExtensions.optionalField(builder, CREATION_FIELD, this.creation);
        LuceniaExtensions.optionalField(builder, DELETION_FIELD, this.deletion);
        builder.field(SNAPSHOT_CONFIG_FIELD, this.snapshotConfig);
        builder.field(SCHEDULE_FIELD, (ToXContent)this.jobSchedule);
        builder.field(ENABLED_FIELD, this.jobEnabled);
        LuceniaExtensions.optionalTimeField(builder, LAST_UPDATED_TIME_FIELD, this.jobLastUpdateTime);
        LuceniaExtensions.optionalTimeField(builder, ENABLED_TIME_FIELD, this.jobEnabledTime);
        LuceniaExtensions.optionalField(builder, NOTIFICATION_FIELD, this.notificationConfig);
        if (params.paramAsBoolean("with_user", true)) {
            LuceniaExtensions.optionalUserField(builder, USER_FIELD, this.user);
        }
        if (params.paramAsBoolean("with_type", true)) {
            builder.endObject();
        }
        return builder.endObject();
    }

    public static SMPolicy parse(XContentParser xcp, String id, long seqNo, long primaryTerm) throws IOException {
        String validMsg;
        String description = null;
        Creation creation = null;
        Deletion deletion = null;
        Map snapshotConfig = null;
        Instant lastUpdatedTime = null;
        long schemaVersion = 1L;
        Instant enabledTime = null;
        IntervalSchedule schedule = null;
        boolean enabled = true;
        NotificationConfig notificationConfig = null;
        User user = null;
        if (xcp.currentToken() == null) {
            xcp.nextToken();
        }
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "name": {
                    if (xcp.text() != null) break;
                    throw new IllegalArgumentException("The name field of SMPolicy must not be null.");
                }
                case "description": {
                    description = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : xcp.text();
                    break;
                }
                case "schema_version": {
                    schemaVersion = xcp.longValue();
                    break;
                }
                case "creation": {
                    creation = Creation.parse(xcp);
                    break;
                }
                case "deletion": {
                    deletion = Deletion.parse(xcp);
                    break;
                }
                case "snapshot_config": {
                    snapshotConfig = xcp.map();
                    break;
                }
                case "last_updated_time": {
                    lastUpdatedTime = LuceniaExtensions.instant(xcp);
                    break;
                }
                case "enabled_time": {
                    enabledTime = LuceniaExtensions.instant(xcp);
                    break;
                }
                case "schedule": {
                    schedule = ScheduleParser.parse((XContentParser)xcp);
                    break;
                }
                case "enabled": {
                    enabled = xcp.booleanValue();
                    break;
                }
                case "notification": {
                    notificationConfig = NotificationConfig.parse(xcp);
                    break;
                }
                case "user": {
                    user = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : User.parse((XContentParser)xcp);
                }
            }
        }
        if (enabled && enabledTime == null) {
            enabledTime = Instant.now();
        } else if (!enabled) {
            enabledTime = null;
        }
        if (lastUpdatedTime == null) {
            lastUpdatedTime = Instant.now();
        }
        if (schedule == null) {
            schedule = new IntervalSchedule(Instant.now(), 1, ChronoUnit.MINUTES);
        }
        if (deletion != null && !deletion.scheduleProvided) {
            if (creation == null) {
                throw new IllegalArgumentException("Schedule not provided for neither deletion policy nor creation policy");
            }
            deletion = new Deletion(creation.schedule, deletion.scheduleProvided, deletion.condition, deletion.timeLimit, deletion.snapshotPattern);
        }
        if (snapshotConfig == null) {
            throw new IllegalArgumentException("snapshot_config field must not be null");
        }
        if (snapshotConfig.get(DATE_FORMAT_FIELD) != null && (validMsg = SMUtils.validateDateFormat((String)snapshotConfig.get(DATE_FORMAT_FIELD))) != null) {
            throw new IllegalArgumentException("Please provide a valid date format. " + validMsg);
        }
        return new SMPolicy(id, description, schemaVersion, creation, deletion, snapshotConfig, enabled, lastUpdatedTime, enabledTime, (Schedule)schedule, seqNo, primaryTerm, notificationConfig, user);
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public long getSchemaVersion() {
        return this.schemaVersion;
    }

    public Creation getCreation() {
        return this.creation;
    }

    public Deletion getDeletion() {
        return this.deletion;
    }

    public Map<String, Object> getSnapshotConfig() {
        return this.snapshotConfig;
    }

    public boolean getJobEnabled() {
        return this.jobEnabled;
    }

    public Instant getJobLastUpdateTime() {
        return this.jobLastUpdateTime;
    }

    public Instant getJobEnabledTime() {
        return this.jobEnabledTime;
    }

    public Schedule getJobSchedule() {
        return this.jobSchedule;
    }

    public long getSeqNo() {
        return this.seqNo;
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public NotificationConfig getNotificationConfig() {
        return this.notificationConfig;
    }

    public User getUser() {
        return this.user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SMPolicy smPolicy = (SMPolicy)o;
        return this.schemaVersion == smPolicy.schemaVersion && this.jobEnabled == smPolicy.jobEnabled && this.seqNo == smPolicy.seqNo && this.primaryTerm == smPolicy.primaryTerm && Objects.equals(this.id, smPolicy.id) && Objects.equals(this.description, smPolicy.description) && Objects.equals(this.creation, smPolicy.creation) && Objects.equals(this.deletion, smPolicy.deletion) && Objects.equals(this.snapshotConfig, smPolicy.snapshotConfig) && Objects.equals(this.jobLastUpdateTime, smPolicy.jobLastUpdateTime) && Objects.equals(this.jobEnabledTime, smPolicy.jobEnabledTime) && Objects.equals(this.jobSchedule, smPolicy.jobSchedule) && Objects.equals(this.notificationConfig, smPolicy.notificationConfig) && Objects.equals(this.user, smPolicy.user);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.description, this.schemaVersion, this.creation, this.deletion, this.snapshotConfig, this.jobEnabled, this.jobLastUpdateTime, this.jobEnabledTime, this.jobSchedule, this.seqNo, this.primaryTerm, this.notificationConfig, this.user);
    }

    public static class Creation
    implements Writeable,
    ToXContent {
        public static final String SCHEDULE_FIELD = "schedule";
        private final Schedule schedule;
        private final TimeValue timeLimit;

        public Creation(Schedule schedule, TimeValue timeLimit) {
            this.schedule = schedule;
            this.timeLimit = timeLimit;
        }

        public Creation(StreamInput sin) throws IOException {
            this.schedule = new CronSchedule(sin);
            this.timeLimit = sin.readOptionalTimeValue();
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.schedule.writeTo(out);
            out.writeOptionalTimeValue(this.timeLimit);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject().field("schedule", (ToXContent)this.schedule);
            LuceniaExtensions.optionalField(builder, SMPolicy.TIME_LIMIT_FIELD, this.timeLimit);
            return builder.endObject();
        }

        public static Creation parse(XContentParser xcp) throws IOException {
            Schedule schedule = null;
            TimeValue timeLimit = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = xcp.currentName();
                xcp.nextToken();
                switch (fieldName) {
                    case "schedule": {
                        schedule = ScheduleParser.parse((XContentParser)xcp);
                        break;
                    }
                    case "time_limit": {
                        timeLimit = TimeValue.parseTimeValue((String)xcp.text(), (String)SMPolicy.TIME_LIMIT_FIELD);
                    }
                }
            }
            if (schedule == null) {
                throw new IllegalArgumentException("schedule field must not be null");
            }
            return new Creation(schedule, timeLimit);
        }

        public Schedule getSchedule() {
            return this.schedule;
        }

        public TimeValue getTimeLimit() {
            return this.timeLimit;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Creation creation = (Creation)o;
            return Objects.equals(this.schedule, creation.schedule) && Objects.equals(this.timeLimit, creation.timeLimit);
        }

        public int hashCode() {
            return Objects.hash(this.schedule, this.timeLimit);
        }
    }

    public static class Deletion
    implements Writeable,
    ToXContent {
        public static final String SCHEDULE_FIELD = "schedule";
        public static final String CONDITION_FIELD = "condition";
        public static final String SNAPSHOT_PATTERN_FIELD = "snapshot_pattern";
        private final Schedule schedule;
        private final boolean scheduleProvided;
        private final DeleteCondition condition;
        private final TimeValue timeLimit;
        private final String snapshotPattern;

        public Deletion(Schedule schedule, boolean scheduleProvided, DeleteCondition condition, TimeValue timeLimit, String snapshotPattern) {
            this.schedule = schedule;
            this.scheduleProvided = scheduleProvided;
            this.condition = condition;
            this.timeLimit = timeLimit;
            this.snapshotPattern = snapshotPattern;
        }

        public Deletion(StreamInput sin) throws IOException {
            this.schedule = new CronSchedule(sin);
            this.timeLimit = sin.readOptionalTimeValue();
            this.condition = new DeleteCondition(sin);
            this.snapshotPattern = sin.getVersion().onOrAfter((Version)LuceniaVersion.V_0_9_0) ? sin.readOptionalString() : null;
            this.scheduleProvided = true;
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.schedule.writeTo(out);
            out.writeOptionalTimeValue(this.timeLimit);
            this.condition.writeTo(out);
            if (out.getVersion().onOrAfter((Version)LuceniaVersion.V_0_9_0)) {
                out.writeOptionalString(this.snapshotPattern);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject().field("schedule", (ToXContent)this.schedule).field(CONDITION_FIELD, (ToXContent)this.condition);
            LuceniaExtensions.optionalField(builder, SMPolicy.TIME_LIMIT_FIELD, this.timeLimit);
            LuceniaExtensions.optionalField(builder, SNAPSHOT_PATTERN_FIELD, this.snapshotPattern);
            return builder.endObject();
        }

        public static Deletion parse(XContentParser xcp) throws IOException {
            CronSchedule schedule = null;
            TimeValue timeLimit = null;
            DeleteCondition condition = null;
            String snapshotPattern = null;
            boolean scheduleProvided = true;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = xcp.currentName();
                xcp.nextToken();
                switch (fieldName) {
                    case "schedule": {
                        schedule = ScheduleParser.parse((XContentParser)xcp);
                        break;
                    }
                    case "time_limit": {
                        timeLimit = TimeValue.parseTimeValue((String)xcp.text(), (String)SMPolicy.TIME_LIMIT_FIELD);
                        break;
                    }
                    case "condition": {
                        condition = DeleteCondition.parse(xcp);
                        break;
                    }
                    case "snapshot_pattern": {
                        snapshotPattern = xcp.text();
                    }
                }
            }
            if (schedule == null) {
                scheduleProvided = false;
                schedule = new CronSchedule("0 1 * * *", ZoneId.systemDefault());
            }
            if (condition == null) {
                throw new IllegalArgumentException("condition must not be null.");
            }
            return new Deletion((Schedule)schedule, scheduleProvided, condition, timeLimit, snapshotPattern);
        }

        public Schedule getSchedule() {
            return this.schedule;
        }

        public boolean getScheduleProvided() {
            return this.scheduleProvided;
        }

        public DeleteCondition getCondition() {
            return this.condition;
        }

        public TimeValue getTimeLimit() {
            return this.timeLimit;
        }

        public String getSnapshotPattern() {
            return this.snapshotPattern;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Deletion deletion = (Deletion)o;
            return this.scheduleProvided == deletion.scheduleProvided && Objects.equals(this.schedule, deletion.schedule) && Objects.equals(this.condition, deletion.condition) && Objects.equals(this.timeLimit, deletion.timeLimit) && Objects.equals(this.snapshotPattern, deletion.snapshotPattern);
        }

        public int hashCode() {
            return Objects.hash(this.schedule, this.scheduleProvided, this.condition, this.timeLimit, this.snapshotPattern);
        }
    }

    public static class DeleteCondition
    implements Writeable,
    ToXContent {
        public static final String MAX_COUNT_FIELD = "max_count";
        public static final String MAX_AGE_FIELD = "max_age";
        public static final String MIN_COUNT_FIELD = "min_count";
        private static final int DEFAULT_MIN_COUNT = 1;
        private final TimeValue maxAge;
        private final int minCount;
        private final Integer maxCount;

        public DeleteCondition(TimeValue maxAge, int minCount, Integer maxCount) {
            if (maxAge == null && maxCount == null) {
                throw new IllegalArgumentException("Please provide max_age or max_count.");
            }
            if (minCount <= 0) {
                throw new IllegalArgumentException("min_count should be bigger than 0.");
            }
            if (maxCount != null && maxCount - minCount <= 0) {
                throw new IllegalArgumentException("max_count should be bigger than min_count.");
            }
            this.maxAge = maxAge;
            this.minCount = minCount;
            this.maxCount = maxCount;
        }

        public DeleteCondition(StreamInput sin) throws IOException {
            this.maxCount = sin.readOptionalInt();
            this.maxAge = sin.readOptionalTimeValue();
            this.minCount = sin.readInt();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalInt(this.maxCount);
            out.writeOptionalTimeValue(this.maxAge);
            out.writeInt(this.minCount);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            LuceniaExtensions.optionalField(builder, MAX_AGE_FIELD, this.maxAge);
            builder.field(MIN_COUNT_FIELD, this.minCount);
            LuceniaExtensions.optionalField(builder, MAX_COUNT_FIELD, this.maxCount);
            return builder.endObject();
        }

        public static DeleteCondition parse(XContentParser xcp) throws IOException {
            TimeValue maxAge = null;
            int minCount = 1;
            Integer maxCount = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = xcp.currentName();
                xcp.nextToken();
                switch (fieldName) {
                    case "max_count": {
                        maxCount = xcp.intValue();
                        break;
                    }
                    case "max_age": {
                        maxAge = TimeValue.parseTimeValue((String)xcp.text(), (String)MAX_AGE_FIELD);
                        break;
                    }
                    case "min_count": {
                        minCount = xcp.intValue();
                    }
                }
            }
            return new DeleteCondition(maxAge, minCount, maxCount);
        }

        public TimeValue getMaxAge() {
            return this.maxAge;
        }

        public int getMinCount() {
            return this.minCount;
        }

        public Integer getMaxCount() {
            return this.maxCount;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DeleteCondition that = (DeleteCondition)o;
            return this.minCount == that.minCount && Objects.equals(this.maxAge, that.maxAge) && Objects.equals(this.maxCount, that.maxCount);
        }

        public int hashCode() {
            return Objects.hash(this.maxAge, this.minCount, this.maxCount);
        }
    }

    public static class Builder {
        private String id;
        private String description;
        private long schemaVersion;
        private Creation creation;
        private Deletion deletion;
        private Map<String, Object> snapshotConfig;
        private boolean jobEnabled;
        private Instant jobLastUpdateTime;
        private Instant jobEnabledTime;
        private Schedule jobSchedule;
        private long seqNo;
        private long primaryTerm;
        private NotificationConfig notificationConfig;
        private User user;

        public Builder(SMPolicy policy) {
            this.id = policy.id;
            this.description = policy.description;
            this.schemaVersion = policy.schemaVersion;
            this.creation = policy.creation;
            this.deletion = policy.deletion;
            this.snapshotConfig = policy.snapshotConfig;
            this.jobEnabled = policy.jobEnabled;
            this.jobLastUpdateTime = policy.jobLastUpdateTime;
            this.jobEnabledTime = policy.jobEnabledTime;
            this.jobSchedule = policy.jobSchedule;
            this.seqNo = policy.seqNo;
            this.primaryTerm = policy.primaryTerm;
            this.notificationConfig = policy.notificationConfig;
            this.user = policy.user;
        }

        public Builder schemaVersion(long schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public Builder user(User user) {
            this.user = user;
            return this;
        }

        public Builder lastUpdateTime(Instant lastUpdateTime) {
            this.jobLastUpdateTime = lastUpdateTime;
            return this;
        }

        public SMPolicy build() {
            return new SMPolicy(this.id, this.description, this.schemaVersion, this.creation, this.deletion, this.snapshotConfig, this.jobEnabled, this.jobLastUpdateTime, this.jobEnabledTime, this.jobSchedule, this.seqNo, this.primaryTerm, this.notificationConfig, this.user);
        }
    }
}

