/*
 * Decompiled with CFR 0.152.
 */
package io.lucenia.indexmanagement.snapshotmanagement.util;

import io.lucenia.indexmanagement.luceniaapi.ContentParserUtils;
import io.lucenia.indexmanagement.snapshotmanagement.model.SMPolicy;
import io.skylite.SkyliteStatusException;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.get.GetRequest;
import io.skylite.core.action.get.GetResponse;
import io.skylite.core.client.Client;
import io.skylite.core.common.Strings;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestStatus;
import io.skylite.core.xcontent.DeprecationHandler;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.MediaType;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentHelper;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.function.BiConsumer;

public class RestHandlerUtils {
    public static final String SM_POLICY_NAME_KEYWORD = "sm_policy.name";
    public static final String DEFAULT_SM_POLICY_SORT_FIELD = "sm_policy.name";

    private RestHandlerUtils() {
    }

    public static String smMetadataDocIdToPolicyName(String docId) {
        return docId.substring(0, docId.lastIndexOf("-sm-metadata"));
    }

    public static void getSMPolicy(Client client, String policyID, ActionListener<SMPolicy> listener) {
        RestHandlerUtils.getSMPolicy(client, policyID, listener, (response, callback) -> {
            try {
                SMPolicy policy = RestHandlerUtils.parseSMPolicy(response);
                callback.onResponse((Object)policy);
            }
            catch (Exception e) {
                callback.onFailure(e);
            }
        });
    }

    public static void getSMPolicy(Client client, String policyID, final ActionListener<SMPolicy> listener, final BiConsumer<GetResponse, ActionListener<SMPolicy>> parseHandler) {
        GetRequest getRequest = new GetRequest(".opendistro-ism-config", policyID);
        client.get(getRequest, (ActionListener)new ActionListener<GetResponse>(){

            public void onResponse(GetResponse response) {
                if (!response.isExists() || response.isSourceEmpty()) {
                    listener.onFailure((Exception)((Object)new SkyliteStatusException("Snapshot management policy not found", RestStatus.NOT_FOUND, new Object[0])));
                    return;
                }
                parseHandler.accept(response, listener);
            }

            public void onFailure(Exception e) {
                if (e instanceof IndexNotFoundException) {
                    listener.onFailure((Exception)((Object)new SkyliteStatusException("Snapshot management config index not found", RestStatus.NOT_FOUND, new Object[0])));
                } else if (e instanceof SkyliteStatusException) {
                    listener.onFailure(e);
                } else {
                    listener.onFailure((Exception)((Object)new SkyliteStatusException("Failed to retrieve Snapshot management policy.", RestStatus.NOT_FOUND, new Object[0])));
                }
            }
        });
    }

    public static SMPolicy parseSMPolicy(GetResponse response) throws IOException {
        return RestHandlerUtils.parseSMPolicy(response, NamedXContentRegistry.EMPTY);
    }

    public static SMPolicy parseSMPolicy(GetResponse response, NamedXContentRegistry xContentRegistry) throws IOException {
        XContentParser xcp = XContentHelper.createParser((NamedXContentRegistry)xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (BytesReference)response.getSourceAsBytesRef(), (MediaType)MediaTypeRegistry.JSON);
        return ContentParserUtils.parseWithType(xcp, response.getId(), response.getSeqNo(), response.getPrimaryTerm(), SMPolicy::parse);
    }

    public static String getValidSMPolicyName(RestRequest request) {
        String policyName = request.param("policyName", "");
        RestHandlerUtils.validateSMPolicyName(policyName);
        return policyName;
    }

    public static void validateSMPolicyName(String policyName) {
        ArrayList<Object> errorMessages = new ArrayList<Object>();
        if (policyName.isEmpty()) {
            errorMessages.add("Policy name cannot be empty.");
        }
        if (policyName.contains(" ")) {
            errorMessages.add("Policy name must not contain whitespace.");
        }
        if (policyName.contains(",")) {
            errorMessages.add("Policy name must not contain ','.");
        }
        if (policyName.contains("#")) {
            errorMessages.add("Policy name must not contain '#'.");
        }
        if (policyName.startsWith("_")) {
            errorMessages.add("Policy name must not start with '_'.");
        }
        if (!policyName.toLowerCase(Locale.ROOT).equals(policyName)) {
            errorMessages.add("Policy name must be lowercase.");
        }
        if (!Strings.validFileName((String)policyName)) {
            errorMessages.add("Policy name must not contain the following characters " + String.valueOf(Strings.INVALID_FILENAME_CHARS) + ".");
        }
        if (!errorMessages.isEmpty()) {
            throw new IllegalArgumentException(String.join((CharSequence)"\n", errorMessages));
        }
    }
}

